/*
 * Decompiled with CFR 0.152.
 */
package ui;

import docobj.DocEntry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import ui.App;
import win.Colors;

public class FrmFunctions
implements CommandListener {
    public App app;
    public List list;
    private final Command CMD_NEW;
    private final Command CMD_EDIT;
    private final Command CMD_DELETE;
    private final Command CMD_DUPLICATE;
    private final Command CMD_BRING_TO_FRONT;
    private final Command CMD_SEND_TO_BACK;
    private final Command CMD_CALCULUS;
    private final Command CMD_BACK;

    public FrmFunctions(App app) {
        this.app = app;
        this.CMD_NEW = new Command(this.app.langPack.get("NEW"), 8, 1);
        this.CMD_EDIT = new Command(this.app.langPack.get("EDIT"), 8, 2);
        this.CMD_DELETE = new Command(this.app.langPack.get("DELETE"), 8, 3);
        this.CMD_DUPLICATE = new Command(this.app.langPack.get("DUPLICATE"), 8, 4);
        this.CMD_BRING_TO_FRONT = new Command(this.app.langPack.get("BRING_TO_FRONT"), 8, 5);
        this.CMD_SEND_TO_BACK = new Command(this.app.langPack.get("SEND_TO_BACK"), 8, 6);
        this.CMD_CALCULUS = new Command(this.app.langPack.get("CALCULUS"), 8, 7);
        this.CMD_BACK = new Command(this.app.langPack.get("BACK"), 2, 1);
        this.list = new List(this.app.langPack.get("FUNCTIONS"), 3);
        this.list.addCommand(this.CMD_NEW);
        this.list.addCommand(this.CMD_EDIT);
        this.list.addCommand(this.CMD_DELETE);
        this.list.addCommand(this.CMD_DUPLICATE);
        this.list.addCommand(this.CMD_BRING_TO_FRONT);
        this.list.addCommand(this.CMD_SEND_TO_BACK);
        this.list.addCommand(this.CMD_CALCULUS);
        this.list.addCommand(this.CMD_BACK);
        this.list.setSelectCommand(this.CMD_EDIT);
        this.list.setCommandListener((CommandListener)this);
    }

    public void show() {
        this.app.display.setCurrent((Displayable)this.list);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_NEW) {
            this.onNew();
        } else if (command == this.CMD_EDIT) {
            this.onEdit();
        } else if (command == this.CMD_DELETE) {
            this.onDelete();
        } else if (command == this.CMD_DUPLICATE) {
            this.onDuplicate();
        } else if (command == this.CMD_BRING_TO_FRONT) {
            this.onMove(this.list.size() - 1);
        } else if (command == this.CMD_SEND_TO_BACK) {
            this.onMove(0);
        } else if (command == this.CMD_CALCULUS) {
            this.onCalculus();
        } else if (command == this.CMD_BACK) {
            this.onBack();
        }
    }

    private void onNew() {
        DocEntry docEntry = new DocEntry();
        this.app.doc.functionChanged(docEntry);
        this.app.doc.entries.addElement(docEntry);
        this.updateList();
        this.list.setSelectedIndex(this.list.size() - 1, true);
        this.onEdit();
    }

    private void onEdit() {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.app.frmEditEntry.index = n;
        this.app.frmEditEntry.updateForm();
        this.app.frmEditEntry.show();
    }

    private void onDelete() {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.app.doc.entries.removeElementAt(n);
        this.updateList();
    }

    private void onDuplicate() {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        DocEntry docEntry = this.app.doc.getEntry(n);
        this.app.doc.entries.insertElementAt(docEntry.clone(), n);
        this.updateList();
    }

    private void onMove(int n) {
        int n2 = this.list.getSelectedIndex();
        if (n2 < 0 || n2 == n) {
            return;
        }
        this.app.doc.moveEntry(n2, n);
        this.updateList();
    }

    private void onCalculus() {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        DocEntry docEntry = this.app.doc.getEntry(n);
        if (docEntry.kind == 2) {
            this.app.display.setCurrent((Displayable)new Alert(null, this.app.langPack.get("ERROR_CALCULUS_KIND"), null, AlertType.ERROR));
            return;
        }
        if (!docEntry.valid) {
            this.app.display.setCurrent((Displayable)new Alert(null, this.app.langPack.get("ERROR_SYNTAX"), null, AlertType.ERROR));
            return;
        }
        this.app.frmCalculus.index = n;
        this.app.frmCalculus.show();
    }

    private void onBack() {
        this.app.frmPlot.show();
    }

    public void updateList() {
        int n = this.list.getSelectedIndex();
        this.list.deleteAll();
        for (int i = 0; i < this.app.doc.entries.size(); ++i) {
            DocEntry docEntry = this.app.doc.getEntry(i);
            this.list.append(docEntry.toString(), Colors.createSwatch(docEntry.color, 15));
        }
        if (n >= 0 && n < this.list.size()) {
            this.list.setSelectedIndex(n, true);
        }
    }
}

