/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Hashtable;

public class ResourcesUTF8 {
    public static final char DELIMITER = '=';
    private Hashtable hashtable;
    private StringBuffer buffer = new StringBuffer();
    private boolean endFile = false;
    private String fileName;
    private boolean load = false;
    private boolean error = false;

    public ResourcesUTF8(String string) {
        this.fileName = string;
    }

    public String get(String string) {
        return this.get(string, null, true);
    }

    public String get(String string, String string2) {
        return this.get(string, string2, true);
    }

    public String get(String string, boolean bl) {
        return this.get(string, null, bl);
    }

    public String get(String string, String string2, boolean bl) {
        if (!this.load && !this.load()) {
            return bl ? "Error read " + this.fileName : null;
        }
        String string3 = (String)this.hashtable.get(string);
        if (string3 == null) {
            return bl ? "Error " + this.fileName + " '" + string + "' not found!" : null;
        }
        return string2 != null ? Utils.RepS(string3, string2) : string3;
    }

    public void remove(String string) {
        this.hashtable.remove(string);
    }

    public void unload() {
        this.hashtable = null;
        this.load = false;
        this.endFile = true;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        boolean bl;
        if (this.error) {
            return false;
        }
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                boolean bl2 = false;
                return bl2;
            }
            filterInputStream = new DataInputStream(inputStream);
            this.hashtable = new Hashtable();
            this.endFile = false;
            this.buffer = new StringBuffer();
            String string = this.readKey((DataInputStream)filterInputStream);
            while (string != null) {
                String string2;
                String string3 = string.trim();
                if (string3.length() > 0 && (string2 = this.readValue(filterInputStream)) != null) {
                    this.hashtable.put(string3, string2.trim());
                }
                string = this.readKey((DataInputStream)filterInputStream);
            }
            filterInputStream.close();
            this.load = true;
            bl = true;
        }
        catch (Exception exception) {
            this.error = true;
            this.unload();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private InputStream getInputStream() {
        if (this.error) {
            return null;
        }
        return this.getClass().getResourceAsStream(this.fileName);
    }

    private String readKey(DataInputStream dataInputStream) throws IOException {
        if (this.endFile) {
            return null;
        }
        this.buffer.setLength(0);
        int n = -1;
        while ((n = dataInputStream.read()) > 0 && n != 10 && n != 61) {
            char c = (char)n;
            this.buffer.append(c);
        }
        if (n == -1) {
            this.endFile = true;
            return null;
        }
        return this.buffer.toString();
    }

    private String readValue(InputStream inputStream) throws IOException {
        if (this.endFile) {
            return null;
        }
        this.buffer.setLength(0);
        int n = 0;
        block5: while ((n = inputStream.read()) > 0 && n != 10) {
            int n2 = n & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.buffer.append((char)n2);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int n3 = this.getByte(inputStream);
                    if ((n3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.buffer.append((char)((n2 & 0x1F) << 6 | n3 & 0x3F));
                    continue block5;
                }
                case 14: {
                    int n3 = this.getByte(inputStream);
                    int n4 = this.getByte(inputStream);
                    if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.buffer.append((char)((n2 & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return this.buffer.toString();
    }

    private int getByte(InputStream inputStream) throws IOException, UTFDataFormatException {
        int n = inputStream.read();
        if (n < 0 || n == 10) {
            this.endFile = true;
            throw new UTFDataFormatException();
        }
        return n;
    }
}

