/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import ui.ChGroupEx;
import ui.Colors;
import ui.Config;
import ui.GFont;
import ui.ItemEx;

public class FormEx
extends Canvas
implements CommandListener {
    private String cap;
    private Command cLeft;
    private Command cRight;
    private CommandListener cl;
    private Display display;
    static int fH;
    static int iH;
    static int cH;
    static int sW;
    private Vector vItems = new Vector();
    int curItem = 0;
    int topItem = 0;
    int visItems;
    int topY;
    TimerTask task;
    private Command c_sv = new Command("\u0421\u043e\u0445\u0440\u0430\u043d.", 4, 1);
    private Command c_bk = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);

    public FormEx(String string, Command command, Command command2) {
        this.cap = string;
        this.cLeft = command;
        this.cRight = command2;
        this.setFullScreenMode(true);
        this.visItems = this.getHeightInt() / iH;
        this.topY = (this.getHeightInt() - this.visItems * iH) / 2;
    }

    public ItemEx getItem(int n2) {
        return (ItemEx)this.vItems.elementAt(n2);
    }

    public int getCurrIndex() {
        return this.curItem;
    }

    private int getHeightInt() {
        return this.getHeight() - cH * 2;
    }

    private int getWidthInt() {
        return this.getWidth() - sW;
    }

    public int size() {
        return this.vItems.size();
    }

    public void remove(int n2) {
        ItemEx itemEx = this.getItem(n2);
        if (itemEx.parent == null) {
            this.vItems.removeElementAt(n2);
            if (n2 == this.curItem) {
                --this.curItem;
                this.repaint();
            }
        }
    }

    public void append(String string, boolean bl2) {
        this.vItems.addElement(new ItemEx(string, bl2));
    }

    public void append(Item item) {
        if (item.getLabel() != null) {
            this.append(this.getString(item.getLabel()), false);
        }
        if (item instanceof ChGroupEx) {
            ChGroupEx chGroupEx = (ChGroupEx)item;
            int n2 = 0;
            if (chGroupEx.type == 2) {
                n2 += 2;
            }
            for (int i2 = 0; i2 < chGroupEx.size(); ++i2) {
                this.vItems.addElement(new ItemEx((Object)chGroupEx, Colors.getImage((chGroupEx.isSelected(i2) ? n2 : n2 + 1) + ".png"), this.getString(chGroupEx.getString(i2)), i2));
            }
        } else if (item instanceof TextField) {
            this.vItems.addElement(new ItemEx(item, Colors.get("/ui/res/4.png"), this.getString(item), -1));
        } else if (item instanceof Gauge) {
            this.vItems.addElement(new ItemEx(item, null, null, -1));
        }
    }

    public void setListener(CommandListener commandListener) {
        this.cl = commandListener;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public boolean isLeft(Command command) {
        return command.equals(this.cLeft);
    }

    public boolean isRight(Command command) {
        return command.equals(this.cRight);
    }

    public String getString(Object object) {
        String string;
        if (object instanceof TextField) {
            TextField textField = (TextField)object;
            if (textField.getConstraints() == 65536) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < textField.getString().length(); ++i2) {
                    stringBuffer.append('*');
                }
                string = stringBuffer.toString();
            } else {
                string = textField.getString().length() > 0 ? textField.getString() : "...";
            }
        } else {
            string = (String)object;
        }
        return this.getShort(string);
    }

    private String getShort(String string) {
        if (GFont.font.getStringWidth(string) < this.getWidthInt() - 8) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (GFont.font.getStringWidth(stringBuffer.toString()) >= this.getWidthInt() - 38) {
                stringBuffer.append("...");
                break;
            }
            stringBuffer.append(string.charAt(i2));
        }
        return stringBuffer.toString();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Config.get(0));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawCursor(graphics);
        this.drawItems(graphics);
        this.drawScroller(graphics);
        this.drawCap(graphics);
        this.drawSoft(graphics);
    }

    private void drawCap(Graphics graphics) {
        Colors.drawRect(graphics, Config.get(4), Colors.transformColor(Config.get(4), -48), 0, 0, this.getWidth(), cH);
        if (this.cap != null) {
            GFont.font.drawString(graphics, 2, (cH - fH) / 2, this.cap, Config.get(11));
        }
    }

    private void drawSoft(Graphics graphics) {
        Colors.drawRect(graphics, Colors.transformColor(Config.get(4), -48), Config.get(4), 0, this.getHeight() - cH, this.getWidth(), this.getHeight());
        if (this.cLeft != null) {
            GFont.font.drawString(graphics, 2, this.getHeight() - cH + (cH - fH) / 2, this.cLeft.getLabel(), Config.get(11));
        }
        if (this.cRight != null) {
            GFont.font.drawString(graphics, this.getWidth() - GFont.font.getStringWidth(this.cRight.getLabel()), this.getHeight() - cH + (cH - fH) / 2, this.cRight.getLabel(), Config.get(11));
        }
    }

    private void drawItems(Graphics graphics) {
        int n2 = cH + this.topY;
        int n3 = (iH - fH) / 2;
        for (int i2 = 0; i2 < Math.min(this.visItems, this.size()); ++i2) {
            int n4;
            ItemEx itemEx = (ItemEx)this.vItems.elementAt(i2 + this.topItem);
            int n5 = i2 + this.topItem == this.curItem ? Colors.getInvColor(Config.get(8)) : Config.get(1);
            if (itemEx.parent instanceof ChGroupEx || itemEx.parent instanceof TextField) {
                n4 = 3;
                if (itemEx.icon != null) {
                    n4 += itemEx.icon.getWidth();
                    graphics.drawImage(itemEx.icon, 2, n2 + i2 * iH + itemEx.icon.getHeight() / 2, 6);
                }
                GFont.font.drawString(graphics, n4 + 1, n2 + i2 * iH + n3, itemEx.text, n5);
                continue;
            }
            if (itemEx.parent instanceof Gauge) {
                n4 = ((Gauge)itemEx.parent).getValue();
                int n6 = ((Gauge)itemEx.parent).getMaxValue();
                int n7 = 2 + (this.getWidthInt() - 8) * n4 / n6;
                Colors.drawGradient(graphics, 2, n2 + i2 * iH + 3, this.getWidthInt() - 8, iH - 6, Config.get(1), 8, -16, 16);
                Colors.drawGradient(graphics, 3, n2 + i2 * iH + 4, n7 - 6, iH - 8, Config.get(4), 8, 16, -16);
                continue;
            }
            GFont.font.drawString(graphics, 3, n2 + i2 * iH + n3, itemEx.text, n5);
        }
    }

    private void drawScroller(Graphics graphics) {
        int n2 = Colors.transformColor(Colors.transformColor(Config.get(0), 32), -32);
        if (n2 == 0) {
            n2 = 0x808080;
        }
        graphics.setStrokeStyle(0);
        int n3 = this.getWidth() - 4;
        graphics.setColor(Colors.transformColor(n2, -96));
        graphics.drawLine(n3, this.topY, n3, this.getHeight());
        graphics.setColor(Colors.transformColor(n2, -64));
        graphics.drawLine(n3 + 1, this.topY, n3 + 1, this.getHeight());
        graphics.setColor(Colors.transformColor(n2, -32));
        graphics.drawLine(n3 + 2, this.topY, n3 + 2, this.getHeight());
        graphics.setColor(n2);
        graphics.drawLine(n3 + 3, this.topY, n3 + 3, this.getHeight());
        if (this.size() > this.visItems) {
            int n4 = this.visItems * this.getHeightInt() / this.size();
            int n5 = cH + this.topItem * (this.getHeightInt() - n4) / (this.size() - this.visItems);
            graphics.setColor(Colors.transformColor(n2, -192));
            graphics.drawRect(n3, n5, sW - 1, n4);
            graphics.setColor(Colors.transformColor(Config.get(4), 96));
            graphics.drawLine(n3 + 1, n5 + 1, n3 + 1, n5 + n4 - 1);
            graphics.setColor(Config.get(4));
            graphics.drawLine(n3 + 2, n5 + 1, n3 + 2, n5 + n4 - 1);
        }
    }

    private void drawCursor(Graphics graphics) {
        Colors.drawGradient(graphics, 1, (this.curItem - this.topItem) * iH + this.topY + cH, this.getWidthInt() - 3, iH - 1, Config.get(8), 16, -32, 0);
        int n2 = Config.get(23);
        if (n2 == 0) {
            n2 = Colors.transformColor(Config.get(8), -48);
        }
        graphics.setColor(n2);
        graphics.drawRect(1, (this.curItem - this.topItem) * iH + this.topY + cH, this.getWidthInt() - 3, iH - 1);
    }

    private void moveCursor(int n2) {
        this.curItem += n2;
        if (this.curItem < 0) {
            this.curItem = this.size() - 1;
        }
        if (this.curItem == this.size()) {
            this.curItem = 0;
        }
        if (this.size() > this.visItems) {
            this.setTopItem(n2);
        }
    }

    void setTopItem(int n2) {
        if (n2 > 0) {
            if (this.curItem > this.visItems + this.topItem - 1 && this.topItem < this.size() - this.visItems) {
                this.topItem += n2;
            }
            if (this.curItem == 0) {
                this.topItem = 0;
            }
        } else {
            if (this.curItem == this.size() - 1) {
                this.topItem = this.size() - this.visItems;
            }
            if (this.curItem < this.topItem) {
                --this.topItem;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.c_sv) {
            TextField textField = (TextField)this.getItem((int)this.curItem).parent;
            textField.setString(((TextBox)displayable).getString());
            this.vItems.setElementAt(new ItemEx(textField, Colors.get("/ui/res/4.png"), textField.getString(), -1), this.curItem);
        }
        this.display.setCurrent((Displayable)this);
        this.setFullScreenMode(true);
    }

    public void keyPressed(int n2) {
        switch (this.getKeyEx(n2)) {
            case -6: {
                if (this.cLeft == null) break;
                this.execCommand(this.cLeft);
                break;
            }
            case -7: {
                if (this.cRight == null) break;
                this.execCommand(this.cRight);
                break;
            }
            case -11: {
                if (this.cLeft != null && this.cLeft.getCommandType() == 2) {
                    this.execCommand(this.cLeft);
                    break;
                }
                if (this.cRight == null || this.cRight.getCommandType() != 2) break;
                this.execCommand(this.cRight);
                break;
            }
            case 2: 
            case 5: 
            case 52: 
            case 54: {
                ItemEx itemEx = this.getItem(this.curItem);
                if (!(itemEx.parent instanceof Gauge)) break;
                Gauge gauge = (Gauge)itemEx.parent;
                gauge.setValue(gauge.getValue() + (n2 == 54 || this.getKeyEx(n2) == 5 ? 1 : -1));
                break;
            }
            case 8: 
            case 53: {
                ItemEx itemEx = this.getItem(this.curItem);
                if (itemEx.parent instanceof ChGroupEx) {
                    this.updateItems(itemEx);
                    break;
                }
                if (itemEx.parent instanceof TextField) {
                    if (this.display == null) break;
                    TextField textField = (TextField)itemEx.parent;
                    TextBox textBox = new TextBox(textField.getLabel(), textField.getString(), textField.getMaxSize(), textField.getConstraints());
                    textBox.addCommand(this.c_bk);
                    textBox.addCommand(this.c_sv);
                    textBox.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)textBox);
                    break;
                }
                if (itemEx.index != -2) break;
                this.cl.commandAction(List.SELECT_COMMAND, (Displayable)this);
                break;
            }
            case 6: 
            case 56: {
                this.moveCursor(1);
                break;
            }
            case 1: 
            case 50: {
                this.moveCursor(-1);
            }
        }
        this.repaint();
    }

    private void execCommand(Command command) {
        if (this.cl != null) {
            this.cl.commandAction(command, (Displayable)this);
        }
    }

    private void updateItems(ItemEx itemEx) {
        ChGroupEx chGroupEx = (ChGroupEx)((Object)itemEx.parent);
        chGroupEx.setSelectedIndex(itemEx.index, !chGroupEx.isSelected(itemEx.index));
        int n2 = 0;
        if (chGroupEx.type == 2) {
            n2 += 2;
        }
        if (chGroupEx.type == 1) {
            int n3;
            for (int i2 = n3 = this.curItem - itemEx.index; i2 < n3 + chGroupEx.size(); ++i2) {
                this.vItems.setElementAt(new ItemEx((Object)chGroupEx, Colors.getImage((chGroupEx.isSelected(i2 - n3) ? n2 : n2 + 1) + ".png"), chGroupEx.getString(i2 - n3), i2 - n3), i2);
            }
        } else {
            this.vItems.setElementAt(new ItemEx((Object)chGroupEx, Colors.getImage((chGroupEx.isSelected(itemEx.index) ? n2 : n2 + 1) + ".png"), chGroupEx.getString(itemEx.index), itemEx.index), this.curItem);
        }
    }

    public int getKeyEx(int n2) {
        if (this.getGameAction(n2) > 0) {
            return this.getGameAction(n2);
        }
        return n2;
    }

    public void keyRepeated(int n2) {
        switch (this.getKeyEx(n2)) {
            case 1: 
            case 6: 
            case 50: 
            case 56: {
                if (this.task != null) break;
                this.task = new Task(this.getKeyEx(n2));
            }
        }
    }

    public void keyReleased(int n2) {
        switch (this.getKeyEx(n2)) {
            case 1: 
            case 6: 
            case 50: 
            case 56: {
                if (this.task == null) break;
                this.task.cancel();
                this.task = null;
            }
        }
    }

    static {
        GFont.font = new GFont("/ui/res/font.prs");
        GFont.font.setImage("/ui/res/font.png");
        fH = GFont.font.getHeight();
        iH = Math.max(fH, 16);
        cH = fH + 2;
        sW = 4;
    }

    class Task
    extends TimerTask {
        String text;
        int mode;

        public Task(int n2) {
            this.mode = n2;
            if (n2 == 0) {
                ItemEx itemEx = FormEx.this.getItem(FormEx.this.curItem);
                this.text = itemEx.text;
            } else {
                new Timer().schedule((TimerTask)this, 60L, 60L);
            }
        }

        public void run() {
            if (this.mode == 56 || this.mode == 6) {
                FormEx.this.moveCursor(1);
            } else if (this.mode == 50 || this.mode == 1) {
                FormEx.this.moveCursor(-1);
            } else {
                this.text = this.text.substring(1, this.text.length());
                FormEx.this.vItems.setElementAt(new ItemEx(null, null, this.text, -1), FormEx.this.curItem);
            }
            FormEx.this.repaint();
        }
    }
}

