/*
 * Decompiled with CFR 0.152.
 */
public class ByteArrayBuffer {
    private int pos;
    private int limit;
    private byte[] array;

    public void set(byte[] byArray, int n, int n2) {
        this.array = byArray;
        this.pos = n;
        this.limit = n2;
    }

    public int getPosition() {
        return this.pos;
    }

    public boolean isEOF() {
        return this.limit == this.pos;
    }

    public void skip(int n) {
        this.pos += n;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        return this.array[this.pos++];
    }

    public int readUnsignedByte() {
        return this.array[this.pos++] & 0xFF;
    }

    public short readShort() {
        return (short)((this.array[this.pos++] & 0xFF) << 8 | (this.array[this.pos++] & 0xFF) << 0);
    }

    public int readUnsignedShort() {
        return (this.array[this.pos++] & 0xFF) << 8 | (this.array[this.pos++] & 0xFF) << 0;
    }

    public int readInt() {
        return (this.array[this.pos++] & 0xFF) << 24 | (this.array[this.pos++] & 0xFF) << 16 | (this.array[this.pos++] & 0xFF) << 8 | (this.array[this.pos++] & 0xFF) << 0;
    }

    public long readLong() {
        return (long)(this.array[this.pos++] & 0xFF) << 56 | (long)(this.array[this.pos++] & 0xFF) << 48 | (long)(this.array[this.pos++] & 0xFF) << 40 | (long)(this.array[this.pos++] & 0xFF) << 32 | (long)(this.array[this.pos++] & 0xFF) << 24 | (long)(this.array[this.pos++] & 0xFF) << 16 | (long)(this.array[this.pos++] & 0xFF) << 8 | (long)(this.array[this.pos++] & 0xFF) << 0;
    }

    public String readString() {
        int n;
        int n2 = this.readUnsignedShort();
        if (n2 == 0) {
            return "";
        }
        int n3 = this.pos + n2;
        int n4 = this.pos;
        int n5 = 0;
        while (n4 < n3) {
            ++n5;
            n = this.array[n4++] & 0xFF;
            switch (n >> 4) {
                case 12: 
                case 13: {
                    ++n4;
                    break;
                }
                case 14: {
                    n4 += 2;
                }
            }
        }
        char[] cArray = new char[n5];
        int n6 = 0;
        while (this.pos < n3) {
            int n7 = this.array[this.pos++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)n7;
                    break;
                }
                case 12: 
                case 13: {
                    n = this.array[this.pos++];
                    cArray[n6++] = (char)((n7 & 0x1F) << 6 | n & 0x3F);
                    break;
                }
                case 14: {
                    n = this.array[this.pos++];
                    byte by = this.array[this.pos++];
                    cArray[n6++] = (char)((n7 & 0xF) << 12 | (n & 0x3F) << 6 | (by & 0x3F) << 0);
                    break;
                }
            }
        }
        return new String(cArray);
    }

    public void read(byte[] byArray, int n, int n2) {
        Platform.arraycopy(this.array, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
    }

    public void writeByte(int n) {
        this.array[this.pos++] = (byte)n;
    }

    public void writeShort(int n) {
        this.array[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.array[this.pos++] = (byte)(n >>> 0 & 0xFF);
    }

    public void writeInt(int n) {
        this.array[this.pos++] = (byte)(n >>> 24 & 0xFF);
        this.array[this.pos++] = (byte)(n >>> 16 & 0xFF);
        this.array[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.array[this.pos++] = (byte)(n >>> 0 & 0xFF);
    }

    public void writeLong(long l) {
        this.array[this.pos++] = (byte)(l >>> 56 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 48 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 40 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 32 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 24 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 16 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 8 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 0 & 0xFFL);
    }

    public void writeString(String string) {
        char c;
        int n;
        if (string == null) {
            this.writeShort(0);
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        this.writeShort(n3);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.array[this.pos++] = (byte)c;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                this.array[this.pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                this.array[this.pos++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            this.array[this.pos++] = (byte)(0xE0 | 0xF & c >> 12);
            this.array[this.pos++] = (byte)(0x80 | 0x3F & c >> 6);
            this.array[this.pos++] = (byte)(0x80 | 0x3F & c);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        Platform.arraycopy(byArray, n, this.array, this.pos, n2);
        this.pos += n2;
    }
}

