/*
 * Decompiled with CFR 0.152.
 */
public final class Sprite {
    public static final long SPRITE_FEATURE_USE_FRAME_MASKS = 1L;
    public static final long SPRITE_FEATURE_LONG_MASK = 2L;
    public static final long SPRITE_FEATURE_MASK_REVERSED = 4L;
    public static final long SPRITE_FEATURE_MULTIPLE_COLLISION_BOXES = 8L;
    public static final byte ROT_R = 0;
    public static final byte ROT_L = 1;
    private static final boolean DEBUG_READING = false;
    private static final boolean DEBUG_IMG_PART = false;
    private static final byte PATH_OFFSET_MODE = 0;
    private static final byte PATH_OFFSET_LOOP = 1;
    private static final byte PATH_OFFSET_ENDACTION = 2;
    private static final byte PATH_OFFSET_DATA = 3;
    private static final byte PATH_MODE_ABSOLUTE_DIR = 0;
    private static final byte PATH_MODE_RELATIVE_DIR = 1;
    private static final byte PATH_MODE_ABSOLUTE_POS = 2;
    private static final byte PATH_MODE_RELATIVE_POS = 3;
    private static final byte PATH_MODE_INCLUDE_VARIANT = 16;
    private static final byte PATH_MODE_MOVING = 16;
    private static final byte PATH_MODE_VARIANT_SEQUENCE = 4;
    private static final int VARIANTS_OFFSET_SPRITE_TYPE = 0;
    private static final int VARIANTS_OFFSET_SIZE_X = 1;
    private static final int VARIANTS_OFFSET_SIZE_Y = 2;
    private static final int VARIANTS_OFFSET_SIZE_X2 = 3;
    private static final int VARIANTS_OFFSET_SIZE_Y2 = 4;
    private static final int FRAME_PARAMETER_SIZE = 5;
    private static final int SPRITE_TYPE_1_ORIENTATION = 1;
    private static final int SPRITE_TYPE_HORIZONTAL = 2;
    private static final int PART_OFFSET_X = 0;
    private static final int PART_OFFSET_Y = 1;
    private static final int PART_FRAGMENT_INDEX_0 = 2;
    private static final int PART_FRAGMENT_INDEX_1 = 3;
    private static final int PART_PARAMETER_SIZE = 4;
    public int cacheIndex;
    private short[] bounds;
    private short[][] paths;
    private byte[][] variants;
    public int posX;
    public int posY;
    public boolean visible = true;
    public byte maskIndex = (byte)-1;
    public byte colorVariant;
    public byte directOrientation = 0;
    private short variant = 0;
    public short playingPath = (short)-1;
    private short updateCursor = (short)-1;
    private short updateDuration;
    private short updateLoopCount;
    public static final int COLLISION_X1 = 0;
    public static final int COLLISION_Y1 = 1;
    public static final int COLLISION_X2 = 2;
    public static final int COLLISION_Y2 = 3;
    static Sprite[] sprites;
    private static int[] spritesRefcount;
    private static PlatformImage[] imageCache;
    private static byte[] imageColorVariantsCnt;
    private static boolean[] imageCacheBase;
    private static int[] imageCacheRefcount;
    private static byte[] fragmentCache;
    private static Sprite[] pool;
    private static int poolSize;

    public Sprite() {
    }

    public Sprite(int n) {
        this.init(sprites[n]);
    }

    public Sprite(Sprite sprite) {
        this.init(sprite);
    }

    public void init(int n) {
        this.init(sprites[n]);
    }

    public void init(Sprite sprite) {
        this.cacheIndex = sprite.cacheIndex;
        this.paths = sprite.paths;
        this.variants = sprite.variants;
        this.bounds = sprite.bounds;
        this.posX = sprite.posX;
        this.posY = sprite.posY;
        this.visible = sprite.visible;
        this.maskIndex = sprite.maskIndex;
        this.colorVariant = sprite.colorVariant;
        this.directOrientation = sprite.directOrientation;
        this.variant = sprite.variant;
        this.playingPath = sprite.playingPath;
        this.updateCursor = sprite.updateCursor;
        this.updateDuration = sprite.updateDuration;
        this.updateLoopCount = sprite.updateLoopCount;
    }

    public void paint(int n, int n2) {
        if (!this.visible || this.variant == -1) {
            return;
        }
        int n3 = n + this.posX;
        int n4 = n2 + this.posY;
        byte by = this.directOrientation;
        int n5 = 0;
        byte[] byArray = this.variants[this.variant];
        int n6 = byArray[0] & 3;
        if (n6 == 2 && by != 0) {
            n5 = 2;
        }
        long l = -1L;
        long l2 = 1L;
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n7 = 5;
        while (n7 < byArray.length) {
            if ((l & l2) == 0L) {
                n7 += 4;
            } else {
                int n8 = byArray[n7++];
                int n9 = byArray[n7++];
                byte by2 = byArray[n7++];
                byte by3 = byArray[n7++];
                int n10 = (by2 & 0xFF) << 8 | by3 & 0xFF;
                int n11 = 5 * n10;
                int n12 = fragmentCache[n11++] & 0xFF;
                int n13 = fragmentCache[n11++] & 0xFF;
                int n14 = fragmentCache[n11++] & 0xFF;
                int n15 = fragmentCache[n11++] & 0xFF;
                int n16 = fragmentCache[n11] & 0xFF;
                byte by4 = imageColorVariantsCnt[n16];
                byte by5 = this.colorVariant < (by4 & 0x7F) ? this.colorVariant : (byte)0;
                PlatformImage platformImage = null;
                platformImage = imageCache[n16 += by5];
                if (n5 == 2) {
                    n8 = -n8 - n14;
                }
                platformGraphics.drawRegion(platformImage, n12, n13, n14, n15, n5, n8 += n3, n9 += n4, 20);
            }
            l2 <<= 1;
        }
    }

    public void update() {
        short s;
        short s2;
        if (this.playingPath == -1 || this.updateCursor == -1) {
            return;
        }
        short[] sArray = this.paths[this.playingPath];
        if (sArray == null) {
            return;
        }
        while ((this.updateDuration = (short)(this.updateDuration - 1)) == -1) {
            if (this.updateCursor == sArray.length) {
                this.updateLoopCount = (short)(this.updateLoopCount + 1);
                if (this.updateLoopCount >= sArray[1] && sArray[1] > 0) {
                    this.updateCursor = (short)-1;
                    GameCommon gameCommon = GMain.game;
                    if (gameCommon != null) {
                        gameCommon.pathEnded(this, this.playingPath, sArray[2]);
                    }
                    return;
                }
                this.updateCursor = (short)3;
                this.updateDuration = 0;
                continue;
            }
            short s3 = this.updateCursor;
            this.updateCursor = (short)(s3 + 1);
            this.updateDuration = sArray[s3];
            if (sArray[0] != 4) {
                short s4 = this.updateCursor;
                this.updateCursor = (short)(s4 + 1);
                s2 = sArray[s4];
                short s5 = this.updateCursor;
                this.updateCursor = (short)(s5 + 1);
                s = sArray[s5];
            }
            short s6 = this.updateCursor;
            this.updateCursor = (short)(s6 + 1);
            this.variant = sArray[s6];
        }
        if (sArray[0] != 4) {
            s2 = sArray[this.updateCursor - 3];
            s = sArray[this.updateCursor - 2];
            this.posX += s2;
            this.posY += s;
        }
    }

    public void stop() {
        this.playingPath = (short)-1;
        this.updateCursor = (short)-1;
    }

    public boolean isPlaying() {
        return this.playingPath >= 0 && this.updateCursor > 0;
    }

    public int getPlayPath() {
        return this.playingPath;
    }

    public void playPath(int n) {
        if (this.playingPath != n || this.updateCursor == -1) {
            this.startPath(n);
        }
    }

    public void startPath(int n) {
        this.playingPath = (short)n;
        this.updateCursor = (short)3;
        this.updateDuration = 0;
        this.updateLoopCount = 0;
    }

    public void setVariant(int n, int n2) {
        short[] sArray = this.paths[n];
        int n3 = sArray[0] != 4 ? 4 * n2 + 3 : 2 * n2 + 1;
        this.variant = sArray[3 + n3];
    }

    public int getFrame() {
        if (!this.isPlaying()) {
            return -1;
        }
        short[] sArray = this.paths[this.playingPath];
        int n = sArray[0] != 4 ? (this.updateCursor - 3) / 4 : (this.updateCursor - 3) / 2;
        return n - 1;
    }

    public int getMasksCount() {
        return 0;
    }

    public int getPathsCount() {
        return this.paths.length;
    }

    public int getFramesCount() {
        return this.playingPath >= 0 ? this.getFramesCount(this.playingPath) : 0;
    }

    public int getFramesCount(int n) {
        short[] sArray = this.paths[n];
        int n2 = sArray.length;
        if (sArray[0] != 4) {
            return (n2 - 3) / 4;
        }
        return (n2 - 3) / 2;
    }

    public int getColorsCount() {
        int n = 0;
        byte[] byArray = this.variants[this.variant];
        for (int i = 5; i < byArray.length; i += 4) {
            byte by = byArray[i++];
            byte by2 = byArray[i++];
            byte by3 = byArray[i++];
            byte by4 = byArray[i++];
            int n2 = (by3 & 0xFF) << 8 | by4 & 0xFF;
            int n3 = 5 * n2;
            int n4 = fragmentCache[n3 + 4] & 0xFF;
            int n5 = imageColorVariantsCnt[n4] & 0x7F;
            n = Math.max(n, n5);
        }
        return n;
    }

    public PlatformImage getFragmentImage(int n) {
        byte[] byArray = this.variants[this.variant];
        int n2 = 5 + 4 * n;
        Platform.assertTrue(n2 > 0 && n2 < byArray.length, "illegal fragmentId " + byArray.length);
        n2 += 2;
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        int n3 = (short)((short)(by & 0xFF) << 8) | (short)(by2 & 0xFF);
        int n4 = fragmentCache[(n3 *= 5) + 4] & 0xFF;
        int n5 = imageColorVariantsCnt[n4] & 0x7F;
        Platform.assertTrue(n5 > 0 && this.colorVariant < n5, "Sprite.getFragmentImage");
        return imageCache[n4 + this.colorVariant];
    }

    public void getFragmentBounds(int n, int[] nArray) {
        byte[] byArray = this.variants[this.variant];
        int n2 = 5 + 4 * n;
        Platform.assertTrue(n2 > 0 && n2 < byArray.length, "illegal fragmentId " + byArray.length);
        n2 += 2;
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        int n3 = (short)((short)(by & 0xFF) << 8) | (short)(by2 & 0xFF);
        nArray[0] = fragmentCache[(n3 *= 5) + 0] & 0xFF;
        nArray[1] = fragmentCache[n3 + 1] & 0xFF;
        nArray[2] = fragmentCache[n3 + 2] & 0xFF;
        nArray[3] = fragmentCache[n3 + 3] & 0xFF;
    }

    public int getWidth() {
        return this.getSizeX2() - this.getSizeX();
    }

    public int getHeight() {
        return this.getSizeY2() - this.getSizeY();
    }

    public int getCollision(int n) {
        return this.variants[this.variant][1 + n];
    }

    public int getSizeX() {
        if (this.variant >= this.variants.length) {
            Platform.log("ASSERT: spatne zvolena varianta " + this.variant);
            return 0;
        }
        if (this.directOrientation != 0) {
            return -this.variants[this.variant][3];
        }
        return this.variants[this.variant][1];
    }

    public int getSizeY() {
        if (this.variant >= this.variants.length) {
            Platform.log("ASSERT: spatne zvolena varianta " + this.variant);
            return 0;
        }
        return this.variants[this.variant][2];
    }

    public int getSizeX2() {
        if (this.variant >= this.variants.length) {
            Platform.log("ASSERT: spatne zvolena varianta " + this.variant);
            return 0;
        }
        if (this.directOrientation != 0) {
            return -this.variants[this.variant][1];
        }
        return this.variants[this.variant][3];
    }

    public int getSizeY2() {
        if (this.variant >= this.variants.length) {
            Platform.log("ASSERT: spatne zvolena varianta " + this.variant);
            return 0;
        }
        return this.variants[this.variant][4];
    }

    public static boolean collide(Sprite sprite, int n, int n2, Sprite sprite2, int n3, int n4) {
        int n5 = n + sprite.posX + sprite.getSizeX();
        int n6 = n + sprite.posX + sprite.getSizeX2();
        int n7 = n2 + sprite.posY + sprite.getSizeY();
        int n8 = n2 + sprite.posY + sprite.getSizeY2();
        int n9 = n3 + sprite2.posX + sprite2.getSizeX();
        int n10 = n3 + sprite2.posX + sprite2.getSizeX2();
        int n11 = n4 + sprite2.posY + sprite2.getSizeY();
        int n12 = n4 + sprite2.posY + sprite2.getSizeY2();
        return n6 >= n9 && n5 <= n10 && n8 >= n11 && n7 <= n12;
    }

    public static boolean collide(Sprite sprite, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + sprite.posX + sprite.getSizeX();
        int n8 = n + sprite.posX + sprite.getSizeX2();
        int n9 = n2 + sprite.posY + sprite.getSizeY();
        int n10 = n2 + sprite.posY + sprite.getSizeY2();
        int n11 = n3;
        int n12 = n3 + n5;
        int n13 = n4;
        int n14 = n4 + n6;
        return n8 >= n11 && n7 <= n12 && n10 >= n13 && n9 <= n14;
    }

    public static void initImageCache(int n) {
        imageCache = new PlatformImage[n];
        imageCacheBase = new boolean[n];
        imageCacheRefcount = new int[n];
        imageColorVariantsCnt = new byte[n];
    }

    public static void initDefCache(int n) {
        sprites = new Sprite[n];
        spritesRefcount = new int[n];
    }

    public void readDef(PlatformResource platformResource) {
        short s;
        int n;
        short s2 = platformResource.readShort();
        short s3 = platformResource.readShort();
        long l = platformResource.readLong();
        int n2 = platformResource.readShort();
        this.variants = new byte[n2][];
        for (n = 0; n < n2; ++n) {
            s = platformResource.readShort();
            byte[] byArray = new byte[5 + s * 4];
            platformResource.readFully(byArray);
            this.variants[n] = byArray;
        }
        this.paths = new short[platformResource.readShort()][];
        for (n = 0; n < this.paths.length; ++n) {
            s = platformResource.readShort();
            byte by = platformResource.readByte();
            int n3 = by == 4 ? 2 : 4;
            short[] sArray = new short[3 + s * n3];
            sArray[0] = by;
            sArray[1] = platformResource.readByte();
            sArray[2] = platformResource.readByte();
            for (int i = 3; i < sArray.length; ++i) {
                sArray[i] = platformResource.readShort();
            }
            this.paths[n] = sArray;
        }
        this.computeBounds();
    }

    public static void readFragments(PlatformResource platformResource) {
        int n;
        short s = platformResource.readShort();
        fragmentCache = new byte[5 * s];
        int n2 = 0;
        for (int i = n = platformResource.readShort(); i > 0; --i) {
            int n3 = platformResource.readShort();
            int n4 = platformResource.readUnsignedByte();
            for (int j = n3; j > 0; --j) {
                platformResource.readFully(fragmentCache, n2, 4);
                n2 += 4;
                Sprite.fragmentCache[n2++] = (byte)n4;
                Sprite.imageCacheBase[n4] = true;
            }
        }
    }

    public static void acquire(int n) {
        if (spritesRefcount[n] == 0) {
            int n2 = n;
            spritesRefcount[n2] = spritesRefcount[n2] + 1;
            sprites[n].markResourcesAll(1);
        }
    }

    public static void acquire(int n, int n2) {
        if (spritesRefcount[n] == 0) {
            int n3 = n;
            spritesRefcount[n3] = spritesRefcount[n3] + 1;
            sprites[n].markResourcesPath(n2, 1);
        }
    }

    public static void relaseAll(int[] nArray) {
        int n;
        byte[] byArray = new byte[sprites.length];
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                byArray[nArray[n]] = 1;
            }
        }
        for (int i = 0; i < sprites.length; ++i) {
            n = spritesRefcount[i];
            if (n <= 0 || byArray[i] == 1) continue;
            Sprite.spritesRefcount[i] = 0;
            sprites[i].markResourcesAll(-1 * n);
        }
        Sprite.ensureResources();
    }

    public static void release(int n) {
        if (n >= sprites.length) {
            return;
        }
        if (spritesRefcount[n] > 0) {
            int n2 = n;
            spritesRefcount[n2] = spritesRefcount[n2] - 1;
            sprites[n].markResourcesAll(-1);
        }
    }

    public static void release(int n, int n2) {
        if (n >= sprites.length) {
            return;
        }
        if (spritesRefcount[n] > 0) {
            int n3 = n;
            spritesRefcount[n3] = spritesRefcount[n3] - 1;
            sprites[n].markResourcesPath(n2, -1);
        }
    }

    private void markResourcesAll(int n) {
        for (int i = 0; i < this.variants.length; ++i) {
            this.markResourcesVariant(i, n);
        }
    }

    private void markResourcesPath(int n, int n2) {
        short[] sArray = this.paths[n];
        int n3 = this.getFramesCount(n);
        if (sArray[0] != 4) {
            for (int i = 0; i < n3; ++i) {
                int n4 = 3 + i * 4;
                this.markResourcesVariant(sArray[3 + n4], n2);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n5 = 1 + i * 2;
                this.markResourcesVariant(sArray[3 + n5], n2);
            }
        }
    }

    private void markResourcesVariant(int n, int n2) {
        byte[] byArray = this.variants[n];
        int n3 = 5;
        while (n3 < byArray.length) {
            int n4;
            n3 += 2;
            byte by = byArray[n3++];
            byte by2 = byArray[n3++];
            int n5 = (short)((short)(by & 0xFF) << 8) | (short)(by2 & 0xFF);
            int n6 = n4 = fragmentCache[5 * n5 + 4] & 0xFF;
            imageCacheRefcount[n6] = imageCacheRefcount[n6] + n2;
        }
    }

    public static void ensureResources() {
        int n;
        int n2;
        int n3 = imageCacheRefcount.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!imageCacheBase[n2] || imageCacheRefcount[n2] != 0 || imageCache[n2] == null) continue;
            n = n2;
            Sprite.imageCache[n] = null;
            int n4 = imageColorVariantsCnt[n] & 0x7F;
            Sprite.imageColorVariantsCnt[n] = 0;
            for (int i = 0; i < n4; ++i) {
                Sprite.imageCache[n + i] = null;
            }
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (!imageCacheBase[n] || imageCacheRefcount[n] <= 0 || imageCache[n] != null) continue;
            PlatformResource platformResource = Platform.getResource("/s" + n);
            Utils.readDiffImage(platformResource, imageCache, imageColorVariantsCnt, n, -1);
            platformResource.close();
            platformResource = null;
            if ((++n2 & 3) != 0) continue;
            GMain.updateProgress();
        }
    }

    public static Sprite createSprite(int n) {
        Sprite sprite = poolSize > 0 ? pool[--poolSize] : new Sprite();
        sprite.init(sprites[n]);
        return sprite;
    }

    public static void releaseSprite(Sprite sprite) {
        if (pool == null) {
            pool = new Sprite[16];
        } else if (poolSize == pool.length) {
            int n = 2 * pool.length;
            Sprite[] spriteArray = new Sprite[n];
            Platform.arraycopy(pool, 0, spriteArray, 0, pool.length);
            pool = spriteArray;
        }
        Sprite.pool[Sprite.poolSize++] = sprite;
    }

    public int getBounds(int n) {
        int n2 = 4 * this.variant;
        return this.bounds[n2 + n];
    }

    public boolean isVisible(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.visible || this.variant == -1) {
            return false;
        }
        n += this.posX;
        n2 += this.posY;
        int n7 = 4 * this.variant;
        short s = this.bounds[n7 + 0];
        short s2 = this.bounds[n7 + 1];
        short s3 = this.bounds[n7 + 2];
        short s4 = this.bounds[n7 + 3];
        byte[] byArray = this.variants[this.variant];
        int n8 = byArray[0] & 3;
        if (n8 == 2 && this.directOrientation != 0) {
            short s5 = s;
            s = -s3;
            s3 = -s5;
        }
        return Utils.intersectsBoxBox(n + s, n2 + s2, n + s3, n2 + s4, n3, n4, n5, n6);
    }

    private void computeBounds() {
        int n = this.variants.length;
        short[] sArray = new short[4 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.computeBounds(i, sArray, n2);
            n2 += 4;
        }
        this.bounds = sArray;
    }

    private void computeBounds(int n, short[] sArray, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = -2147483647;
        int n6 = -2147483647;
        byte[] byArray = this.variants[n];
        for (int i = 5; i < byArray.length; i += 4) {
            byte by = byArray[i];
            byte by2 = byArray[i + 1];
            byte by3 = byArray[i + 2];
            byte by4 = byArray[i + 3];
            int n7 = (by3 & 0xFF) << 8 | by4 & 0xFF;
            int n8 = 5 * n7;
            int n9 = fragmentCache[n8 + 2] & 0xFF;
            int n10 = fragmentCache[n8 + 3] & 0xFF;
            n3 = Math.min(n3, by);
            n4 = Math.min(n4, by2);
            n5 = Math.max(n5, by + n9);
            n6 = Math.max(n6, by2 + n10);
        }
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)n4;
        sArray[n2++] = (short)n5;
        sArray[n2++] = (short)n6;
    }
}

