/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer
implements PlayerListener {
    public static String debugString = "";
    private boolean playedSE = true;
    private boolean isSoundOn = true;
    public static int PLAYERMODE = 0;
    public static int PLAYERSTATE = 1;
    public int lastPlayingSound = -1;
    private int volume = 100;
    public int[] playerState;
    public static final int ISCLOSED = 0;
    public static final int ISSTOPPED = 300;
    public static final int ISPLAYING = 400;
    static final int INTERRUPTABLE = 0;
    static final int NOTINTERRUPTABLE = 1;
    public static final int PLAYINIFINIT = -1;
    private static final String fileExt = ".mid";
    private int bgmNr = 0;
    private String[] sourceNames = null;
    private byte[][] sourceBuff = null;
    private Player player;

    public SoundPlayer() {
    }

    public SoundPlayer(String[] soundList) {
        this.initPlayer(soundList);
    }

    public synchronized boolean initPlayer(String[] soundList) {
        try {
            int i;
            this.sourceNames = new String[soundList.length];
            for (i = 0; i < soundList.length; ++i) {
                this.sourceNames[i] = soundList[i].indexOf(47) != 0 ? "/" + soundList[i] + fileExt : soundList[i] + fileExt;
                this.warn("sound player: " + this.sourceNames[i]);
            }
            this.playerState = new int[3];
            this.sourceBuff = new byte[this.sourceNames.length][];
            for (i = 0; i < this.sourceNames.length; ++i) {
                this.sourceBuff[i] = this.readDataFromJar(this.sourceNames[i]);
            }
        }
        catch (Exception e2) {
            this.warn("Error: SoundPlayer, no sources: " + e2);
            return false;
        }
        return true;
    }

    public synchronized boolean createPlayer(int playerNr) {
        this.warn("sound player: create");
        try {
            InputStream is = this.getInputStream(playerNr);
            this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            try {
                this.player.realize();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.player.prefetch();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                this.player.addPlayerListener((PlayerListener)this);
            }
            catch (Exception e4) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            is = null;
            this.setVolume(this.volume);
            Thread.yield();
            this.warn("sound player: created");
        }
        catch (Exception e5) {
            this.warn("Error: playerAllocate(" + playerNr + "), no sources: " + e5);
            return false;
        }
        return true;
    }

    private synchronized boolean play(int playerNr, int count) {
        if (!this.isSoundOn) {
            return true;
        }
        this.stop();
        this.warn("sound player: play");
        try {
            if (this.getState() == 400) {
                return false;
            }
            if (this.lastPlayingSound != playerNr) {
                this.close();
            }
            if ((null == this.player || 400 != this.getState() && 300 != this.getState()) && !this.createPlayer(playerNr)) {
                return false;
            }
            this.player.setLoopCount(count);
            this.player.start();
            this.playerState[SoundPlayer.PLAYERSTATE] = 400;
            this.lastPlayingSound = playerNr;
            this.warn("sound player: played");
        }
        catch (Exception e2) {
            this.close();
            this.warn("Error: play(): " + e2);
            return false;
        }
        return true;
    }

    public synchronized void stop() {
        this.close();
    }

    public synchronized void close() {
        this.warn("sound player: close");
        try {
            if (null == this.player || 400 != this.getState() && 300 != this.getState()) {
                return;
            }
            if (400 == this.getState()) {
                try {
                    this.player.stop();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            try {
                this.player.removePlayerListener((PlayerListener)this);
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                this.player.deallocate();
            }
            catch (Exception e4) {
                // empty catch block
            }
            try {
                this.player.close();
            }
            catch (Exception e5) {
                // empty catch block
            }
            this.player = null;
            this.playerState[SoundPlayer.PLAYERSTATE] = 0;
            try {
                Thread.sleep(200L);
            }
            catch (Exception e6) {
                // empty catch block
            }
            this.warn("sound player: closed");
        }
        catch (Exception e7) {
            this.warn("Error: close(int playerNr): " + e7);
        }
    }

    public boolean playLast(int count) {
        return this.play(this.lastPlayingSound, count);
    }

    public int getState() {
        if (null == this.player) {
            return 0;
        }
        return this.playerState[PLAYERSTATE];
    }

    public int getRealState() {
        if (null == this.player) {
            return 0;
        }
        return this.player.getState();
    }

    public void setVolume(int trackNr, int level) {
        this.setVolume(level);
    }

    public synchronized void setVolume(int level) {
        try {
            this.volume = level;
            VolumeControl volumecontrol = (VolumeControl)this.player.getControl("VolumeControl");
            volumecontrol.setLevel(this.volume);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setMute(int trackNr, boolean mute) {
        this.setMute(mute);
    }

    public synchronized void setMute(boolean mute) {
        VolumeControl volumecontrol = (VolumeControl)this.player.getControl("VolumeControl");
        volumecontrol.setMute(mute);
    }

    public boolean playSE(int playerNr) {
        if (playerNr < 0) {
            return false;
        }
        this.playedSE = true;
        return this.play(playerNr, 1);
    }

    public void stopSE() {
        this.close();
    }

    public void closeSE() {
        this.close();
    }

    public int getStateSE() {
        return this.getState();
    }

    public boolean playBGM(int playerNr) {
        if (playerNr < 0) {
            return false;
        }
        this.bgmNr = playerNr;
        this.playedSE = false;
        return this.play(this.bgmNr, -1);
    }

    public boolean playBGM() {
        return this.play(this.bgmNr, -1);
    }

    public void stopBGM() {
        this.close();
    }

    public void closeBGM() {
        this.close();
    }

    public int getStateBGM() {
        return this.getState();
    }

    public void playerUpdate(Player pl, String event, Object eventData) {
        this.warn("event: " + event);
        try {
            if (event == "endOfMedia") {
                if (this.playedSE) {
                    this.playerState[SoundPlayer.PLAYERSTATE] = 300;
                }
                this.warn("sound player: ISSTOPPED");
            }
            if (event == "deviceUnavailable") {
                try {
                    this.close();
                    Thread.sleep(1000L);
                    Thread.yield();
                }
                catch (Exception e2) {}
            }
        }
        catch (Exception e3) {
            this.warn("Error: playerUpdate()");
        }
    }

    private byte[] readDataFromJar(String name) {
        byte[] res = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(name);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int ret = in.read();
            while (ret >= 0) {
                bout.write(ret);
                ret = in.read();
            }
            res = bout.toByteArray();
            in.close();
            in = null;
            System.gc();
        }
        catch (Exception e2) {
            this.warn("Error: readDataFromJar(" + name + "): " + e2);
        }
        return res;
    }

    private void warn(Object obj) {
        debugString = (String)obj;
        System.out.println(obj);
    }

    private InputStream getInputStream(int playerNr) {
        return new ByteArrayInputStream(this.sourceBuff[playerNr]);
    }

    public void turn(boolean on) {
        this.isSoundOn = on;
        if (!on) {
            this.stopBGM();
            this.stopSE();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

