/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    public int x;
    public int y;
    public int anime;
    public int frame;
    public int stepFrame = 0;
    public int nextAnime = 0;
    private boolean stop = true;
    private boolean loop = false;
    private boolean nextLoop = false;
    private boolean next = false;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private int[][] animations;
    private int[][] frames;
    private int[][] fragments;
    private Image[] images;

    private int valueOfInt(int a2, int b2, int c2, int d2) {
        return a2 << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | c2 << 8 & 0xFF00 | d2 & 0xFF;
    }

    private byte valueOfByte(int src, int index) {
        return (byte)(src >> 8 * index & 0xFF);
    }

    private int valueOf(int src, int index) {
        return src >> 8 * index & 0xFF;
    }

    public Sprite(DataInputStream in) {
        try {
            int d2;
            int c2;
            int b2;
            int a2;
            int j;
            int i;
            this.animations = new int[in.readShort()][];
            for (i = 0; i < this.animations.length; ++i) {
                this.animations[i] = new int[in.read()];
                for (j = 0; j < this.animations[i].length; ++j) {
                    a2 = 0;
                    b2 = in.read();
                    c2 = in.read();
                    d2 = in.read();
                    this.animations[i][j] = this.valueOfInt(a2, b2, c2, d2);
                }
            }
            this.frames = new int[in.readShort()][];
            for (i = 0; i < this.frames.length; ++i) {
                this.frames[i] = new int[in.read()];
                for (j = 0; j < this.frames[i].length; ++j) {
                    a2 = in.read();
                    b2 = in.read();
                    c2 = in.readByte();
                    d2 = in.readByte();
                    this.frames[i][j] = this.valueOfInt(a2, b2, c2, d2);
                }
            }
            this.fragments = new int[in.readShort()][];
            for (i = 0; i < this.fragments.length; ++i) {
                this.fragments[i] = new int[in.readShort()];
                for (j = 0; j < this.fragments[i].length; ++j) {
                    a2 = in.readByte();
                    b2 = in.readByte();
                    c2 = in.read();
                    d2 = in.read();
                    this.fragments[i][j] = this.valueOfInt(a2, b2, c2, d2);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setImages(Image[] images) {
        this.images = images;
    }

    public void setImage(int index, Image image) {
        this.images[index] = null;
        this.images[index] = image;
    }

    public Sprite(int[][] animations, int[][] frames, int[][] fragments, Image[] images) {
        this.animations = animations;
        this.frames = frames;
        this.fragments = fragments;
        this.images = images;
    }

    public Sprite copy() {
        return new Sprite(this.animations, this.frames, this.fragments, this.images);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void draw(Graphics g2) {
        this.draw(g2, this.x, this.y);
    }

    public void draw(Graphics g2, int x, int y) {
        this.drawAnime(g2, this.anime, this.frame, x, y);
    }

    public void draw(Graphics g2, int anime, int x, int y) {
        this.drawAnime(g2, anime, this.frame % this.getFrameSize(anime), x, y);
        this.anime = anime;
        this.stop = false;
        this.loop = true;
        this.stepFrame = 0;
        this.next = false;
    }

    public int getAnimeSize() {
        return this.animations.length;
    }

    public int getFrameSize(int anime) {
        return this.animations[anime %= this.animations.length].length;
    }

    public int getFragmentSize() {
        return this.fragments.length;
    }

    public int getAnimeFrame(int anime, int frame) {
        return this.valueOf(this.animations[anime][frame %= this.animations[anime %= this.animations.length].length], 1) << 8 & 0xFF00 | this.valueOf(this.animations[anime][frame], 0) & 0xFF;
    }

    public int getAnimeDuration(int anime, int frame) {
        return this.valueOf(this.animations[anime][frame %= this.animations[anime %= this.animations.length].length], 2);
    }

    public void drawAnime(Graphics g2, int anime, int frame, int x, int y) {
        this.drawFrame(g2, this.getAnimeFrame(anime % this.getAnimeSize(), frame % this.getFrameSize(anime)), x, y);
    }

    public int getConvertFrameID(int anime, int frame) {
        int frameSize = this.getFrameSize(anime);
        int total = 0;
        for (int i = 0; i < frameSize; ++i) {
            total += this.getAnimeDuration(anime, i);
        }
        int r = frame % total;
        int f2 = 0;
        for (int i = 0; i < frameSize; ++i) {
            if ((r -= this.getAnimeDuration(anime, i)) > 0) continue;
            f2 = i;
            break;
        }
        return f2;
    }

    private int getFileID(int frame, int id) {
        int result = this.valueOf(this.frames[frame][id %= this.frames[frame %= this.frames.length].length], 3);
        return result >> 4 & 0xF;
    }

    private int getFrameID(int frame, int id) {
        int result = this.valueOf(this.frames[frame][id %= this.frames[frame %= this.frames.length].length], 3) << 8 & 0xF00 | this.valueOf(this.frames[frame][id], 2) & 0xFF;
        return result & 0xFFF;
    }

    public void drawFrame(Graphics g2, int frame, int x, int y) {
        int size = this.frames[frame %= this.frames.length].length;
        for (int i = 0; i < size; ++i) {
            int file_id = this.getFileID(frame, i);
            int id = this.getFrameID(frame, i);
            int sprx = x + this.valueOfByte(this.frames[frame][i], 1);
            int spry = y + this.valueOfByte(this.frames[frame][i], 0);
            this.drawFragment(g2, file_id, id, sprx, spry);
        }
    }

    public void start(int anime, boolean loop) {
        this.frame = 0;
        this.anime = anime;
        this.stop = false;
        this.loop = loop;
        this.stepFrame = 0;
        this.next = false;
    }

    public void stop() {
        this.stop = true;
    }

    public void stopStart() {
        this.stop = true;
        this.frame = 0;
    }

    public void stopEnd() {
        this.stop = true;
        this.frame = this.getAnimeFrame(this.anime, this.getFrameSize(this.anime));
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setNextAnime(int anime, boolean loop) {
        this.nextAnime = anime;
        this.nextLoop = loop;
        this.stepFrame = 0;
        this.next = true;
    }

    public void next() {
        if (!this.stop) {
            ++this.stepFrame;
            if (this.stepFrame < this.getAnimeDuration(this.anime, this.frame)) {
                return;
            }
            this.stepFrame = 0;
            if (!this.loop && this.getFrameSize(this.anime) <= this.frame + 1) {
                this.stop = true;
                if (this.next) {
                    this.start(this.nextAnime, this.nextLoop);
                }
            } else {
                this.setFrame(this.frame + 1);
            }
        }
    }

    public void setFrame(int index) {
        this.frame = index % this.getFrameSize(this.anime);
    }

    private void saveClip(Graphics g2) {
        this.clipX = g2.getClipX();
        this.clipY = g2.getClipY();
        this.clipW = g2.getClipWidth();
        this.clipH = g2.getClipHeight();
    }

    private void restoreClip(Graphics g2) {
        g2.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    private boolean setClip(Graphics g2, int x, int y, int width, int height) {
        int x1 = Math.max(x, this.clipX);
        int y1 = Math.max(y, this.clipY);
        int x2 = Math.min(x + width, this.clipX + this.clipW);
        int y2 = Math.min(y + height, this.clipY + this.clipH);
        int w = x2 - x1;
        int h2 = y2 - y1;
        if (w < 0 || h2 < 0) {
            return false;
        }
        g2.setClip(x1, y1, w, h2);
        return true;
    }

    private void drawImage(Graphics g2, Image img, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        this.saveClip(g2);
        if (this.setClip(g2, x, y, clipWidth, clipHeight)) {
            g2.drawImage(img, x - clipX, y - clipY, 20);
        }
        this.restoreClip(g2);
    }

    private void drawFragment(Graphics g2, int fileID, int fragmentID, int x, int y) {
        this.drawImage(g2, this.images[fileID], x, y, this.valueOf(this.fragments[fileID][fragmentID %= this.fragments[fileID %= this.fragments.length].length], 3), this.valueOf(this.fragments[fileID][fragmentID], 2), this.valueOf(this.fragments[fileID][fragmentID], 1), this.valueOf(this.fragments[fileID][fragmentID], 0));
    }
}

