/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.controller.state.AbstractAppState;
import com.foxmobile.ghostcamera.framework.Strings;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public final class HelpState
extends AbstractAppState
implements CommandListener {
    private Displayable previousDisplayable = null;
    private Form form = null;
    private Display display = null;
    private Command okCommand = new Command(AppController.getInstance().getString("OK"), 4, 0);

    public HelpState(Display display) {
        this.display = display;
    }

    public void doAfterEntering() {
        super.doAfterEntering();
        this.previousDisplayable = this.display.getCurrent();
        this.form = new Form(AppController.getInstance().getString("HELPTITLE"));
        String text = AppController.getInstance().getString("HELPTEXT");
        Vector pieces = Strings.split(text, '|');
        Font font = Font.getFont((int)0, (int)0, (int)0);
        int i = 0;
        while (i < pieces.size()) {
            String piece = (String)pieces.elementAt(i);
            StringItem item = new StringItem("", piece);
            item.setFont(font);
            this.form.append((Item)item);
            ++i;
        }
        this.form.addCommand(this.okCommand);
        this.form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.form);
    }

    public void doBeforeLeaving() {
        this.display.setCurrent(this.previousDisplayable);
        super.doBeforeLeaving();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.okCommand) {
            AppController.getInstance().handleGoToMenu();
        }
    }
}

