/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework.graphics;

import com.foxmobile.ghostcamera.framework.Size;
import com.foxmobile.ghostcamera.framework.graphics.AppFont;
import javax.microedition.lcdui.Graphics;

public final class Label {
    private String text;
    private AppFont font;
    private float x;
    private float y;
    private int width;
    private int height;

    public Label(String text, AppFont font, Graphics graphics) {
        this.text = text;
        this.font = font;
        this.x = 0.0f;
        this.y = 0.0f;
        this.updateMeasurements(graphics);
    }

    private void updateMeasurements(Graphics graphics) {
        Size size = this.font.measureString(this.text, graphics);
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public final void updateText(String newText, Graphics graphics) {
        this.text = newText;
        this.updateMeasurements(graphics);
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float x) {
        this.x = x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float y) {
        this.y = y;
    }

    public final void moveX(float dx) {
        this.x += dx;
    }

    public final void moveY(float dy) {
        this.y += dy;
    }

    public final String getText() {
        return this.text;
    }

    public final AppFont getFont() {
        return this.font;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void blit(Graphics graphics) {
        int intX = (int)this.x;
        int intY = (int)this.y;
        this.font.blitString(graphics, this.text, intX, intY);
    }
}

