/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework.graphics;

import com.foxmobile.ghostcamera.framework.resources.ResourceProvider;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Sprite {
    private boolean alpha = true;
    private float x = 0.0f;
    private float y = 0.0f;
    private int width;
    private int height;
    private int[] rgb;

    public Sprite(String name, boolean alpha) {
        this(ResourceProvider.getInstance().loadBitmap(name), alpha);
    }

    public Sprite(Image image, boolean alpha) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.alpha = alpha;
        this.rgb = new int[this.width * this.height];
        image.getRGB(this.rgb, 0, this.width, 0, 0, this.width, this.height);
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float x) {
        this.x = x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float y) {
        this.y = y;
    }

    public final void moveX(float dx) {
        this.x += dx;
    }

    public final void moveY(float dy) {
        this.y += dy;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void blit(Graphics graphics) {
        int intX = (int)this.x;
        int intY = (int)this.y;
        graphics.drawRGB(this.rgb, 0, this.width, intX, intY, this.width, this.height, this.alpha);
    }
}

