/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.state.AbstractAppState;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.graphics.Canvas;
import com.foxmobile.ghostcamera.graphics.LoopProcedure;
import javax.microedition.lcdui.Graphics;

public abstract class AbstractCanvasState
extends AbstractAppState
implements LoopProcedure {
    protected Canvas canvas;

    public AbstractCanvasState(Canvas canvas) {
        this.canvas = canvas;
    }

    public void doAfterEntering() {
        super.doAfterEntering();
        this.doBeforeLoop();
        this.canvas.setLoopProcedure(this);
    }

    protected abstract void doBeforeLoop();

    public void doBeforeLeaving() {
        this.canvas.setLoopProcedure(null);
        super.doBeforeLeaving();
    }

    protected final void clearScreen(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
    }

    public final void executeLoop(Graphics graphics, Timing timing) {
        this.executeRedraw(graphics, timing);
        if (this.autoFlushGraphics()) {
            this.canvas.flushGraphics();
        }
        this.afterFlush(timing);
    }

    protected boolean autoFlushGraphics() {
        return true;
    }

    protected void afterFlush(Timing timing) {
    }

    protected abstract void executeRedraw(Graphics var1, Timing var2);

    public void handleSizeChanged(int w, int h) {
    }
}

