/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import com.foxmobile.ghostcamera.framework.graphics.AppFont;
import com.foxmobile.ghostcamera.framework.graphics.BitmapFont;
import com.foxmobile.ghostcamera.framework.graphics.Bitmaps;
import com.foxmobile.ghostcamera.framework.graphics.NativeFont;
import com.foxmobile.ghostcamera.framework.resources.PreparedResources;
import com.foxmobile.ghostcamera.framework.resources.ResourceProvider;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ResourcePreparer
implements Runnable {
    private static final String TAG;
    private MIDlet midlet;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.controller.ResourcePreparer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public ResourcePreparer(MIDlet midlet) {
        this.midlet = midlet;
    }

    public void run() {
        try {
            PreparedResources resources = AppController.getInstance().getPreparedResources();
            DeviceTraits deviceTraits = AppController.getInstance().getDeviceTraits();
            Image titleBackground = ResourceProvider.getInstance().loadBitmap("title_bg");
            boolean willScale = !deviceTraits.isSmallHeap() || deviceTraits.getCanvasWidth() > titleBackground.getWidth();
            Image scaledTitleBackground = willScale ? Bitmaps.scaleImageForBackground(titleBackground) : titleBackground;
            resources.putResource("titleBackground", scaledTitleBackground);
            AppFont defaultFont = null;
            AppFont headerFont = null;
            if (deviceTraits.isSmallHeap()) {
                defaultFont = new NativeFont(0, 1, 0);
                headerFont = new NativeFont(0, 1, 16);
            } else {
                defaultFont = BitmapFont.fromBinaryFontFile("default_font");
                headerFont = BitmapFont.fromBinaryFontFile("header_font");
            }
            resources.putResource("defaultFont", defaultFont);
            resources.putResource("headerFont", headerFont);
            Image titleHeaderBitmap = ResourceProvider.getInstance().loadBitmap("title_header");
            titleHeaderBitmap = Bitmaps.scaleImageWidth(titleHeaderBitmap, deviceTraits.getCanvasWidth());
            resources.putResource("titleHeader", titleHeaderBitmap);
            if (!deviceTraits.isSmallHeap()) {
                Image scaledMenuBackground = Bitmaps.scaleImageForBackground(ResourceProvider.getInstance().loadBitmap("menu_bg-"));
                resources.putResource("menuBackground", scaledMenuBackground);
            }
            AppController.getInstance().handleResourcePreparingDone();
        }
        catch (Throwable t) {
            Log.log(TAG, "Error in resource preparer: {0}", t);
            Alert alert = new Alert("Error", t.toString(), null, AlertType.ERROR);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)alert);
        }
    }
}

