/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework;

public final class Timing {
    private long frameStartInstance;
    private int[] runningMsPerFrame = new int[50];
    private int index = 0;
    private int msPerFrame = -1;

    public void updateBeforeFrame() {
        this.frameStartInstance = System.currentTimeMillis();
        if (this.msPerFrame == -1) {
            this.msPerFrame = 1;
        }
    }

    public void updateAfterFrame() {
        long currentInstance = System.currentTimeMillis();
        long delta = currentInstance - this.frameStartInstance;
        this.msPerFrame = (int)delta;
        if (this.msPerFrame <= 1) {
            this.msPerFrame = 1;
        }
        this.runningMsPerFrame[this.index % this.runningMsPerFrame.length] = this.msPerFrame;
        ++this.index;
    }

    public int getMsPerFrame() {
        return this.msPerFrame;
    }

    public float calculateDelta(float targetDeltaPerSecond) {
        return targetDeltaPerSecond * ((float)this.msPerFrame / 1000.0f);
    }

    public float calculateFps() {
        float ms = 0.0f;
        int i = 0;
        while (i < this.runningMsPerFrame.length) {
            ms += (float)this.runningMsPerFrame[i];
            ++i;
        }
        float fps = 1.0f / (ms / (float)this.runningMsPerFrame.length / 1000.0f);
        return fps;
    }

    public long getFrameStartInstance() {
        return this.frameStartInstance;
    }
}

