/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CutScene {
    private int[][] mResourceIDs;
    private int mSceneIndex;
    private final int STATE_START;
    private final int STATE_TEXTBOX;
    private final int STATE_ANIMATION;
    private final int STATE_PAUSE;
    private final int STATE_FINISH;
    private int mState;
    SpriteObject[][] mAnimations;
    MenuObject[] mTextBoxes;
    boolean mActionRequested = false;
    boolean mSkipRequested = false;
    int mCutSceneTime;

    public void freeResources() {
        if (this.mAnimations != null) {
            for (int i = 0; i < this.mAnimations.length; ++i) {
                for (int j = 0; j < this.mAnimations[i].length; ++j) {
                    this.mAnimations[i][j].freeResources();
                }
            }
        }
    }

    public CutScene(int[][] nArray) {
        this.STATE_START = 0;
        this.STATE_TEXTBOX = 1;
        this.STATE_ANIMATION = 2;
        this.STATE_PAUSE = 3;
        this.STATE_FINISH = 4;
        this.mResourceIDs = nArray;
    }

    public static int getAnimationAlignment(int n) {
        int n2 = n == 196796 || n == 196779 || n == 196792 ? 36 : (n == 196783 || n == 196786 || n == 196782 || n == 196791 || n == 196780 || n == 196785 || n == 196781 || n == 196794 || n == 196787 || n == 196777 || n == 196778 || n == 196784 || n == 196789 || n == 196790 || n == 196793 ? 40 : 3);
        return n2;
    }

    public void keyEventOccurred(int n, int n2) {
        boolean bl = false;
        if (n2 == 0 && Toolkit.getToolkitGameAction(n) == 53 || n2 == 3 && n == 1) {
            bl = true;
        }
        if (n2 == 3 && n == 14) {
            this.mSkipRequested = true;
        }
        switch (this.mState) {
            case 3: {
                if (!bl) break;
                this.mActionRequested = bl;
                break;
            }
            case 1: {
                if (bl) {
                    this.mActionRequested = bl;
                }
                this.mTextBoxes[this.mSceneIndex].keyEventOccurred(n, n2);
                break;
            }
        }
    }

    private int getAnimationsCount(int n) {
        return this.mResourceIDs[n].length - 1;
    }

    private int getAnimationAlignment(int n, int n2) {
        return CutScene.getAnimationAlignment(this.getAnimationRID(n, n2));
    }

    private int getAnimationRID(int n, int n2) {
        if (n2 == 0) {
            return this.mResourceIDs[n][0];
        }
        return this.mResourceIDs[n][1 + n2];
    }

    private int getAlignmentX(int n, int n2) {
        int n3 = Toolkit.getScreenWidth();
        int n4 = Toolkit.getScreenHeight();
        int n5 = this.getAnimationAlignment(n, n2);
        int n6 = 0;
        boolean bl = false;
        if ((n5 & 1) != 0) {
            n6 = n3 / 2;
        }
        if ((n5 & 8) != 0) {
            n6 = n3 - 1;
        }
        return n6;
    }

    private int getAlignmentY(int n, int n2) {
        int n3 = Toolkit.getScreenWidth();
        int n4 = Toolkit.getScreenHeight();
        int n5 = this.getAnimationAlignment(n, n2);
        int n6 = 0;
        if ((n5 & 2) != 0) {
            n6 = n4 / 2;
        }
        if ((n5 & 0x20) != 0) {
            n6 = n4 - 1;
        }
        return n6;
    }

    private void drawScene(Graphics graphics, int n) {
        int n2 = Toolkit.getScreenWidth();
        int n3 = Toolkit.getScreenHeight();
        int n4 = this.getAnimationsCount(n);
        for (int i = 0; i < n4; ++i) {
            this.mAnimations[n][i].draw(graphics, this.getAlignmentX(n, i), this.getAlignmentY(n, i));
        }
    }

    private void updateScene(int n, int n2) {
        int n3 = this.getAnimationsCount(n2);
        for (int i = 0; i < n3; ++i) {
            this.mAnimations[n2][i].logicUpdate(n);
        }
    }

    private void startScene(int n) {
    }

    private boolean isSceneAnimationsFinished() {
        if (this.mResourceIDs[this.mSceneIndex][0] != -1) {
            if (this.mAnimations[this.mSceneIndex].length == 1 && this.mAnimations[this.mSceneIndex][0].getFrameCount() == this.mAnimations[this.mSceneIndex][0].getCurrentFrameIndex()) {
                return true;
            }
            int n = this.getAnimationsCount(this.mSceneIndex);
            for (int i = 0; i < n; ++i) {
                if (!this.mAnimations[this.mSceneIndex][i].isFinishedAnimation()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void load(int n) {
        if (this.mResourceIDs != null) {
            switch (n) {
                case 0: {
                    this.mAnimations = new SpriteObject[this.mResourceIDs.length][];
                    this.mTextBoxes = new MenuObject[this.mResourceIDs.length];
                    this.mCutSceneTime = 0;
                    block3: for (int i = 0; i < this.mResourceIDs.length; ++i) {
                        int n2;
                        int n3 = this.getAnimationsCount(i);
                        this.mAnimations[i] = new SpriteObject[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            if (n2 == 0 && i > 0 && this.getAnimationRID(i, n2) == this.getAnimationRID(i - 1, n2)) {
                                System.out.println("\t\t\tLooping animation detected - " + this.getAnimationRID(i, n2) + " vs " + this.getAnimationRID(i - 1, n2));
                                this.mAnimations[i][n2] = this.mAnimations[i - 1][n2];
                                continue;
                            }
                            System.out.println("\t\tnon-looping animation detected - " + this.getAnimationRID(i, n2) + " in scene " + i);
                            this.mAnimations[i][n2] = new SpriteObject(DavinciUtilities.loadAnimation(this.getAnimationRID(i, n2)), false);
                        }
                        this.mCutSceneTime += this.mAnimations[i][0].getAnimationLength();
                        n2 = this.mResourceIDs[i][1];
                        if (n2 == -1) continue;
                        for (int j = 0; j < n3; ++j) {
                            SpriteObject spriteObject = this.mAnimations[i][j];
                            int n4 = spriteObject.getFrameCount();
                            CollisionBox[] collisionBoxArray = null;
                            spriteObject.setAnimationFrame(--n4);
                            collisionBoxArray = spriteObject.getCollisionBoxes();
                            spriteObject.setAnimationFrame(0);
                            if (collisionBoxArray == null || collisionBoxArray.length <= 0) continue;
                            this.mTextBoxes[i] = this.createTextbox(collisionBoxArray[0], n2, this.getAlignmentX(i, j), this.getAlignmentY(i, j));
                            continue block3;
                        }
                    }
                    break;
                }
            }
        } else {
            this.mState = 4;
        }
    }

    private MenuObject createTextbox(CollisionBox collisionBox, int n, int n2, int n3) {
        int n4 = n2 + collisionBox.getX();
        int n5 = n3 + collisionBox.getY();
        int n6 = collisionBox.getWidth();
        int n7 = collisionBox.getHeight();
        MenuObject menuObject = new MenuObject();
        menuObject.setScreen(1, 1, 3);
        menuObject.setItem(0, 1, Toolkit.getText(n), null, -1);
        menuObject.setStyle(2);
        menuObject.setBounds(n4, n5, n6, n7);
        System.out.println("\t\tCutScene:: textbox created: " + Toolkit.getText(n));
        return menuObject;
    }

    public void draw(Graphics graphics, int n, int n2) {
        switch (this.mState) {
            case 0: {
                break;
            }
            case 2: {
                this.drawScene(graphics, this.mSceneIndex);
                break;
            }
            case 1: {
                this.drawScene(graphics, this.mSceneIndex);
                this.mTextBoxes[this.mSceneIndex].doDraw(graphics);
                break;
            }
            case 3: {
                this.drawScene(graphics, this.mSceneIndex);
            }
        }
    }

    void logicUpdate(int n) {
        if (this.mSkipRequested) {
            this.changeState(4);
        }
        switch (this.mState) {
            case 0: {
                this.mSceneIndex = 0;
                this.startScene(this.mSceneIndex);
                this.changeState(2);
                break;
            }
            case 2: {
                if (this.isSceneAnimationsFinished()) {
                    if (this.mTextBoxes[this.mSceneIndex] != null) {
                        this.changeState(1);
                        break;
                    }
                    this.changeState(3);
                    break;
                }
                this.updateScene(n, this.mSceneIndex);
                break;
            }
            case 1: {
                this.mTextBoxes[this.mSceneIndex].logicUpdate(n);
            }
            case 3: {
                if (!this.mActionRequested && this.mState != 3) break;
                if (this.mSceneIndex < this.mAnimations.length - 1) {
                    ++this.mSceneIndex;
                    this.changeState(2);
                    break;
                }
                this.changeState(4);
            }
        }
    }

    void changeState(int n) {
        switch (n) {
            case 1: {
                Toolkit.removeAllSoftKeys();
                Toolkit.setSoftKey(1, 1);
                if (this.mSceneIndex >= this.mAnimations.length - 1) break;
                Toolkit.setSoftKey(14, 3);
                break;
            }
            default: {
                Toolkit.removeAllSoftKeys();
                Toolkit.setSoftKey(14, 3);
            }
            case 3: 
        }
        this.mActionRequested = false;
        this.mSkipRequested = false;
        this.mState = n;
        System.out.println("CutScene::changeState: New state: " + n + "current RID  " + this.getAnimationRID(this.mSceneIndex, 0));
    }

    public boolean isCutSceneFinished() {
        return this.mState == 4;
    }
}

