/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;

public final class Toolkit
extends FullCanvas
implements PlayerListener {
    private static DChocMIDlet sm_listener;
    private static boolean sm_settingAnotherDisplayable;
    private static boolean sm_settingAsCurrent;
    private static int sm_leftSoftKey;
    private static String sm_leftSoftKeyLabel;
    private static Image sm_leftSoftKeyIcon;
    private static int sm_leftSoftKeyType;
    private static int sm_rightSoftKey;
    private static String sm_rightSoftKeyLabel;
    private static Image sm_rightSoftKeyIcon;
    private static int sm_rightSoftKeyType;
    private static Hashtable sm_softKeyPool;
    private static Font sm_softKeyFont;
    private static boolean sm_okToPaint;
    private static Toolkit sm_instance;
    private static int[] sm_lastPressedKeys;
    private static int sm_lastPressedKeyIndex;
    private static int[] sm_bufferedPressedKeys;
    private static int sm_bufferedPressedKeyIndex;
    private static int[] sm_bufferedReleasedKeys;
    private static int sm_bufferedReleasedKeyIndex;
    private static int[] sm_bufferedRepeatedKeys;
    private static int sm_bufferedRepeatedKeyIndex;
    public static boolean isKeyPressed;
    public static boolean isKeyReleased;
    public static boolean isKeyRepeated;
    private static ImageFont sm_softkeyImageFont;
    private static int sm_softkeyAreaHeight;
    private static final String[] SOUND_FORMATS;
    private static final String[] SOUND_FILE_EXTENSIONS;
    private static Player sm_currentSoundEffect;
    private static Player sm_currentMusic;
    private static int sm_currentMusicRID;
    private static int sm_musicVolume;
    private static int sm_musicLoopsLeft;
    private static boolean sm_skipSounds;
    private static RateControl smRateController;
    private static MIDIControl smMIDIController;
    private static int[] sm_current_midi_channels_volume;
    private static int sm_current_rate;
    private static int sm_current_master_volume;
    private static boolean USE_INGAME_RATE_CONTROL;
    private static boolean USE_INGAME_MASTER_VOLUME_CONTROL;
    private static boolean USE_INGAME_CHANNEL_VOLUME_CONTROL;
    private static int sm_dataSource;
    private static String sm_loadedFileName;
    private static byte[] sm_loadedFileData;
    private static int sm_selectedLanguage;
    private static String[] sm_languageCode;
    private static String[][] sm_languageName;
    private static String[] sm_properties;
    private static final char[] NUMBERLIKE_SYMBOLS;
    private static boolean sm_readOnly;
    private static ILicenseManager sm_licenseManager;
    private static int FIXED_INDEX;

    public Toolkit() {
        sm_lastPressedKeys = new int[5];
        sm_bufferedPressedKeys = new int[5];
        sm_bufferedReleasedKeys = new int[5];
        sm_bufferedRepeatedKeys = new int[5];
        sm_lastPressedKeyIndex = -1;
        sm_bufferedPressedKeyIndex = -1;
        sm_bufferedReleasedKeyIndex = -1;
        sm_bufferedRepeatedKeyIndex = -1;
    }

    protected void keyPressed(int n) {
        if (++sm_lastPressedKeyIndex >= sm_lastPressedKeys.length) {
            int[] nArray = sm_lastPressedKeys;
            sm_lastPressedKeys = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, sm_lastPressedKeys, 0, nArray.length);
        }
        Toolkit.sm_lastPressedKeys[Toolkit.sm_lastPressedKeyIndex] = n;
        if (sm_bufferedPressedKeyIndex < 4) {
            Toolkit.sm_bufferedPressedKeys[++Toolkit.sm_bufferedPressedKeyIndex] = n;
        }
        isKeyPressed = true;
    }

    private static void resetDynamicSoundSettings() {
        if (USE_INGAME_CHANNEL_VOLUME_CONTROL) {
            sm_current_midi_channels_volume = new int[16];
            for (int i = 0; i < 16; ++i) {
                Toolkit.sm_current_midi_channels_volume[i] = -1;
            }
        }
        if (USE_INGAME_MASTER_VOLUME_CONTROL) {
            sm_current_master_volume = 127;
        }
        if (USE_INGAME_RATE_CONTROL) {
            sm_current_rate = 10;
        }
    }

    private static void stopMidi(Player player) {
        if (player != null) {
            try {
                player.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getScreenHeight() {
        return sm_instance.getHeight();
    }

    public static DataInputStream getResourceStream(int n) {
        if (n != -1) {
            return new DataInputStream(new ByteArrayInputStream(Toolkit.getResourceBytes(n)));
        }
        return null;
    }

    public static byte[] readRecord(String string) {
        DChocMIDlet.skipTimer();
        byte[] byArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            byArray = recordStore.getRecord(1);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static int getMinSupportedRate() {
        if (sm_currentMusic != null) {
            Toolkit.fetchRateController();
            if (smRateController != null) {
                return smRateController.getMinRate();
            }
        }
        return 100000;
    }

    public static byte[] getResourceBytes(int n) {
        byte[] byArray = null;
        if (n != -1) {
            int n2 = n >>> 16;
            int n3 = n & 0xFFFF;
            String string = "r" + n2;
            Toolkit.loadFile(string);
            byArray = Toolkit.getResourceBytesFromLoadedFile(n3);
        }
        return byArray;
    }

    public static void setRate(int n) {
        if (sm_currentMusic != null) {
            Toolkit.fetchRateController();
            if (smRateController != null) {
                if (n < 10) {
                    int n2 = Math.max(Toolkit.getMinSupportedRate(), 10000);
                    sm_current_rate = (100000 - n2) * (n - 1) / 9 + n2;
                } else if (n > 10) {
                    int n3 = Math.min(Toolkit.getMaxSupportedRate(), 1000000);
                    sm_current_rate = (n3 - 100000) * (n - 10) / 90 + 100000;
                } else {
                    sm_current_rate = 100000;
                }
                smRateController.setRate(sm_current_rate);
            }
        }
    }

    private static Player playMidi(int n, int n2, int n3) {
        Player player = null;
        try {
            player = Toolkit.createPlayer(n);
            if (player.getState() != 300) {
                player.prefetch();
            }
            player.setLoopCount(n2);
            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(n3 * 20);
            }
            if (USE_INGAME_CHANNEL_VOLUME_CONTROL && (smMIDIController = (MIDIControl)player.getControl("MIDIControl")) != null && sm_current_midi_channels_volume == null) {
                sm_current_midi_channels_volume = new int[16];
                for (int i = 0; i < 16; ++i) {
                    Toolkit.sm_current_midi_channels_volume[i] = -1;
                }
            }
            if (USE_INGAME_MASTER_VOLUME_CONTROL && sm_current_master_volume != 100) {
                Toolkit.setMasterVolume(sm_current_master_volume);
            }
            player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player;
    }

    public static int getSelectedLanguageIndex() {
        return sm_selectedLanguage;
    }

    private void drawSoftKeyLabels(Graphics graphics) {
        int n;
        int n2;
        int n3 = Toolkit.getScreenWidth();
        int n4 = Toolkit.getScreenHeight();
        graphics.setClip(0, 0, n3, n4);
        int n5 = n4 - 2;
        graphics.setFont(sm_softKeyFont);
        if (sm_leftSoftKey != -1) {
            if (sm_leftSoftKeyIcon != null) {
                graphics.drawImage(sm_leftSoftKeyIcon, 2, n5 - sm_leftSoftKeyIcon.getHeight(), 20);
            } else if (sm_softkeyImageFont != null) {
                sm_softkeyImageFont.drawString(graphics, sm_leftSoftKeyLabel, 2, n5, 36);
            } else {
                n2 = 3;
                n = n5 - 1;
                graphics.setColor(0);
                graphics.drawString(sm_leftSoftKeyLabel, n2 - 1, n, 36);
                graphics.drawString(sm_leftSoftKeyLabel, n2, n - 1, 36);
                graphics.drawString(sm_leftSoftKeyLabel, n2 + 1, n, 36);
                graphics.drawString(sm_leftSoftKeyLabel, n2, n + 1, 36);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(sm_leftSoftKeyLabel, n2, n, 36);
            }
        }
        if (sm_rightSoftKey != -1) {
            if (sm_rightSoftKeyIcon != null) {
                graphics.drawImage(sm_rightSoftKeyIcon, n3 - 2 - sm_rightSoftKeyIcon.getWidth(), n5 - sm_rightSoftKeyIcon.getHeight(), 20);
            } else if (sm_softkeyImageFont != null) {
                sm_softkeyImageFont.drawString(graphics, sm_rightSoftKeyLabel, Toolkit.getScreenWidth() - 2 - sm_softkeyImageFont.stringWidth(sm_rightSoftKeyLabel), n5, 36);
            } else {
                n2 = n3 - 2;
                n = n5 - 1;
                graphics.setColor(0);
                graphics.drawString(sm_rightSoftKeyLabel, n2 - 1, n, 40);
                graphics.drawString(sm_rightSoftKeyLabel, n2, n - 1, 40);
                graphics.drawString(sm_rightSoftKeyLabel, n2 + 1, n, 40);
                graphics.drawString(sm_rightSoftKeyLabel, n2, n + 1, 40);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(sm_rightSoftKeyLabel, n2, n, 40);
            }
        }
    }

    public static String[][] getLanguageDescriptions() {
        return sm_languageName;
    }

    private static byte[] getResourceBytesFromLoadedFile(int n) {
        int n2 = sm_loadedFileData.length;
        int n3 = Toolkit.getResourceInt(4);
        int n4 = Toolkit.getResourceInt(8 + n * 4);
        int n5 = n == n3 - 1 ? n2 - n4 : Toolkit.getResourceInt(8 + n * 4 + 4) - n4;
        byte[] byArray = new byte[n5];
        System.arraycopy(sm_loadedFileData, n4, byArray, 0, n5);
        return byArray;
    }

    public static String replaceParameters(String string, String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                string = Toolkit.replaceSubstring(string, "%U", stringArray[0]);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = Toolkit.replaceSubstring(string, "%" + i + "U", stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void processBufferedKeyEvent() {
        int n;
        int n2;
        if (isKeyPressed) {
            for (n2 = 0; n2 <= sm_bufferedPressedKeyIndex; ++n2) {
                Toolkit.toolkitEventOccurred(3);
                n = sm_bufferedPressedKeys[n2];
                if (n == -6) {
                    if (sm_leftSoftKey == -1) continue;
                    sm_listener.keyEventOccurred(sm_leftSoftKey, 3);
                    continue;
                }
                if (n == -7) {
                    if (sm_rightSoftKey == -1) continue;
                    sm_listener.keyEventOccurred(sm_rightSoftKey, 3);
                    continue;
                }
                sm_listener.keyEventOccurred(n, 0);
            }
            isKeyPressed = false;
            sm_bufferedPressedKeyIndex = -1;
        }
        if (isKeyReleased) {
            for (n2 = 0; n2 <= sm_bufferedReleasedKeyIndex; ++n2) {
                n = sm_bufferedReleasedKeys[n2];
                int n3 = 0;
                for (int i = 0; i <= sm_lastPressedKeyIndex; ++i) {
                    if (sm_lastPressedKeys[i] == n) {
                        ++n3;
                    }
                    if (i + n3 > sm_lastPressedKeyIndex) continue;
                    Toolkit.sm_lastPressedKeys[i] = sm_lastPressedKeys[i + n3];
                }
                sm_lastPressedKeyIndex -= n3;
                if (n == -6 || n == -7) continue;
                sm_listener.keyEventOccurred(n, 1);
            }
            isKeyReleased = false;
            sm_bufferedReleasedKeyIndex = -1;
        }
        if (isKeyRepeated) {
            for (n2 = 0; n2 <= sm_bufferedRepeatedKeyIndex; ++n2) {
                n = sm_bufferedRepeatedKeys[n2];
                sm_listener.keyEventOccurred(n, 2);
            }
            isKeyRepeated = false;
            sm_bufferedRepeatedKeyIndex = -1;
        }
    }

    public static void doRepaint() {
        sm_okToPaint = true;
        sm_instance.repaint();
        sm_instance.serviceRepaints();
        sm_okToPaint = false;
    }

    public static void enableWritingToRecordStore(boolean bl) {
        sm_readOnly = !bl;
    }

    protected void showNotify() {
        try {
            if (sm_settingAsCurrent) {
                sm_settingAsCurrent = false;
            } else {
                sm_listener.startApp();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Image getImage(int n) {
        Image image = null;
        if (n != -1 && image == null) {
            byte[] byArray = Toolkit.getResourceBytes(n);
            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        return image;
    }

    public static void removeAllSoftKeys() {
        sm_leftSoftKey = -1;
        sm_leftSoftKeyIcon = null;
        sm_leftSoftKeyLabel = null;
        sm_rightSoftKey = -1;
        sm_rightSoftKeyIcon = null;
        sm_rightSoftKeyLabel = null;
    }

    public static int getToolkitGameAction(int n) {
        if (n >= 48 && n <= 57 || n == 42 || n == 35) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = sm_instance.getGameAction(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 != 0) {
            n2 = n2 == 8 ? 53 : (n2 == 1 ? 50 : (n2 == 6 ? 56 : (n2 == 2 ? 52 : (n2 == 5 ? 54 : 0))));
            return n2;
        }
        return 0;
    }

    public static int getSoftKeyAreaHeight() {
        return sm_softkeyAreaHeight;
    }

    public static int getMusicVolume() {
        return sm_musicVolume;
    }

    public static void createSoftKey(int n, int n2, Image image, int n3) {
        sm_softKeyPool.put(new Integer(0 | n), new Integer(n2));
        sm_softKeyPool.put(new Integer(0x1000000 | n), Toolkit.getText(n2));
        if (image != null) {
            sm_softKeyPool.put(new Integer(0x2000000 | n), image);
        }
        sm_softKeyPool.put(new Integer(0x3000000 | n), new Integer(n3));
    }

    public static String getText(int n) {
        String string = null;
        if (n == -1) {
            return null;
        }
        if (n == -2) {
            return "";
        }
        if (string == null) {
            try {
                int n2 = n >>> 16;
                int n3 = n & 0xFFFF;
                String string2 = "l" + sm_selectedLanguage + "_" + n2;
                Toolkit.loadFile(string2);
                byte[] byArray = Toolkit.getResourceBytesFromLoadedFile(n3);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                string = dataInputStream.readUTF();
                dataInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static int getSoftKeyType(int n) {
        return (Integer)sm_softKeyPool.get(new Integer(0x3000000 | n));
    }

    public static void setChannelVolume(int n, int n2) {
        if (sm_currentMusic != null && smMIDIController != null) {
            smMIDIController.setChannelVolume(n, n2);
            Toolkit.sm_current_midi_channels_volume[n] = n2;
        }
    }

    public static void resumeMusic() {
        if (sm_skipSounds) {
            return;
        }
        if (sm_musicVolume != 0 && sm_currentMusic != null) {
            sm_currentMusic = Toolkit.playMidi(sm_currentMusicRID, sm_musicLoopsLeft, sm_musicVolume);
        }
    }

    public static int getScreenWidth() {
        return sm_instance.getWidth();
    }

    public static void playMusic(int n, int n2) {
        if (sm_skipSounds) {
            return;
        }
        if (sm_musicVolume != 0 && n != -1) {
            Toolkit.resetDynamicSoundSettings();
            Toolkit.stopSoundEffect();
            Toolkit.stopMusic();
            sm_musicLoopsLeft = n2;
            sm_currentMusic = Toolkit.playMidi(n, n2, sm_musicVolume);
            Toolkit.setDynamicSoundSettings();
            sm_currentMusicRID = n;
        }
    }

    public static boolean loadFile(String string) {
        boolean bl = false;
        if (string.equals(sm_loadedFileName)) {
            bl = true;
        } else {
            DChocMIDlet.skipTimer();
            sm_loadedFileName = null;
            sm_loadedFileData = null;
            try {
                switch (sm_dataSource) {
                    case 0: {
                        sm_loadedFileData = new byte[4];
                        InputStream inputStream = ((Object)((Object)sm_instance)).getClass().getResourceAsStream(string);
                        if (inputStream == null) break;
                        inputStream.read(sm_loadedFileData, 0, 4);
                        int n = Toolkit.getResourceInt(0);
                        sm_loadedFileData = new byte[n];
                        for (int i = 4; i < n; i += inputStream.read(sm_loadedFileData, i, n - i)) {
                        }
                        inputStream.close();
                        sm_loadedFileName = string;
                        bl = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static String getNetworkUsageTerms(int n) {
        int n2;
        int n3;
        String string = null;
        int[][] nArrayArray = new int[][]{{-1, -2, -2, -2, -2}, {-1, -2, -2, -2, -1}, {-1, 278, -2, 279, 280}};
        String string2 = Toolkit.getToolkitProperty(22);
        if (string2 != null && (string = Toolkit.getText(n3 = nArrayArray[n][n2 = Integer.parseInt(string2)])) != null && string.length() == 1) {
            string = null;
        }
        return string != null ? string : "";
    }

    public static void setSoftkeyImageFont(ImageFont imageFont) {
        int n;
        sm_softkeyImageFont = imageFont;
        if (sm_softkeyImageFont != null && (n = sm_softkeyImageFont.getHeight() + 2 + 2) > sm_softkeyAreaHeight) {
            sm_softkeyAreaHeight = n;
        }
    }

    public static void setSoftKey(int n, int n2) {
        String string = (String)sm_softKeyPool.get(new Integer(0x1000000 | n));
        Image image = (Image)sm_softKeyPool.get(new Integer(0x2000000 | n));
        int n3 = (Integer)sm_softKeyPool.get(new Integer(0x3000000 | n));
        boolean bl = true;
        int n4 = -1;
        if (n2 == 0) {
            if (n3 == 0 || n3 == 1) {
                if (sm_leftSoftKey != -1) {
                    if (n3 < sm_leftSoftKeyType) {
                        n4 = sm_leftSoftKey;
                    } else {
                        bl = false;
                    }
                }
            } else if (sm_rightSoftKey == -1) {
                bl = false;
            } else if (n3 > sm_rightSoftKeyType) {
                n4 = sm_rightSoftKey;
                bl = false;
            }
            if (n4 != -1) {
                Toolkit.removeAllSoftKeys();
                if (bl) {
                    Toolkit.setSoftKey(n4, 3);
                } else {
                    Toolkit.setSoftKey(n4, 1);
                }
            }
        } else if (n2 != 1) {
            bl = false;
        }
        if (bl) {
            sm_leftSoftKey = n;
            sm_leftSoftKeyIcon = image;
            sm_leftSoftKeyLabel = string;
            sm_leftSoftKeyType = n3;
        } else {
            sm_rightSoftKey = n;
            sm_rightSoftKeyIcon = image;
            sm_rightSoftKeyLabel = string;
            sm_rightSoftKeyType = n3;
        }
    }

    public static void pauseMusic() {
        if (sm_currentMusic != null) {
            Toolkit.stopMidi(sm_currentMusic);
        }
    }

    public static void setSelectedLanguage(int n) {
        sm_selectedLanguage = n;
    }

    public static void setVisible(boolean bl) {
        if (bl) {
            sm_settingAnotherDisplayable = false;
            sm_settingAsCurrent = true;
            DChocMIDlet.setCurrent((Displayable)sm_instance);
        } else {
            sm_settingAnotherDisplayable = true;
        }
    }

    public static void stopSoundEffect() {
        Toolkit.stopMidi(sm_currentSoundEffect);
        sm_currentSoundEffect = null;
    }

    protected void keyRepeated(int n) {
        if (n != -6 && n != -7) {
            if (sm_bufferedRepeatedKeyIndex < 4) {
                Toolkit.sm_bufferedRepeatedKeys[++Toolkit.sm_bufferedRepeatedKeyIndex] = n;
            }
            isKeyRepeated = true;
        }
    }

    public void paint(Graphics graphics) {
        if (sm_okToPaint) {
            sm_listener.doDraw(graphics);
            this.drawSoftKeyLabels(graphics);
            sm_listener.doPostDraw(graphics);
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
    }

    protected void keyReleased(int n) {
        int n2 = 0;
        for (int i = 0; i <= sm_lastPressedKeyIndex; ++i) {
            if (sm_lastPressedKeys[i] == n) {
                ++n2;
            }
            if (i + n2 > sm_lastPressedKeyIndex) continue;
            Toolkit.sm_lastPressedKeys[i] = sm_lastPressedKeys[i + n2];
        }
        sm_lastPressedKeyIndex -= n2;
        if (sm_bufferedReleasedKeyIndex < 4) {
            Toolkit.sm_bufferedReleasedKeys[++Toolkit.sm_bufferedReleasedKeyIndex] = n;
        }
        isKeyReleased = true;
    }

    public static void writeRecord(String string, byte[] byArray, int n) {
        DChocMIDlet.skipTimer();
        if (sm_readOnly && n != 1) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray != null) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setMasterVolume(int n) {
        VolumeControl volumeControl;
        if (sm_currentMusic != null && (volumeControl = (VolumeControl)sm_currentMusic.getControl("VolumeControl")) != null) {
            int n2 = sm_musicVolume * 20 * n / 100;
            volumeControl.setLevel(n2);
            sm_current_master_volume = n;
        }
    }

    public static void setMusicVolume(int n) {
        sm_musicVolume = n;
        if (sm_musicVolume == 0) {
            Toolkit.stopMusic();
        } else {
            Toolkit.stopMidi(sm_currentMusic);
            Toolkit.resumeMusic();
        }
    }

    private static String replaceSubstring(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        return n >= 0 ? string.substring(0, n) + string3 + string.substring(n + string2.length()) : string;
    }

    private static int getResourceInt(int n) {
        return (sm_loadedFileData[n] & 0xFF) << 24 | (sm_loadedFileData[n + 1] & 0xFF) << 16 | (sm_loadedFileData[n + 2] & 0xFF) << 8 | sm_loadedFileData[n + 3] & 0xFF;
    }

    public static void create(DChocMIDlet dChocMIDlet) {
        if (sm_instance == null) {
            sm_instance = new Toolkit();
        }
        sm_listener = dChocMIDlet;
    }

    public static void stopMusic() {
        Toolkit.stopMidi(sm_currentMusic);
        sm_currentMusicRID = -1;
        sm_currentMusic = null;
        sm_current_rate = 10;
    }

    private static void setDynamicSoundSettings() {
        if (USE_INGAME_CHANNEL_VOLUME_CONTROL && smMIDIController != null) {
            for (int i = 0; i < sm_current_midi_channels_volume.length; ++i) {
                if (sm_current_midi_channels_volume[i] == -1) continue;
                Toolkit.setChannelVolume(i, sm_current_midi_channels_volume[i]);
            }
        }
        if (USE_INGAME_MASTER_VOLUME_CONTROL && sm_current_master_volume != 100) {
            Toolkit.setMasterVolume(sm_current_master_volume);
        }
        if (USE_INGAME_RATE_CONTROL) {
            Toolkit.setRate(sm_current_rate);
        }
    }

    protected void hideNotify() {
        try {
            if (!sm_settingAnotherDisplayable) {
                sm_listener.pauseApp();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getMaxSupportedRate() {
        if (sm_currentMusic != null) {
            Toolkit.fetchRateController();
            if (smRateController != null) {
                return smRateController.getMaxRate();
            }
        }
        return 100000;
    }

    private static Player createPlayer(int n) {
        try {
            Player player = Manager.createPlayer((InputStream)new ByteArrayInputStream(Toolkit.getResourceBytes(n)), (String)SOUND_FORMATS[Toolkit.getSoundFormat(n)]);
            player.addPlayerListener((PlayerListener)sm_instance);
            return player;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void initialize() {
        int n;
        Object object;
        DChocMIDlet.skipTimer();
        sm_properties = new String[24];
        try {
            InputStream inputStream = ((Object)((Object)sm_instance)).getClass().getResourceAsStream("p");
            if (inputStream != null) {
                object = new DataInputStream(inputStream);
                try {
                    while (true) {
                        byte by = ((DataInputStream)object).readByte();
                        Toolkit.sm_properties[by - 1] = ((DataInputStream)object).readUTF();
                    }
                }
                catch (EOFException eOFException) {
                    ((FilterInputStream)object).close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (n = 1; n <= 24; ++n) {
            object = DChocMIDlet.getInstance().getAppProperty("DCHOC-" + n);
            if (object == null) continue;
            Toolkit.sm_properties[n - 1] = object;
        }
        n = 0;
        object = new Vector();
        Object var2_6 = null;
        do {
            Toolkit.setSelectedLanguage(n);
            ((Vector)object).addElement(Toolkit.getText(0));
            ((Vector)object).addElement(Toolkit.getText(1));
            ((Vector)object).addElement(Toolkit.getText(3));
        } while (Toolkit.loadFile("l" + ++n + "_0"));
        sm_languageName = new String[n][2];
        sm_languageCode = new String[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Toolkit.sm_languageName[i][0] = (String)((Vector)object).elementAt(n2++);
            Toolkit.sm_languageCode[i] = (String)((Vector)object).elementAt(n2++);
            if (sm_languageCode[i].equals(sm_properties[6])) {
                n3 = i;
            }
            Toolkit.sm_languageName[i][1] = (String)((Vector)object).elementAt(n2++);
        }
        Toolkit.setSelectedLanguage(n3);
        sm_softKeyPool = new Hashtable();
        sm_leftSoftKey = -1;
        sm_rightSoftKey = -1;
        sm_softKeyFont = Font.getFont((int)32, (int)1, (int)8);
        sm_softkeyAreaHeight = sm_softKeyFont.getHeight() + 2 + 2 + 2;
    }

    public static void setSoftKeyLabel(int n, String string) {
        sm_softKeyPool.put(new Integer(0x1000000 | n), string);
        if (sm_leftSoftKey == n) {
            sm_leftSoftKeyLabel = string;
        }
        if (sm_rightSoftKey == n) {
            sm_rightSoftKeyLabel = string;
        }
    }

    private static void fetchRateController() {
        smRateController = sm_currentMusic != null ? (RateControl)sm_currentMusic.getControl("RateControl") : null;
    }

    public static String getToolkitProperty(int n) {
        return sm_properties[n - 1];
    }

    public static void toolkitEventOccurred(int n) {
        if (n == 0) {
            for (int i = 0; i <= sm_lastPressedKeyIndex; ++i) {
                sm_listener.keyEventOccurred(sm_lastPressedKeys[i], 1);
            }
            sm_lastPressedKeyIndex = -1;
        }
        if (n == 0) {
            sm_skipSounds = true;
        }
        if (n == 3) {
            sm_skipSounds = false;
        }
    }

    public static ILicenseManager getLicenseManager() {
        if (sm_licenseManager == null) {
            sm_licenseManager = new FreeTrial();
        }
        return sm_licenseManager;
    }

    private static int getSoundFormat(int n) {
        return 0;
    }

    static {
        isKeyPressed = false;
        isKeyReleased = false;
        isKeyRepeated = false;
        SOUND_FORMATS = new String[]{"audio/midi", "audio/wav", "audio/amr", "audio/mpeg"};
        SOUND_FILE_EXTENSIONS = new String[]{".mid", ".wav", ".amr", ".mp3"};
        USE_INGAME_RATE_CONTROL = false;
        USE_INGAME_MASTER_VOLUME_CONTROL = false;
        USE_INGAME_CHANNEL_VOLUME_CONTROL = false;
        NUMBERLIKE_SYMBOLS = new char[]{'#', '\u2212', '-'};
        FIXED_INDEX = 1000;
    }
}

