/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import com.xendex.BEEzzz.BEEzzz2D;
import game.Game;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.ISound;
import tinbrain.RM;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.mmapi.Sound;
import tinbrain.util.GL;

public class Menu {
    private static String forcedLang;
    private static String exitURL;
    private static boolean soundDefault;
    private static boolean vibraDefault;
    private static boolean soundPresent;
    private static String[] midletInfo;
    protected static byte[][] menus;
    protected static byte[][][] menuItems;
    protected static byte[] iconBases;
    protected static byte[][] icons;
    private static boolean pausedOnSplash;
    private static long splashStartTime;
    private static int splashMaxTime;
    private static int currentSplash;
    private static int currentSplashTime;
    private static int currentSplashFrame;
    private static int mode;
    private static int splashMode;
    private static int currentMenu;
    private static int selectedItem;
    private static int menuItemPosition;
    private static int menuItemEase;
    private static byte[] menuCaller;
    private static byte[] menuSelection;
    private static int[] menuItemWidths;
    private static boolean paused;
    private static int menuClipTop;
    private static int menuClipBottom;
    private static int menuClipHeight;
    private static int menuItemPositionMax;
    private static boolean showUpArrow;
    private static boolean showDownArrow;
    private static boolean lskEnabled;
    private static boolean rskEnabled;
    private static byte[][] textScreenItems;
    private static int delayedMenu;
    private static int delayedMenuCountDown;
    private static int localCommunityHighscore;
    private static int[][] localHighscoreScoreTable;
    private static int localHighscoreCandidateTable;
    private static int localHighscoreCandidateScore;
    private static int localHighscoreCandidateSort;
    private static int inputType;
    private static int inputTypeName;
    private static int enterNamePos;
    private static int enterNameMax;
    private static StringBuffer connectedUserName;
    private static StringBuffer connectedPhoneNumber;
    private static String tmpConnectedUserName;
    private static int MENU_ITEM_BOTTOM;
    private static int MENU_SCROLLTEXT_TOP;
    private static int MENU_SCROLLTEXT_BOTTOM;
    public static int MENU_SEPERATOR_TOP;
    public static int MENU_SEPERATOR_BOTTOM;
    private static int MENU_SEPERATOR_HEIGHT;
    private static int MENU_TEXT_WIDTH;
    private static String scrollText;
    private static int menuCaptionImage;
    private static int menuCaptionOffset;
    private static boolean menuCaptionAlignLeft;
    private static int highscoreEntriesMax;
    private static final int[][] scrInfo;
    protected static int[] options;
    private static volatile boolean showLoading;
    private static int loadingFrame;
    private static long soundSplashStart;
    private static int soundSplashTime;
    private static int soundSplashTimeHelper;
    private static boolean resourceLoadingDone;
    private static boolean titleMusicStarted;
    private static ISound sound;
    private static boolean uploadingPrevHighscore;
    private static boolean tryToUploadPrevHighscore;
    public static boolean isGuest;
    private static Font textScreenFont;
    private static int ttapCountdown;
    private static char ttapChar;
    private static int ttapPos;
    private static int ttapKey;
    private static char[][] ttap;
    private static int currentTranslationString;
    private static int progressBarMax;
    private static int progressCurrent;
    public static boolean sUserPaused;
    private static int sOldItemBottom;
    private static int imageSinAngle;
    private static boolean sShowUpDownArrows;

    private Menu() {
    }

    public static void start() {
        Thread thread = new Thread(new GCanvas());
        thread.start();
    }

    public static void stop() {
        if (GCanvas.isRunning) {
            Menu.startLoading(97);
            Menu.flushRMS();
            Menu.stopMusic();
            GCanvas.isRunning = false;
        }
    }

    public static final void flushRMS() {
        RM.flushRMS();
    }

    protected static final void onDraw(Graphics graphics) {
        if (showLoading) {
            Menu.drawLoading(graphics);
        } else {
            switch (mode) {
                case 0: {
                    Menu.drawSplash(graphics);
                    break;
                }
                case 1: {
                    Menu.drawMenu(graphics, currentMenu);
                    break;
                }
                case 2: {
                    Game.onDraw(graphics);
                    break;
                }
            }
            Game.demoHandleDemoMode(graphics);
        }
    }

    private static final void handleSplash() {
        if (splashMode == 0) {
            currentSplash = -1;
            Menu.advanceSplashMode();
            return;
        }
        if (splashMode == 1) {
            Menu.loadRMS();
            GL.handsonMoreGamesReadBuySetup();
            Menu.advanceSplashMode();
            return;
        }
        if (splashMode == 2) {
            if (RM.getNumResources() == 0) {
                RM.load();
            }
            return;
        }
        if (splashMode == 3) {
            GCanvas.initResources();
            Menu.init();
            Menu.advanceSplashMode();
            return;
        }
        if (splashMode == 4) {
            Game.init();
            Menu.advanceSplashMode();
            return;
        }
        if (splashMode == 5) {
            Menu.updateSplash(Menu.skipSplash());
            return;
        }
        if (splashMode == 6) {
            if (options[2] == 6) {
                Menu.changeMenu(20, false);
            } else {
                Menu.advanceSplashMode();
            }
            return;
        }
        if (splashMode == 12) {
            if (soundPresent) {
                Menu.prepareSoundSplash();
                soundSplashStart = GCanvas.getUptimeMillis();
                Menu.changeMenu(19, false);
            } else {
                Menu.advanceSplashMode();
            }
            return;
        }
        if (splashMode == 7) {
            Menu.advanceSplashMode();
            Menu.advanceSplashMode();
            return;
        }
        if (splashMode == 8) {
            return;
        }
        if (splashMode == 9) {
            Menu.advanceSplashMode();
            return;
        }
        if (splashMode == 10) {
            if (currentSplash >= 0) {
                Menu.updateSplash(Menu.skipSplash());
            } else {
                Menu.startSplash(1, 2000);
            }
            return;
        }
        if (splashMode == 11) {
            if (currentSplash >= 0) {
                Menu.updateSplash(Menu.skipSplash());
            } else {
                Menu.startSplash(2, 10000);
            }
            return;
        }
        if (splashMode == 13) {
            int n = 0;
            Menu.changeMenu(n, false);
        }
    }

    private static final void advanceSplashMode() {
        GCanvas.resetKeys();
        ++splashMode;
    }

    private static final void prepareSoundSplash() {
        String string = RM.t(59);
        if (options[0] != 0) {
            string = RM.t(58);
        }
        String string2 = String.valueOf(GCanvas.getSecond(10999 - soundSplashTime));
        RM.prepareVarText(4, string, string2);
    }

    protected static final void onInput() {
        if (showLoading) {
            return;
        }
        if (mode == 0) {
            Menu.handleSplash();
            return;
        }
        if (sound != null) {
            sound.tick();
        }
        if (Menu.processSoftKeys() || Game.menuProcessActions()) {
            return;
        }
        if (mode == 2) {
            if (delayedMenuCountDown < 0) {
                Game.onInput();
            } else if (--delayedMenuCountDown == 0) {
                Menu.changeMenu(delayedMenu, false);
            }
        }
        if (mode == 1) {
            Game.menuOnInput();
            int n = Menu.getMenuType(currentMenu);
            if (n != 3) {
                if (GCanvas.consumeUP()) {
                    Menu.setSelection(currentMenu, selectedItem - 1, -1, false);
                }
                if (GCanvas.consumeDOWN()) {
                    Menu.setSelection(currentMenu, selectedItem + 1, 1, false);
                }
                if (GCanvas.consumeFIRE()) {
                    Menu.menuItemSelected();
                }
                if (currentMenu == 19) {
                    soundSplashTime = (int)(GCanvas.getUptimeMillis() - soundSplashStart);
                    if (soundSplashTime >= 9999) {
                        ++splashMode;
                        Menu.changeMode(0);
                    } else {
                        Menu.prepareSoundSplash();
                        Menu.refreshMenu();
                    }
                }
                if (currentMenu == 25) {
                    if (GCanvas.consumeLEFT()) {
                        Menu.performMenuAction(35, -1);
                    }
                    if (GCanvas.consumeRIGHT()) {
                        Menu.performMenuAction(35, 1);
                    }
                }
            } else {
                Menu.enterNameInput();
            }
        }
    }

    private static final void enterNameInput() {
        int n;
        if (GCanvas.consumeKey(1)) {
            Menu.setSelection(currentMenu, selectedItem - 1, -1, false);
        }
        if (GCanvas.consumeKey(4)) {
            Menu.setSelection(currentMenu, selectedItem + 1, 1, false);
        }
        if (GCanvas.consumeKey(32768)) {
            Menu.performMenuAction(60);
            return;
        }
        if (GCanvas.consumeKey(65536)) {
            Menu.enterNameChar('_');
            Menu.enterNamePos(1);
            Menu.ttapReset();
            return;
        }
        if (GCanvas.consumeKey(8)) {
            Menu.enterNamePos(-1);
            return;
        }
        if (GCanvas.consumeKey(2)) {
            Menu.enterNamePos(1);
            return;
        }
        for (n = 0; n <= 9; ++n) {
            if (!GCanvas.consumeKey(32 << n)) continue;
            int n2 = ttapCountdown = ttap[n].length > 1 ? 12 : 1;
            if (n == ttapKey && inputType != 2) {
                ++ttapPos;
                ttapPos %= ttap[n].length;
            } else {
                if (ttapChar != '\u0000') {
                    Menu.enterNamePos(1);
                }
                ttapKey = n;
                ttapPos = 0;
            }
            ttapChar = ttap[n][ttapPos];
            if (inputType == 0) {
                ttapChar = Character.toUpperCase(ttapChar);
            } else if (inputType == 2) {
                ttapChar = ttap[n][ttap[n].length - 1];
            }
            Menu.enterNameChar(ttapChar);
        }
        if (--ttapCountdown == 0) {
            Menu.enterNamePos(1);
            Menu.ttapReset();
        }
        n = menus[currentMenu][3];
        int n3 = -1;
        if (enterNameMax == 0) {
            n3 = -1;
        }
        GCanvas.setSoftButton(n, n3);
    }

    private static final void drawEnterNameItem(Graphics graphics, Font font, String string, String string2, int n, int n2, int n3, int n4, int n5) {
        Menu.drawMenuItem(graphics, font, -10872824, string, n2, n3, 20);
        graphics.setColor(-10872824);
        graphics.drawRect(n2, n3 += n5, n4, n5);
        GCanvas.pushClip(graphics);
        GCanvas.clipRect(graphics, n2, n3, n4, n5);
        graphics.setColor(-10872824);
        graphics.drawString(string2, n2 + 2 - n, n3 + 1, 20);
        GCanvas.popClip(graphics);
    }

    private static final void drawEntername(Graphics graphics, int n, StringBuffer stringBuffer, int n2, int n3) {
        int n4;
        int n5 = GCanvas.FONT_MEDIUM_HEIGHT + 2;
        Font font = GCanvas.FONT_MEDIUM;
        graphics.setFont(font);
        int n6 = 4;
        int n7 = Menu.getMenuItemTop() + (MENU_ITEM_BOTTOM - Menu.getMenuItemTop() >> 1) - n5;
        int n8 = MENU_TEXT_WIDTH - 1;
        String string = stringBuffer.toString().trim();
        char c = stringBuffer.charAt(enterNamePos);
        int n9 = 0;
        for (n4 = 0; n4 < enterNamePos; ++n4) {
            n9 += RM.getCharWidth(stringBuffer.charAt(n4), font);
        }
        n4 = 0;
        int n10 = n6 + n9 + 1;
        int n11 = ttapCountdown < 0 ? RM.getCharWidth(stringBuffer.charAt(enterNamePos), font) : RM.getCharWidth(ttapChar, font);
        if (n10 + n11 > n8) {
            n4 = n11 + n10 - n8;
        }
        n10 -= n4;
        int n12 = n7 + n5;
        if ((GCanvas.getGlobalFrameCount() & 7) != 0) {
            graphics.setColor(-16711936);
            if (c == ' ') {
                graphics.drawLine(n10, n12 + 2, n10, n12 + n5 - 2);
            } else {
                graphics.fillRect(n10, n12 + 2, n11 + 1, n5 - 4);
            }
        }
        String string2 = RM.t(Menu.getMenuItemCaption(menuItems[n2][0]));
        Menu.drawEnterNameItem(graphics, font, string2, string, n4, n6, n7, n8, n5);
        String string3 = string;
        Menu.drawMenuItem(graphics, font, -10872824, RM.t(133), GCanvas.width - 4, MENU_ITEM_BOTTOM - n5, 24);
        Menu.drawMenuItem(graphics, font, -10872824, String.valueOf(string3.length()) + "/" + String.valueOf(n3), 4, MENU_ITEM_BOTTOM - n5, 20);
    }

    private static final boolean skipSplash() {
        return GCanvas.consumeAnyKey();
    }

    private static final void startSplash(int n, int n2) {
        splashStartTime = GCanvas.getUptimeMillis();
        splashMaxTime = n2;
        currentSplash = n;
        int n3 = Menu.getSplashID(currentSplash - 1);
        if (n3 >= 0) {
            RM.forget(n3);
        }
        RM.load(Menu.getSplashID(currentSplash));
        GCanvas.redraw();
    }

    private static final void updateSplash(boolean bl) {
        if (bl) {
            Menu.splashFinished();
        } else {
            currentSplashTime = (int)(GCanvas.getUptimeMillis() - splashStartTime);
            if (currentSplashTime > splashMaxTime) {
                Menu.splashFinished();
            }
        }
    }

    private static void splashFinished() {
        if (currentSplash >= 0) {
            Menu.advanceSplashMode();
            int n = Menu.getSplashID(currentSplash);
            if (n >= 0) {
                RM.forget(n);
            }
            currentSplash = -1;
        }
    }

    private static final void setInitialOptions(boolean bl) {
        int n;
        if (options == null) {
            options = new int[34];
        }
        if (bl) {
            Menu.options[2] = 6;
        }
        Menu.options[0] = soundDefault ? 50 : 0;
        Menu.options[1] = vibraDefault ? 1 : 0;
        for (n = 4; n < 27; ++n) {
            Menu.options[n] = 0;
        }
        Game.setOptionDefaults();
        if (!bl) {
            n = options[0];
            Menu.menuVolumeChanged(1, Menu.getMenuItemCaption(currentMenu, selectedItem), n);
        }
    }

    public static final int getOption(int n) {
        return options[n];
    }

    public static final void setOption(int n, int n2) {
        if (n2 != options[n]) {
            Menu.options[n] = n2;
        }
    }

    private static final StringBuffer createInputBuffer(String string, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.insert(0, string);
        stringBuffer.setLength(n2);
        for (n3 = string.length(); n3 < n2; ++n3) {
            stringBuffer.setCharAt(n3, ' ');
        }
        if (n > 0) {
            n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                Menu.options[i] = stringBuffer.charAt(i - n);
            }
        }
        return stringBuffer;
    }

    private static final void loadRMS() {
        String[] stringArray = new String[]{midletInfo[0] + "_opt", midletInfo[0] + "_his"};
        RM.initRMS(stringArray);
        options = RM.getRMSInts(0);
        if (options == null || RM.getRMSError() == 1) {
            Menu.setInitialOptions(true);
        } else if (options.length != 34) {
            RM.deleteRecordStore(0);
            options = null;
            Menu.setInitialOptions(true);
            RM.setStoreDirty(0);
        }
        Menu.loadHighscore();
        int n = options[2];
        if (forcedLang != null) {
            RM.setLocale(forcedLang);
            Menu.options[2] = RM.languageIndex;
        } else {
            if (n == 6) {
                n = 0;
            }
            RM.setLocale(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadHighscore() {
        localHighscoreScoreTable = new int[1][10];
        Object var0 = null;
        byte[] byArray = RM.getRMS(1, false);
        if (RM.getRMSError() != 1) {
            DataInputStream dataInputStream = RM.getDataInput(byArray);
            try {
                for (int i = 0; i < 1; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        Menu.localHighscoreScoreTable[i][j] = dataInputStream.readInt();
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                RM.closeStream(dataInputStream);
            }
        }
    }

    protected static final void doPause() {
        GCanvas.resetKeys();
        Menu.stopMusic();
        if (!paused) {
            paused = true;
            if (mode != 0 && (mode != 1 || currentMenu != 19)) {
                if (mode == 2 || Menu.getMenuType(currentMenu) != 4) {
                    Menu.userPause(true);
                }
            } else {
                pausedOnSplash = true;
            }
        }
    }

    public static final void userPause(boolean bl) {
        if (mode == 2) {
            sUserPaused = true;
            if (delayedMenuCountDown > 0) {
                delayedMenuCountDown = -1;
                Menu.changeMenu(delayedMenu, false);
            } else {
                Menu.changeMenu(5, false);
            }
        }
    }

    private static final int getMaxPos(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length();
        for (int i = 0; i < n2 && stringBuffer.charAt(i) != ' '; ++i) {
            ++n;
        }
        return n < n2 ? n : n2 - 1;
    }

    private static final void ttapReset() {
        ttapCountdown = -1;
        ttapChar = '\u0000';
        ttapPos = -1;
        ttapKey = 0;
    }

    private static final StringBuffer getEnterNameBuffer() {
        return selectedItem == 0 ? connectedUserName : connectedPhoneNumber;
    }

    private static final void enterNameBack() {
        boolean bl;
        StringBuffer stringBuffer = Menu.getEnterNameBuffer();
        boolean bl2 = bl = stringBuffer.charAt(enterNamePos) == ' ' && enterNamePos > 0;
        if (ttapCountdown >= 0) {
            if (enterNamePos == enterNameMax) {
                Menu.enterNamePos(1);
            }
            Menu.ttapReset();
        }
        int n = stringBuffer.length() - 1;
        if (bl) {
            Menu.enterNamePos(-1);
        }
        for (int i = enterNamePos; i < n; ++i) {
            stringBuffer.setCharAt(i, stringBuffer.charAt(i + 1));
        }
        stringBuffer.setCharAt(n, ' ');
        Menu.enterNamePos(-1);
        if (bl) {
            Menu.enterNamePos(1);
        }
    }

    private static final void enterNamePos(int n) {
        enterNameMax = Menu.getMaxPos(Menu.getEnterNameBuffer());
        enterNamePos = Math.max(0, Math.min(enterNamePos + n, enterNameMax));
    }

    private static final void enterNameChar(char c) {
        StringBuffer stringBuffer = Menu.getEnterNameBuffer();
        stringBuffer.setCharAt(enterNamePos, c);
        enterNameMax = Menu.getMaxPos(stringBuffer);
    }

    protected static final int getMenuType(int n) {
        return menus[n][1];
    }

    public static final int getMenuCaption(int n) {
        byte by = menus[n][0];
        return by != -1 ? by & 0xFF : -1;
    }

    private static final void menuItemSelected() {
        if (selectedItem >= 0) {
            int n = Menu.getMenuType(currentMenu);
            int n2 = n == 2 || currentMenu == -1 ? 0 : selectedItem;
            byte[] byArray = menuItems[currentMenu][n2];
            int n3 = byArray[2] & 0xFF;
            int n4 = byArray[3] & 0xFF;
            Menu.performMenuAction(n3, n4);
        } else {
            Menu.performMenuAction(3);
        }
    }

    private static final void menuVolumeChanged(int n, int n2, int n3) {
        boolean bl;
        int n4 = options[n3];
        boolean bl2 = bl = n3 == 0;
        if (n3 == 0) {
            Menu.options[n3] = n4 == 0 ? 50 : 0;
        }
        sound.setVolume(options[0], options[0]);
        if (bl) {
            if (currentMenu == 6 && menuCaller[6] == 5) {
                Menu.playSound(35);
            } else {
                Menu.playMusic(false);
            }
        }
        Menu.refreshMenu();
    }

    private static final void prepareVolumeText() {
        String string = null;
        int n = 59;
        int n2 = options[0];
        string = n2 == 0 ? RM.t(n) : RM.t(58);
        RM.prepareVarText(2, string);
    }

    public static final void performMenuAction(int n) {
        Menu.performMenuAction(n, -1);
    }

    public static final void performMenuAction(int n, int n2) {
        switch (n) {
            case 0: {
                break;
            }
            case 5: {
                Menu.changeMenu(n2, true);
                break;
            }
            case 6: {
                Menu.changeMenu(n2, false);
                break;
            }
            case 15: {
                Menu.performMenuAction(6, 0);
                sUserPaused = false;
                break;
            }
            case 1: {
                Menu.menuItemSelected();
                break;
            }
            case 2: {
                Menu.performMenuAction(3);
                break;
            }
            case 3: {
                if (menuCaller[currentMenu] != -2) {
                    Menu.changeMenu((int)menuCaller[currentMenu], false);
                    break;
                }
                Menu.performMenuAction(4);
                break;
            }
            case 7: {
                GCanvas.setSoftButton(-1, -1);
                Game.initGame(true);
                Menu.changeMode(2);
                Game.tutorialUpdate();
                break;
            }
            case 13: {
                Game.restart(true);
                Menu.changeMode(2);
                break;
            }
            case 4: {
                sUserPaused = false;
                Menu.changeMode(2);
                Game.tutorialUpdate();
                break;
            }
            case 26: {
                Menu.startLoading(98);
                RM.deleteAllRecordStores();
                Menu.setInitialOptions(false);
                localCommunityHighscore = 0;
                Menu.loadHighscore();
                Menu.stopLoadingRefresh();
                Menu.performMenuAction(3);
                break;
            }
            case 28: {
                int n3 = options[n2];
                Menu.options[n2] = n3 == 0 ? 1 : 0;
                Menu.refreshMenu();
                break;
            }
            case 34: {
                Menu.openDebugMenu(25);
                break;
            }
            case 35: {
                if ((currentTranslationString += n2) < 0) {
                    currentTranslationString = RM.getNumStrings() - 1;
                }
                if (currentTranslationString >= RM.getNumStrings()) {
                    currentTranslationString = 0;
                }
                RM.setString(139, RM.getRawString(currentTranslationString));
                Menu.updateTranslationStringCounter();
                Menu.refreshMenu();
                break;
            }
            case 16: {
                Menu.stop();
                break;
            }
            default: {
                if (n == 25) {
                    RM.setLocale(n2);
                    Menu.startLoading(96);
                    Menu.options[2] = RM.languageIndex;
                    Menu.saveOptions();
                    Menu.onLanguageChanged();
                    Menu.stopLoadingRefresh();
                    if (splashMode >= 13) {
                        Menu.performMenuAction(3);
                        break;
                    }
                    ++splashMode;
                    Menu.changeMode(0);
                    Menu.onInput();
                    break;
                }
                if (n == 60) {
                    if (selectedItem != 0) break;
                    inputTypeName = inputTypeName == 0 ? 1 : 0;
                    RM.setString(133, RM.t(134 + inputTypeName));
                    inputType = inputTypeName;
                    Menu.ttapReset();
                    break;
                }
                if (n == 19) {
                    tmpConnectedUserName = connectedUserName.toString();
                    Menu.createInputBuffer(tmpConnectedUserName, 27, 5);
                    Menu.saveOptions();
                    Menu.addLocalHighscoreCandidate();
                    Menu.changeMenu(0, false);
                    break;
                }
                if (n == 20) {
                    Menu.enterNameBack();
                    break;
                }
                if (n == 27) {
                    Menu.menuVolumeChanged(1, Menu.getMenuItemCaption(currentMenu, selectedItem), n2);
                    break;
                }
                if (n == 47) {
                    if (options[0] == 0) {
                        Menu.options[0] = 50;
                    }
                    Menu.changeMenu(0, false);
                    Menu.saveOptions();
                    break;
                }
                if (n == 48) {
                    Menu.options[0] = 0;
                    Menu.changeMenu(0, false);
                    Menu.saveOptions();
                    break;
                }
                if (n == 31) {
                    Menu.shellOutIplay();
                    break;
                }
                if (n == 32) {
                    Menu.shellOutSprint();
                    break;
                }
                Game.performMenuAction(n, n2);
            }
        }
    }

    private static final void openDebugMenu(int n) {
        byte by;
        Menu.menus[n][4] = by = (byte)(mode == 2 ? 7 : 1);
        int n2 = Menu.getMenuItemCount(n) - 1;
        if (Menu.getMenuItemCaption(n, n2) == 21) {
            byte by2;
            Menu.menuItems[n][n2][2] = by2 = (byte)(mode == 2 ? 4 : 3);
        }
        Menu.changeMenu(n, true);
    }

    private static final void shellOutIplay() {
        try {
            MIDP20Proxy.platformRequest(BEEzzz2D.instance, exitURL);
            Menu.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void shellOutSprint() {
    }

    public static final void refreshMenu() {
        if (mode == 1) {
            int n = selectedItem;
            Menu.changeMenu(currentMenu, false);
            boolean bl = true;
            int n2 = Menu.getMenuType(currentMenu);
            if (n2 != 2 && n2 != 5) {
                boolean bl2 = bl = n < menuItems[currentMenu].length && menuItems[currentMenu][n][4] != 0;
            }
            if (bl) {
                Menu.setSelection(currentMenu, n, 0, false);
            }
        }
    }

    private static final int getSplashID(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return -1;
    }

    private static final void drawSplash(Graphics graphics) {
        int n;
        graphics.setColor(splashMode < 11 ? -1 : -8060881);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        int n2 = 2;
        if (currentSplash >= 0 && currentSplash <= n2 && RM.isLoaded(n = Menu.getSplashID(currentSplash))) {
            GCanvas.drawImage(n, GCanvas.width >> 1, GCanvas.height >> 1, 3);
        }
        int n3 = n = (splashMode == 10 || splashMode == 11) && !showLoading ? 1 : 0;
        if (splashMode >= 2 && splashMode <= 5 && n == 0) {
            int n4 = GCanvas.width * 819 >> 10;
            int n5 = GCanvas.height * 16 >> 10;
            int n6 = GCanvas.width * 102 >> 10;
            int n7 = GCanvas.height * 1000 >> 10;
            int n8 = GCanvas.width * 798 >> 10;
            int n9 = GCanvas.height * 20 >> 10;
            if ((n4 & 1) != 0) {
                --n4;
            }
            if ((n5 & 1) != 0) {
                --n5;
            }
            if ((n8 & 1) != 0) {
                --n8;
            }
            if ((n9 & 1) != 0) {
                --n9;
            }
            if (n4 - n8 < 2) {
                n8 = n4 - 2;
            }
            if (n5 - n9 < 2) {
                n9 = n5 - 2;
            }
            if (n5 < 4) {
                n5 = 4;
                n9 = 2;
            }
            int n10 = n6 + (n4 - n8 >> 1);
            int n11 = n7 + (n5 - n9 >> 1);
            int n12 = (n8 << 10) / progressBarMax;
            int n13 = n12 * progressCurrent >> 10;
            graphics.setColor(-4144960);
            graphics.fillRect(n6, n7, n4, n5);
            graphics.setColor(-864252);
            graphics.fillRect(n10, n11, n13, n9);
        } else if (n != 0) {
            int n14 = GCanvas.getHeight() - GCanvas.FONT_SMALL.getHeight() - 5;
            graphics.setFont(GCanvas.FONT_SMALL);
            String string = RM.t(128);
            int n15 = GCanvas.getWidth() >> 1;
            Menu.drawSplashMessage(graphics, string, n15, n14 += 2, 17);
        }
        ++currentSplashFrame;
    }

    private static void drawSplashMessage(Graphics graphics, String string, int n, int n2, int n3) {
        GL.gfxDrawStringOutlined(graphics, string, n, n2, n3, -91354, 0);
    }

    public static final void resetItemBottom() {
        MENU_SEPERATOR_BOTTOM = MENU_ITEM_BOTTOM = sOldItemBottom;
    }

    public static final void setItemBottom(int n) {
        MENU_SEPERATOR_BOTTOM = MENU_ITEM_BOTTOM = n;
    }

    private static final void setupLayout() {
        MENU_SEPERATOR_HEIGHT = GCanvas.getSpriteHeight(0) + 3;
        MENU_SEPERATOR_TOP = 2;
        MENU_SCROLLTEXT_BOTTOM = GCanvas.getSoftKeyAreaTop();
        MENU_SCROLLTEXT_TOP = MENU_SCROLLTEXT_BOTTOM = Math.min(MENU_SCROLLTEXT_BOTTOM, GCanvas.height - RM.getHeight(25) - 2 - 1);
        MENU_SEPERATOR_BOTTOM = MENU_ITEM_BOTTOM = MENU_SCROLLTEXT_TOP - MENU_SEPERATOR_HEIGHT;
        sOldItemBottom = MENU_ITEM_BOTTOM;
        MENU_TEXT_WIDTH = GCanvas.width - 8;
    }

    private static final void init() {
        boolean bl;
        Menu.setupLayout();
        menuCaller = new byte[menus.length];
        Menu.setMenuCaller(0, 16);
        menuSelection = new byte[menus.length];
        menuItemWidths = new int[24];
        if (forcedLang != null) {
            Menu.stripMenuItem(6, 57);
        }
        if (!soundPresent) {
            Menu.stripMenuItem(6, 1);
            Menu.stripMenuItem(6, 2);
        }
        boolean bl2 = bl = exitURL == null;
        if (!bl) {
            // empty if block
        }
        if (bl) {
            Menu.stripMenuItem(0, 12);
        }
        Menu.onLanguageChanged();
        int n = 23;
        int n2 = 10;
        byte[] byArray = menuItems[n][0];
        byte[][] byArray2 = new byte[n2][6];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray3 = byArray2[i];
            System.arraycopy(byArray, 0, byArray3, 0, 6);
        }
        Menu.menuItems[n] = byArray2;
        Menu.initSound();
    }

    private static final void onLanguageChanged() {
        RM.prepareVarText(0, midletInfo[0], midletInfo[2]);
        boolean bl = GCanvas.swapSoftKeys;
        String string = bl ? RM.t(126) : RM.t(127);
        String string2 = bl ? RM.t(127) : RM.t(126);
        RM.prepareVarText(15, new String[]{string, string2});
        exitURL = Game.readMoreGamesUrl();
        Game.onLanguageChanged();
    }

    private static final void stripMenuItem(int n, int n2) {
        byte[][] byArray = menuItems[n];
        int n3 = byArray.length;
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            if (Menu.getMenuItemCaption(byArray[i]) != n2) continue;
            n4 = i;
            break;
        }
        if (n4 >= 0) {
            byte[][] byArrayArray = new byte[n3 - 1][];
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                if (i == n4) continue;
                byArrayArray[n5++] = byArray[i];
            }
            Menu.menuItems[n] = byArrayArray;
        }
    }

    private static final void initSound() {
        sound = new Sound();
        Game.prepareSounds(sound);
    }

    public static final void playMusic(boolean bl) {
        Menu.playSound(34, true, bl);
        titleMusicStarted = true;
    }

    public static final void playSound(int n) {
        if (Menu.getOption(0) != 0) {
            Menu.playSound(n, false, false);
        }
    }

    private static final void playSound(int n, boolean bl, boolean bl2) {
        if (sound != null) {
            Menu.updateVolume();
            if (n >= 0) {
                sound.play(n, bl, bl2);
            }
        }
    }

    public static final void stopMusic() {
        try {
            if (sound != null) {
                sound.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        titleMusicStarted = false;
    }

    private static final void updateVolume() {
        if (sound != null) {
            sound.setVolume(options[0], options[0]);
        }
    }

    public static final int getHighscoreRanking(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = n2 * n3;
        for (int i = 0; i < 10; ++i) {
            int n6 = localHighscoreScoreTable[n][i] * n3;
            if (n6 != 0 && n6 > n5) continue;
            n4 = i;
            break;
        }
        return n4;
    }

    public static final int addLocalHighscoreCandidate() {
        int n = localHighscoreCandidateTable;
        int n2 = localHighscoreCandidateScore;
        int n3 = localHighscoreCandidateSort;
        int n4 = Menu.getHighscoreRanking(n, n2, n3);
        int[] nArray = localHighscoreScoreTable[n];
        Object var5_5 = null;
        if (n4 >= 0) {
            for (int i = 8; i >= n4; --i) {
                nArray[i + 1] = nArray[i];
            }
            nArray[n4] = n2;
            Menu.saveHighscore();
        }
        return n4;
    }

    private static final void drawLoading(Graphics graphics) {
        graphics.setColor(-8060881);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        ++loadingFrame;
        if (scrollText != null) {
            Menu.drawMenuItem(graphics, GCanvas.FONT_SMALL, -3402, scrollText, 5, GCanvas.height - GCanvas.FONT_SMALL_HEIGHT - 5, 20);
        }
    }

    private static final void drawMenu(Graphics graphics, int n) {
        int n2;
        int n3;
        graphics.setColor(-8060881);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        int n4 = Menu.getMenuType(n);
        byte[] byArray = menus[n];
        byte[][] byArray2 = Menu.getMenuItems(n);
        if (byArray2 == null) {
            return;
        }
        int n5 = byArray2.length;
        Game.drawCustomMenuBackground(n, selectedItem, 4, MENU_SEPERATOR_BOTTOM - 4);
        if (menuCaptionImage >= 0) {
            n3 = Menu.getMenuSeperatorTop() - RM.getHeight(menuCaptionImage) - 4;
            n2 = menuCaptionAlignLeft ? 4 : GCanvas.width - RM.getWidth(menuCaptionImage) - 4;
            graphics.drawImage(RM.getImage(menuCaptionImage), n2, n3, 20);
        }
        graphics.setColor(-214012);
        graphics.setColor(-750588);
        n2 = Menu.getMenuCaption(n);
        n3 = 2;
        int n6 = byArray[2];
        if (n6 > 0) {
            n3 += RM.getWidth(n6) + 1;
            Menu.drawIcon(graphics, n6, 2, 2);
        }
        if (n2 != -1) {
            if (scrInfo[0][0] != 0) {
                n3 = GCanvas.width - Menu.updateScrolling(scrInfo[0]);
            }
            Menu.drawMenuItem(graphics, GCanvas.FONT_LARGE, -91354, RM.t(n2), n3, 2, 20);
        }
        if (n5 > 0) {
            Menu.setMenuItemPosition(currentMenu, true, false);
            n6 = (menuItemEase + 512 >> 10) + menuClipTop;
            GCanvas.pushClip(graphics);
            GCanvas.clipRect(graphics, 4, menuClipTop, MENU_TEXT_WIDTH, menuClipHeight);
            switch (n4) {
                case 3: {
                    Menu.drawEntername(graphics, n6, connectedUserName, 24, 5);
                    break;
                }
                default: {
                    if (n4 == 5) {
                        Game.menuDrawHighscoreEntry(graphics, n6);
                        break;
                    }
                    if (byArray2[0][1] >= 0) {
                        Menu.drawMenuItemsIconsLeft(graphics, n, byArray2, n5, n6);
                        break;
                    }
                    Menu.drawMenuItemsCentered(graphics, n4, byArray2, n5, n6);
                }
            }
            GCanvas.popClip(graphics);
            if (sShowUpDownArrows && showUpArrow) {
                GCanvas.drawSprite(0, GCanvas.width >> 1, Menu.getMenuSeperatorTop() + 2, 0);
            }
            if (sShowUpDownArrows && showDownArrow) {
                GCanvas.drawSprite(0, GCanvas.width >> 1, MENU_SEPERATOR_BOTTOM + 2, 1);
            }
        }
    }

    private static final void setMenuItemPosition(int n) {
        menuItemPosition = -selectedItem * n;
        if (menuItemPosition < -menuItemPositionMax) {
            menuItemPosition = -menuItemPositionMax;
        }
        if (menuItemPosition > 0) {
            menuItemPosition = 0;
        }
    }

    private static final void setMenuItemPosition(int n, boolean bl, boolean bl2) {
        showUpArrow = false;
        showDownArrow = false;
        int n2 = Menu.getMenuType(n);
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray == null) {
            return;
        }
        int n3 = byArray.length;
        if (n == -1) {
            n3 = 5 * textScreenItems.length;
        }
        int n4 = MENU_ITEM_BOTTOM - Menu.getMenuItemTop() - 0;
        int n5 = Menu.getMenuHeight(n);
        menuClipTop = Menu.getMenuItemTop() + 0;
        menuClipHeight = MENU_ITEM_BOTTOM - 0 - menuClipTop;
        if (n2 == 2) {
            menuClipTop += 0;
            menuClipHeight -= 0;
        }
        if (n4 >= n5) {
            menuItemPosition = n4 - n5 >> 1;
            menuItemEase = menuItemPosition << 10;
            menuItemPositionMax = n5 - menuClipHeight;
        } else {
            int n6;
            int n7;
            int n8 = Menu.getMenuItemHeight(byArray[0]);
            int n9 = menuClipHeight;
            int n10 = menuClipHeight / n8;
            menuClipHeight = n10 * n8;
            menuClipTop += (n9 - menuClipHeight) / 2;
            menuItemPositionMax = n5 - menuClipHeight;
            if (n2 == 2 || n2 == 5) {
                if (selectedItem > n3 - n10) {
                    selectedItem = n3 - n10;
                }
                Menu.setMenuItemPosition(n8);
            } else {
                if (bl2) {
                    Menu.setMenuItemPosition(n8);
                }
                n7 = -menuItemPosition;
                n6 = n7 / n8;
                int n11 = n6 + n10;
                if (n10 > 2) {
                    if (selectedItem <= n6) {
                        n7 -= n8;
                    }
                    if (selectedItem >= n11 - 1) {
                        n7 += n8;
                    }
                } else {
                    if (selectedItem < n6) {
                        n7 -= n8;
                    }
                    if (selectedItem > n11 - 1) {
                        n7 += n8;
                    }
                }
                if (n7 > menuItemPositionMax) {
                    n7 = menuItemPositionMax;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                menuItemPosition = -n7;
            }
            menuItemEase = bl ? ((n7 = (menuItemPosition << 10) - menuItemEase) < -3 || n7 > 3 ? (menuItemEase += n7 / 4) : (menuItemEase += n7)) : menuItemPosition << 10;
            boolean bl3 = showUpArrow = menuItemPosition < 0;
            if (selectedItem > 0) {
                n7 = 1;
                for (n6 = 0; n6 < selectedItem; ++n6) {
                    n7 = n7 != 0 && byArray[n6][4] == 0 ? 1 : 0;
                }
                if (n7 != 0) {
                    showUpArrow = false;
                }
            }
            showDownArrow = menuItemPosition > -menuItemPositionMax;
        }
        menuClipBottom = menuClipTop + menuClipHeight;
    }

    private static final void drawMenuItemsCentered(Graphics graphics, int n, byte[][] byArray, int n2, int n3) {
        int n4 = GCanvas.width >> 1;
        n4 += 0;
        int n5 = n3;
        Font font = n != 2 ? GCanvas.FONT_MEDIUM : textScreenFont;
        int n6 = font.getHeight();
        int[] nArray = scrInfo[1];
        boolean bl = true;
        boolean bl2 = false;
        int n7 = -1;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            boolean bl3 = byArray2[4] != 0;
            boolean bl4 = bl = n != 1 || bl3;
            if (bl) {
                int n8;
                if (n5 > 0 && (n8 = Menu.getMenuItemCaption(byArray2)) != -1) {
                    int n9 = i == selectedItem && n != 2 && n != 5 ? -3402 : -10872824;
                    int n10 = n9 = bl3 ? n9 : -5987164;
                    if (n != 2) {
                        int n11;
                        boolean bl5;
                        boolean bl6 = bl5 = menuItemWidths[i] > MENU_TEXT_WIDTH;
                        if (i != selectedItem || nArray[0] == 0) {
                            int n12 = RM.getStringWidth(RM.getFittedString(i), font);
                            n11 = n4 - (n12 >> 1);
                            n9 = Game.menuDrawSelectionBar(graphics, n9, n5, n8);
                            Menu.drawOverlay(graphics, i, bl5, byArray2, RM.getFittedString(i), n11, n5, 20);
                            Menu.drawMenuItem(graphics, font, n9, RM.getFittedString(i), n11, n5, 20);
                        } else {
                            n11 = GCanvas.width - Menu.updateScrolling(nArray);
                            n9 = Game.menuDrawSelectionBar(graphics, n9, n5, n8);
                            Menu.drawOverlay(graphics, i, bl5, byArray2, RM.t(n8), n11, n5, 20);
                            Menu.drawMenuItem(graphics, font, n9, RM.t(n8), n11, n5, 20);
                        }
                    } else {
                        Game.menuDrawItem(graphics, textScreenFont, n9, RM.dt(n8), n4, n5, 17);
                    }
                }
                n5 += n6;
                n5 += 0;
            }
            if (n5 > menuClipBottom) break;
        }
    }

    private static final int updateScrolling(int[] nArray) {
        int n = nArray[1];
        int n2 = n >> 10;
        nArray[4] = nArray[4] - 1;
        if (nArray[4] < 0) {
            int n3 = nArray[2];
            int n4 = nArray[3];
            nArray[1] = n += 1536 * nArray[5];
            if (n >= n3 || n < n4) {
                nArray[5] = nArray[5] * -1;
            }
        }
        return n2;
    }

    private static final boolean itemIsVisible(int n, byte[][] byArray, int n2) {
        boolean bl = byArray[n2][4] != 0;
        return Menu.getMenuType(n) != 1 || bl;
    }

    private static final int getLastVisibleItem(int n, byte[][] byArray) {
        int n2 = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (!Menu.itemIsVisible(n, byArray, i)) continue;
            n2 = i;
        }
        return n2;
    }

    private static final int getFirstVisibleItem(int n, byte[][] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (!Menu.itemIsVisible(n, byArray, i)) continue;
            return i;
        }
        throw new IllegalArgumentException("Menu: getFirstVisibleItem: No visible menu item found");
    }

    private static final void drawMenuItemsIconsLeft(Graphics graphics, int n, byte[][] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3;
        int n8 = Menu.getMenuItemHeight(byArray[0]);
        int n9 = n8 - GCanvas.FONT_MEDIUM_HEIGHT >> 1;
        int n10 = Menu.getMenuType(n);
        byte by = byArray[0][1];
        int n11 = Menu.getSpriteFromIcon(by);
        int n12 = GCanvas.getSpriteWidth(n11);
        int n13 = GCanvas.getSpriteHeight(n11);
        int n14 = 0;
        if (n13 < n8) {
            n14 = n8 - n13 >> 1;
        }
        if ((n6 = GCanvas.width - (n5 = Menu.getMaxMenuTextWidth(n10, byArray) - n12 - 4) >> 1) < (n4 = n12 + 8)) {
            n6 = n4;
            n5 = MENU_TEXT_WIDTH - n6;
        }
        int[] nArray = scrInfo[1];
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (n7 > 0) {
                byte[] byArray2 = byArray[i];
                int n15 = Menu.getMenuItemCaption(byArray2);
                boolean bl2 = byArray[i][4] != 0;
                bl = Menu.itemIsVisible(n, byArray, i);
                if (bl) {
                    by = byArray2[1];
                    if (by >= 0) {
                        Menu.drawIcon(graphics, by, n6 - 4, n7 + n14);
                        Menu.drawIconOverlay(graphics, byArray2, n6 - 4, n7 + n14);
                    }
                    int n16 = i == selectedItem ? -3402 : -10872824;
                    n16 = bl2 ? n16 : -5987164;
                    int n17 = n6;
                    if (i == selectedItem && nArray[0] != 0) {
                        n17 = GCanvas.width - Menu.updateScrolling(nArray);
                        Menu.drawMenuItem(graphics, GCanvas.FONT_MEDIUM, n16, RM.t(n15), n17, n7 + n9, 20);
                    } else {
                        Menu.drawMenuItem(graphics, GCanvas.FONT_MEDIUM, n16, RM.getFittedString(i), n17, n7 + n9, 20);
                    }
                }
            }
            if (n7 > graphics.getClipY() + graphics.getClipHeight()) break;
            if (!bl) continue;
            n7 += n8;
        }
    }

    private static final void drawIconOverlay(Graphics graphics, byte[] byArray, int n, int n2) {
    }

    private static final void drawOverlay(Graphics graphics, int n, boolean bl, byte[] byArray, String string, int n2, int n3, int n4) {
    }

    public static final void drawMenuItem(Graphics graphics, Font font, int n, String string, int n2, int n3, int n4) {
        graphics.setFont(font);
        graphics.setColor(n);
        graphics.drawString(string, n2 += 0, n3 += 2, n4);
    }

    private static final void setMenuItemCaption(byte[] byArray, int n) {
        byArray[0] = (byte)n;
    }

    public static final int getMenuItemAction(int n, int n2) {
        return menuItems[n][n2][2];
    }

    public static final int getMenuItemCount(int n) {
        return menuItems[n].length;
    }

    public static final int getMenuItemTarget(int n, int n2) {
        return menuItems[n][n2][3];
    }

    public static final void setMenuItemTarget(int n, int n2, int n3) {
        Menu.menuItems[n][n2][3] = (byte)n3;
    }

    private static final int getMenuItemCaption(byte[] byArray) {
        byte by = byArray[0];
        return by != -1 ? by & 0xFF : -1;
    }

    public static final int getMenuItemCaption(int n, int n2) {
        byte by = menuItems[n][n2][0];
        return by != -1 ? by & 0xFF : -1;
    }

    public static final void setMenuCaller(int n, int n2) {
        Menu.menuCaller[n] = (byte)n2;
    }

    public static final int getCurrentMenu() {
        return currentMenu;
    }

    private static final int getSpriteFromIcon(int n) {
        return iconBases[icons[n][0]];
    }

    private static final void drawIcon(Graphics graphics, int n, int n2, int n3) {
        GCanvas.drawSprite(iconBases[icons[n][0]], n2, n3, icons[n][1]);
    }

    private static final int getMenuItemHeight(byte[] byArray) {
        int n = Menu.getMenuItemCaption(byArray);
        int n2 = 0;
        byte by = byArray[1];
        if (by >= 0) {
            n2 = GCanvas.getSpriteHeight(Menu.getSpriteFromIcon(by));
            if (n != -1) {
                n2 = Math.max(GCanvas.FONT_MEDIUM_HEIGHT, n2);
            }
        } else {
            n2 = GCanvas.FONT_MEDIUM_HEIGHT;
        }
        return n2 + 0;
    }

    private static final byte[][] getMenuItems(int n) {
        return Menu.getMenuType(n) != 2 ? menuItems[n] : textScreenItems;
    }

    private static final int getMenuHeight(int n) {
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray != null && byArray.length > 0) {
            int n2 = Menu.getMenuType(n);
            if (n2 != 1) {
                if (n == -1) {
                    return Menu.getMenuItemHeight(byArray[0]) * (5 + textScreenItems.length);
                }
                return Menu.getMenuItemHeight(byArray[0]) * byArray.length;
            }
            int n3 = byArray.length;
            int n4 = Menu.getMenuItemHeight(byArray[0]);
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                if (byArray[i][4] == 0) continue;
                n5 += n4;
            }
            return n5;
        }
        return GCanvas.FONT_MEDIUM_HEIGHT;
    }

    private static final int getMenuItemTop() {
        return Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT;
    }

    public static final int getMenuSeperatorTop() {
        int n = MENU_SEPERATOR_TOP + menuCaptionOffset;
        if (menuCaptionImage >= 0) {
            n += RM.getHeight(menuCaptionImage);
            n += 4;
        }
        return n;
    }

    private static final int getMaxMenuTextWidth(int n, byte[][] byArray) {
        int n2 = 0;
        int n3 = byArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            if (n == 1 && byArray[i][4] == 0 || (n5 = Menu.getMenuItemCaption(byArray[i])) == -1 || (n4 = RM.getTextWidth(n5, GCanvas.FONT_MEDIUM)) <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    private static final void updateMenuItemsWidths(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        int n3 = Menu.getMenuType(n);
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            int n4 = 4;
            if (n3 != 1 || byArray2[4] != 0) {
                byte by = byArray[0][1];
                if (by >= 0) {
                    n4 = GCanvas.getSpriteWidth(Menu.getSpriteFromIcon(by)) + 4;
                }
                String string = RM.t(Menu.getMenuItemCaption(byArray2));
                RM.fitString(string, i, MENU_TEXT_WIDTH - n4, GCanvas.FONT_MEDIUM);
                n4 += RM.getStringWidth(string, GCanvas.FONT_MEDIUM);
            }
            Menu.menuItemWidths[i] = n4;
        }
    }

    private static final boolean processSoftKeys() {
        int n = GCanvas.getSoftkeys();
        if (n != 0) {
            switch (mode) {
                case 2: {
                    if (n != 262144 && n != 524288) break;
                    Menu.userPause(false);
                    break;
                }
                case 1: {
                    byte by;
                    int n2 = -1;
                    if (n == 131072 && lskEnabled) {
                        n2 = 3;
                    }
                    if (n == 262144 && rskEnabled) {
                        n2 = 4;
                    }
                    if (n == 524288 && rskEnabled) {
                        n2 = 4;
                        if (Menu.getMenuType(currentMenu) == 2 && menus[currentMenu][n2] < 0) {
                            n2 = 3;
                        }
                    }
                    if (n2 == -1 || (by = menus[currentMenu][n2]) < 0) break;
                    byte by2 = GCanvas.softkeys[by][3];
                    Menu.performMenuAction(by2);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static final void changeMode(int n) {
        GCanvas.resetKeys();
        if (n == 2) {
            Menu.stopMusic();
            if (sound != null && paused) {
                Menu.startLoading(96);
                Game.prepareSounds(sound);
                Menu.stopLoading();
            }
            paused = false;
            Menu.menuSelection[5] = 0;
            lskEnabled = true;
            rskEnabled = true;
            Menu.notifyGame(true);
        } else if (n == 1) {
            if (mode == 2) {
                Menu.stopMusic();
                Menu.notifyGame(false);
            }
        } else if (n == 0) {
            GCanvas.setSoftButton(-1, -1);
        }
        GCanvas.hideSoftKeys = n == 2 || n == 0;
        mode = n;
    }

    private static final void notifyGame(boolean bl) {
        Game.notify(bl);
    }

    private static final void prepareMessage(String string, String string2, int n, int n2, int n3, int n4) {
        RM.setString(146, string);
        RM.setString(147, string2);
        Menu.menus[21][3] = (byte)n;
        Menu.menus[21][4] = (byte)n2;
        Menu.menuItems[21][0][2] = (byte)n4;
    }

    private static final void showMessage(String string, String string2, int n, int n2, int n3, int n4) {
        Menu.prepareMessage(string, string2, n, n2, n3, n4);
        Menu.changeMenu(21, n3);
    }

    private static final void showMessage(String string, String string2, int n, int n2, int n3) {
        Menu.showMessage(string, string2, n, n2, n3, 3);
    }

    public static final void showMessage(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            Menu.showMessage(RM.t(n), RM.t(n2), n3, n4, 254);
        } else {
            Menu.showMessage(RM.t(n), RM.t(n2), n3, n4, 254, 0);
        }
    }

    public static final void changeMenu(int n, int n2) {
        Menu.changeMenu(n, false);
        Menu.setMenuCaller(n, n2);
    }

    public static final void changeMenu(int n, boolean bl) {
        GCanvas.resetKeys();
        menuCaptionImage = -1;
        menuCaptionOffset = 0;
        menuCaptionAlignLeft = false;
        if (bl) {
            if (Menu.getMenuType(currentMenu) != 2) {
                Menu.menuSelection[Menu.currentMenu] = (byte)selectedItem;
            }
            if (n != currentMenu) {
                Menu.setMenuCaller(n, currentMenu);
            }
        } else {
            byte by;
            byte bl2 = (byte)(currentMenu != n ? 0 : selectedItem);
            if (menus[currentMenu][1] == 4) {
                by = 0;
            }
            Menu.menuSelection[Menu.currentMenu] = by;
        }
        if (currentMenu == 16) {
            Menu.menuSelection[0] = 0;
        }
        boolean bl2 = n != currentMenu || mode != 1;
        Menu.prepareMenuChange(currentMenu, n);
        if (mode != 1) {
            Menu.changeMode(1);
        }
        boolean bl3 = n == 0;
        textScreenItems = null;
        RM.flushDynamicStrings(0);
        int n2 = Menu.getMenuType(n);
        if (n2 == 2 || n == -1) {
            boolean bl4 = n == 9 || n == 11 || n == 12 || n == 13 || n == 14;
            Menu.prepareScrollText(n, GCanvas.FONT_MEDIUM, MENU_TEXT_WIDTH - RM.getCharWidth('X', GCanvas.FONT_MEDIUM), bl4);
        }
        Menu.updateMenuItemsWidths(n);
        Menu.setSelection(n, menuSelection[n], 1, bl2);
        Menu.setMenuItemPosition(n, false, false);
        Menu.initMenuCaptionScroller(n);
        currentMenu = n;
        Menu.setLocalizedLSKForLanguageSelection();
        if (bl3 && !titleMusicStarted) {
            if (!pausedOnSplash) {
                Menu.playMusic(false);
            } else {
                pausedOnSplash = false;
            }
        }
    }

    public static final void setMenuCaptionImage(int n) {
        Menu.setMenuCaptionImage(n, false);
    }

    public static final void setMenuCaptionImage(int n, boolean bl) {
        menuCaptionImage = n;
        menuCaptionAlignLeft = bl;
    }

    private static final void prepareMenuChange(int n, int n2) {
        if (forcedLang == null && n2 == 20 && RM.languageIndex != 6) {
            Menu.menuSelection[20] = (byte)RM.languageIndex;
        }
        if (n2 == 6) {
            // empty if block
        }
        if (n2 == 25 && n2 != n) {
            currentTranslationString = -1;
            Menu.performMenuAction(35, 1);
        }
        int n3 = Menu.getMenuType(n2);
        if (n == 6 && n2 == menuCaller[6]) {
            Menu.saveOptions();
        }
        if (soundPresent && n2 == 6) {
            Menu.prepareVolumeText();
        }
        Menu.evaluateMenuConditions(n2);
        Game.onPrepareMenuChange(n2, n);
    }

    public static final void evaluateMenuConditions(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            byte by = byArray2[5];
            int n4 = byArray2[3] & 0xFF;
            boolean bl = Menu.evaluateCondition(by, n4);
            byArray2[4] = (byte)(bl ? 1 : 0);
            n3 += bl ? 1 : 0;
        }
    }

    private static final void updateTranslationStringCounter() {
        RM.prepareVarText(18, String.valueOf(currentTranslationString + 1), String.valueOf(RM.getNumStrings()));
    }

    private static final void saveRMS(int n) {
        RM.saveStore(n);
    }

    public static final void saveOptions() {
        RM.setRMS(0, options);
        Menu.saveRMS(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveHighscore() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Object var2_2 = null;
        boolean bl = false;
        try {
            for (int i = 0; i < 1; ++i) {
                for (int j = 0; j < 10; ++j) {
                    dataOutputStream.writeInt(localHighscoreScoreTable[i][j]);
                }
            }
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            RM.setRMS(1, byArray);
            Menu.saveRMS(1);
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataOutputStream);
        }
    }

    public static final boolean evaluateCondition(int n, int n2) {
        switch (n) {
            case -1: 
            case 0: {
                return true;
            }
            case 3: {
                return localHighscoreScoreTable[0][0] != 0;
            }
            case 2: {
                return !isGuest && menuCaller[6] == 0;
            }
        }
        return Game.evaluateCondition(n, n2);
    }

    public static final void setSelectedItem(int n) {
        selectedItem = n;
    }

    private static final void setLocalizedLSKForLanguageSelection() {
        if (currentMenu == 20 && Menu.getMenuItemAction(currentMenu, selectedItem) == 25) {
            switch (Menu.getMenuItemTarget(currentMenu, selectedItem)) {
                case 0: {
                    RM.setString(3, RM.t(40));
                    RM.setString(22, RM.t(23));
                    break;
                }
                case 3: {
                    RM.setString(3, RM.t(42));
                    RM.setString(22, RM.t(25));
                    break;
                }
                case 1: {
                    RM.setString(3, RM.t(41));
                    RM.setString(22, RM.t(24));
                    break;
                }
                case 4: {
                    RM.setString(3, RM.t(44));
                    RM.setString(22, RM.t(27));
                    break;
                }
                case 2: {
                    RM.setString(3, RM.t(43));
                    RM.setString(22, RM.t(26));
                }
            }
        }
    }

    private static final void setSelection(int n, int n2, int n3, boolean bl) {
        boolean bl2;
        int n4;
        byte[][] byArray = menuItems[n];
        int n5 = -1;
        if (!bl) {
            n5 = selectedItem;
        }
        if ((n4 = Menu.getMenuType(n)) == 2) {
            byArray = textScreenItems;
        }
        int n6 = byArray.length;
        n6 = n == -1 ? 5 + textScreenItems.length : Menu.getLastVisibleItem(n, byArray) + 1;
        int n7 = Menu.getFirstVisibleItem(n, byArray);
        boolean bl3 = bl2 = n4 != 2 && n4 != 5 && (n2 < n7 || n2 >= n6);
        if (bl2) {
            if (n2 < n7) {
                n2 = n6 - 1;
            }
            if (n2 >= n6) {
                n2 = n7;
            }
        } else {
            if (n2 < n7) {
                n2 = n7;
            }
            if (n2 >= n6) {
                n2 = n6 - 1;
            }
        }
        if (n4 != 2 && n != -1 && n2 >= n7) {
            while (byArray[n2][4] == 0) {
                if (n3 == 0) {
                    n3 = 1;
                }
                if ((n2 += n3) < n7) {
                    if (bl) {
                        n2 = n7;
                        n3 = -n3;
                    } else {
                        n2 = n5;
                        break;
                    }
                }
                if (n2 < n6) continue;
                if (bl) {
                    n2 = n7;
                    n3 = -n3;
                    continue;
                }
                n2 = n5;
                break;
            }
        }
        selectedItem = n2;
        if (bl2 || bl) {
            Menu.setMenuItemPosition(n, false, true);
        }
        lskEnabled = true;
        rskEnabled = true;
        switch (n) {
            default: 
        }
        if (n == 20 && menuCaller[n] != 6) {
            rskEnabled = false;
        }
        byte[] byArray2 = menus[n];
        int n8 = lskEnabled ? byArray2[3] : -1;
        int n9 = rskEnabled ? byArray2[4] : -1;
        Menu.setLocalizedLSKForLanguageSelection();
        GCanvas.setSoftButton(n8, n9);
        Menu.initMenuScroller(n);
        if (n4 == 3) {
            inputType = selectedItem == 0 ? inputTypeName : 2;
            RM.setString(133, RM.t(134 + inputType));
            Menu.ttapReset();
            enterNamePos = 0;
            enterNameMax = Menu.getMaxPos(Menu.getEnterNameBuffer());
        }
    }

    private static final void initMenuCaptionScroller(int n) {
        int n2 = Menu.getMenuCaption(n);
        if (n2 != -1) {
            int n3 = 2;
            int n4 = menus[n][2];
            if (n4 >= 0) {
                n3 += RM.getWidth(n4) + 1;
            }
            n4 = RM.getTextWidth(n2, GCanvas.FONT_LARGE);
            Menu.setMenuScrollData(scrInfo[0], n4, n3);
        } else {
            Menu.scrInfo[0][0] = 0;
        }
    }

    private static final void initMenuScroller(int n) {
        int n2 = Menu.getMenuType(n);
        if (n2 != 2 && n2 != 5) {
            int n3 = 4;
            byte by = menuItems[n][0][1];
            if (by >= 0) {
                n3 += GCanvas.getSpriteWidth(Menu.getSpriteFromIcon(by));
            }
            Menu.setMenuScrollData(scrInfo[1], menuItemWidths[selectedItem], n3);
        } else {
            Menu.scrInfo[1][0] = 0;
        }
    }

    private static final void setMenuScrollData(int[] nArray, int n, int n2) {
        nArray[0] = 0;
        if (n > MENU_TEXT_WIDTH) {
            int n3 = 2;
            nArray[0] = 1;
            nArray[2] = n + n3 + 8 - n2 << 10;
            nArray[3] = GCanvas.width - 4 - n2 << 10;
            nArray[4] = 20;
            nArray[1] = nArray[3];
            nArray[5] = 1;
        }
    }

    public static final void startLoading(int n) {
        showLoading = true;
        scrollText = RM.t(n);
        GCanvas.setSoftButton(-1, -1);
        GCanvas.hideSoftKeys = true;
        loadingFrame = 0;
        if (mode == 2) {
            Menu.notifyGame(false);
        }
        GCanvas.redraw();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void stopLoadingRefresh() {
        showLoading = false;
        GCanvas.resetKeys();
        boolean bl = GCanvas.hideSoftKeys = mode == 2;
        if (mode == 2) {
            Menu.notifyGame(true);
        } else {
            Menu.refreshMenu();
        }
    }

    public static final void stopLoading() {
        showLoading = false;
        GCanvas.hideSoftKeys = mode == 2;
        GCanvas.resetKeys();
        if (mode == 2) {
            Menu.notifyGame(true);
        }
    }

    private static final int nextBreak(int n, String string, Font font, int n2) {
        int n3 = n;
        int n4 = string.length();
        if (n >= n4) {
            return -1;
        }
        int n5 = n;
        while (true) {
            int n6;
            if (n3 < n4) {
                if (string.charAt(n3) > ' ') {
                    ++n3;
                    continue;
                }
                if (n3 < n4 - 1) {
                    n6 = string.charAt(n3 + 1);
                    if (n6 == 33 || n6 == 63 || n6 == 58 || n6 == 187) {
                        n3 += 2;
                        continue;
                    }
                    if (n3 > 0 && (n6 = (int)string.charAt(n3 - 1)) == 171) {
                        ++n3;
                        continue;
                    }
                }
            }
            n6 = RM.getSubstringWidth(string, n5, n3 - n5, font);
            if (n == n5 && n6 > n2) {
                while (RM.getSubstringWidth(string, n5, --n3 - n5, font) >= n2) {
                }
                n = n3;
                break;
            }
            if (n6 <= n2) {
                n = n3;
            }
            if (n6 > n2 || n3 >= n4 || string.charAt(n3) == '\n') break;
            ++n3;
        }
        return n >= n4 ? n : ++n;
    }

    private static final void prepareScrollText(int n, Font font, int n2, boolean bl) {
        Object object;
        int n3;
        int n4;
        if (bl) {
            Menu.startLoading(96);
        }
        System.gc();
        textScreenFont = font;
        Vector<String> vector = new Vector<String>(10, 2);
        byte[][] byArray = menuItems[n];
        int n5 = byArray.length;
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n4 = 0;
            String string = RM.t(Menu.getMenuItemCaption(byArray[i]));
            while (n4 >= 0 && (n3 = Menu.nextBreak(n4, string, font, n2)) >= 0) {
                object = string.substring(n4, n3).trim();
                int n7 = ((String)object).length();
                if (n7 > 0 || n6 > 0) {
                    vector.addElement((String)object);
                }
                n6 = n7;
                n4 = n3;
            }
            if (n6 <= 0) continue;
            vector.addElement("");
            n6 = 0;
        }
        byte[] byArray2 = menuItems[n][0];
        n4 = byArray2.length;
        int n8 = vector.size();
        for (n3 = n8 - 1; n3 >= 0; --n3) {
            object = (String)vector.elementAt(n3);
            if (((String)object).length() <= 0) continue;
            n8 = n3 + 1;
            break;
        }
        byte[][] byArray3 = new byte[n8][n4];
        RM.flushDynamicStrings(n8);
        for (int i = 0; i < n8; ++i) {
            object = byArray3[i];
            System.arraycopy(byArray2, 0, object, 0, n4);
            int n9 = RM.createDynamicString((String)vector.elementAt(i));
            Menu.setMenuItemCaption((byte[])object, n9);
        }
        textScreenItems = byArray3;
        if (bl) {
            Menu.stopLoading();
        }
    }

    protected static final void onLoadingStart(int n) {
        progressBarMax = n;
        GCanvas.redraw();
    }

    public static final void onLoadingStep(int n) {
        progressCurrent = n;
        if (RM.getCurrentLoading() > Menu.getSplashID(0) && currentSplash < 0) {
            Menu.startSplash(0, 2000);
        }
        if ((n & 0x1F) == 0) {
            GCanvas.redraw();
        }
        GCanvas.idleTick();
    }

    protected static final void onLoadingDone() {
        Menu.advanceSplashMode();
    }

    public static final void loadJadParams() {
        Menu.midletInfo[0] = Menu.readJad("MIDlet-Name") + "";
        Menu.midletInfo[1] = Menu.readJad("MIDlet-Vendor") + "";
        Menu.midletInfo[2] = Menu.readJad("MIDlet-Version") + "";
        int n = GL.handsonEstablishLanguageSetup();
        forcedLang = n != -1 ? GL.HANDSON_LANGUAGE_CODES[n] : null;
        n = GCanvas.width;
        int n2 = GCanvas.height;
        exitURL = Game.readMoreGamesUrl();
        soundDefault = Menu.readJadInt("SOUNDDEFAULTOFF", 1) == 0;
        soundPresent = Menu.readJadInt("SOUNDNOTPRESENT", 0) == 0;
        int n3 = Menu.readJadInt("FORCEDSCREENWIDTH", n);
        int n4 = Menu.readJadInt("FORCEDSCREENHEIGHT", n2);
        GCanvas.setForcedSize(n3, n4);
        GCanvas.swapSoftKeys = Menu.readJadInt("SOFTKEYSWAP", 0) != 0;
    }

    public static final String readJad(String string) {
        String string2 = BEEzzz2D.instance.getAppProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static final int readJadInt(String string, int n) {
        int n2;
        block4: {
            String string2 = Menu.readJad(string);
            n2 = n;
            if (string2 != null) {
                try {
                    int n3;
                    n2 = n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.equals("Y")) {
                        n2 = 1;
                    }
                    if (!string2.equals("N")) break block4;
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    public static final void setOptionBit(int n, int n2) {
        while (n2 >= 32) {
            n2 -= 32;
            --n;
        }
        int n3 = Menu.getOption(n);
        Menu.setOption(n, n3 |= 1 << n2);
    }

    public static final boolean isOptionBitSet(int n, int n2) {
        while (n2 >= 32) {
            n2 -= 32;
            --n;
        }
        return (Menu.getOption(n) & 1 << n2) != 0;
    }

    public static int getMode() {
        return mode;
    }

    public static void showUpDownArrows(boolean bl) {
        sShowUpDownArrows = bl;
    }

    public static String getMidletInfo(int n) {
        if (n < 3) {
            return midletInfo[n];
        }
        return null;
    }

    public static void setMenuOption(int n, int n2, byte by) {
        Menu.menus[n][n2] = by;
    }

    static {
        midletInfo = new String[3];
        currentMenu = 14;
        inputTypeName = inputType = 0;
        highscoreEntriesMax = 10;
        scrInfo = new int[2][6];
        soundSplashTimeHelper = -1;
        resourceLoadingDone = false;
        titleMusicStarted = false;
        uploadingPrevHighscore = false;
        tryToUploadPrevHighscore = true;
        textScreenFont = GCanvas.FONT_MEDIUM;
        ttap = new char[][]{{'0'}, {'1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}};
        progressBarMax = 66;
        sUserPaused = false;
        sOldItemBottom = 0;
        imageSinAngle = 0;
        sShowUpDownArrows = true;
    }
}

