/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3D;

import tinbrain.GCanvas;

public class Point2D {
    public static final Point2D ZERO = new Point2D(0, 0);
    public static final Point2D X = new Point2D(1024, 0);
    public static final Point2D Y = new Point2D(0, 1024);
    public static final Point2D NEGX = new Point2D(-1024, 0);
    public static final Point2D NEGY = new Point2D(0, -1024);
    public static final Point2D tmp0 = new Point2D();
    public static final Point2D tmp1 = new Point2D();
    public static final Point2D tmp2 = new Point2D();
    public static final Point2D tmp3 = new Point2D();
    public static final Point2D tmp4 = new Point2D();
    public static final Point2D ret0 = new Point2D();
    public static final Point2D ret1 = new Point2D();
    public int x;
    public int y;

    public Point2D() {
        this.x = 0;
        this.y = 0;
    }

    public String toString() {
        return null;
    }

    public Point2D(int n, int n2) {
        this.set(n, n2);
    }

    public void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void set(Point2D point2D) {
        this.x = point2D.x;
        this.y = point2D.y;
    }

    public void setDiff(Point2D point2D, Point2D point2D2) {
        this.x = point2D.x - point2D2.x;
        this.y = point2D.y - point2D2.y;
    }

    public final int dot(Point2D point2D) {
        long l = this.x;
        long l2 = this.y;
        long l3 = point2D.x;
        long l4 = point2D.y;
        return (int)(l * l3 + l2 * l4 >> 10);
    }

    public final int dot(int n, int n2) {
        long l = this.x;
        long l2 = this.y;
        long l3 = n;
        long l4 = n2;
        return (int)(l * l3 + l2 * l4 >> 10);
    }

    public final void unit() {
        long l = this.x;
        long l2 = this.y;
        long l3 = l * l + l2 * l2 >> 10;
        int n = GCanvas.sqrt((int)l3);
        this.x <<= 10;
        this.x /= n;
        this.y <<= 10;
        this.y /= n;
    }

    public final void addScaled(Point2D point2D, int n) {
        this.x += (int)((long)point2D.x * (long)n >> 10);
        this.y += (int)((long)point2D.y * (long)n >> 10);
    }

    public final void sub(Point2D point2D) {
        this.x -= point2D.x;
        this.y -= point2D.y;
    }

    public final void sub(int n, int n2) {
        this.x -= n;
        this.y -= n2;
    }

    public final void scale(int n) {
        this.x *= n;
        this.x >>= 10;
        this.y *= n;
        this.y >>= 10;
    }

    public final void div(int n) {
        this.x <<= 10;
        this.x /= n;
        this.y <<= 10;
        this.y /= n;
    }

    public final void shiftR(int n) {
        this.x >>= n;
        this.y >>= n;
    }

    public final int length() {
        long l = this.x;
        long l2 = this.y;
        long l3 = l * l + l2 * l2 >> 10;
        int n = GCanvas.sqrt((int)l3);
        return n;
    }

    public final void setLength(int n) {
        int n2 = this.length();
        if (n2 != 0 && n2 != n) {
            int n3 = (int)(((long)n << 10) / (long)n2);
            this.scale(n3);
        }
    }

    public final void capLength(int n) {
        int n2 = this.length();
        if (n2 != 0 && n2 > n) {
            int n3 = (int)(((long)n << 10) / (long)n2);
            this.scale(n3);
        }
    }
}

