/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;

public class Bin {
    private Cache c;
    private int cacheSize;
    private int numRes;
    private String[] filesName;
    private int[] fileLen;
    private int[] offStart;
    private String binHead;
    private byte[] data;
    private char fn;

    public Bin(char fileName, int cs) {
        this.fn = fileName;
        DataInputStream dis = null;
        try {
            dis = new DataInputStream("/".getClass().getResourceAsStream("/" + fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cacheSize = cs;
        this.c = new Cache(this.cacheSize);
        try {
            int i;
            byte[] t = new byte[3];
            dis.read(t);
            this.binHead = new String(t);
            Debug.print("bin FileHead : " + this.binHead);
            this.numRes = dis.readShort();
            Debug.print("numRes", this.numRes);
            this.fileLen = new int[this.numRes];
            this.offStart = new int[this.numRes];
            this.filesName = new String[this.numRes];
            int sizes = 0;
            for (i = 0; i < this.numRes; ++i) {
                this.fileLen[i] = dis.readInt();
                this.offStart[i] = (sizes += this.fileLen[i]) - this.fileLen[i];
            }
            for (i = 0; i < this.numRes; ++i) {
                t = new byte[dis.readByte()];
                dis.read(t);
                this.filesName[i] = new String(t);
            }
            this.data = new byte[sizes];
            dis.read(this.data);
            dis.close();
            dis = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Image getImage(String fileName) {
        Image i = (Image)this.c.getObject(fileName);
        if (i != null) {
            return i;
        }
        int idx = this.getIndex(fileName);
        if (idx >= 0) {
            Image im = Image.createImage((byte[])this.data, (int)this.offStart[idx], (int)this.fileLen[idx]);
            this.c.addCache(im, this.fn + fileName);
            return im;
        }
        return null;
    }

    public String[] getTXT(String fileName) {
        DataInputStream d = this.getStream(fileName);
        try {
            int l = d.readByte();
            String[] s = new String[l];
            for (int i = 0; i < l; ++i) {
                byte[] b = new byte[d.readByte()];
                d.read(b);
                s[i] = new String(b);
                b = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int getIndex(String fileName) {
        for (int i = 0; i < this.numRes; ++i) {
            if (!this.filesName[i].equals(fileName)) continue;
            return i;
        }
        return -1;
    }

    public DataInputStream getStream(String fileName) {
        DataInputStream i = (DataInputStream)this.c.getObject(fileName);
        if (i != null) {
            return i;
        }
        int idx = this.getIndex(fileName);
        if (idx >= 0) {
            DataInputStream d = new DataInputStream(new ByteArrayInputStream(this.data, this.offStart[idx], this.fileLen[idx]));
            this.c.addCache(d, this.fn + fileName);
            return d;
        }
        return null;
    }

    public void clearCache() {
        this.c.clearCache();
    }
}

