/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.io;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import ng.games.pacman.Game;
import ng.games.pacman.settings.Settings;

public class ResourceManager {
    public static final int LOCALE_ENGLISH = 0;
    public static final int LOCALE_RUSSIAN = 1;
    private String[][] resources;
    private String[][] helpLines;
    private String[][] creditsLines;
    private String[][] congratulationLines;
    public static final int STR_NEW_GAME = 0;
    public static final int STR_EXIT = 1;
    public static final int STR_SETTINGS = 2;
    public static final int STR_TOP10 = 3;
    public static final int STR_ENTER_YOUR_NAME = 4;
    public static final int STR_SCORE_CONGRATULATION = 5;
    public static final int STR_OK = 6;
    public static final int STR_APPLY = 7;
    public static final int STR_LANGUAGE = 8;
    public static final int STR_SOUND = 9;
    public static final int STR_ON = 10;
    public static final int STR_OFF = 11;
    public static final int STR_PAUSED = 12;
    public static final int STR_RESUME = 13;
    public static final int STR_LEVEL = 14;
    public static final int STR_MAIN_MENU = 15;
    public static final int STR_HELP = 16;
    public static final int STR_HELP_TEXT = 17;
    public static final int STR_CREDITS = 18;
    public static final int STR_CREDITS_TEXT = 19;
    public static final int STR_DIFFICULTY = 20;
    public static final int STR_EASY = 21;
    public static final int STR_MEDIUM = 22;
    public static final int STR_HARD = 23;
    public static final int STR_PAUSE = 24;
    public static final int STR_BACK = 25;
    public static final int STR_SELECT = 26;
    public static final int STR_REGISTRATION = 27;
    public static final int STR_UNREGISTERED1 = 28;
    public static final int STR_UNREGISTERED2 = 29;
    public static final int STR_UNREGISTERED3 = 30;
    public static final String[] locales = new String[]{"\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"};
    public static final String[] localeFiles = new String[]{"ru", "ua"};
    private int locale = 0;
    private static ResourceManager instance = null;
    public static final String[] INPUT_LETTERS = new String[]{" ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static int maxLetterWidth = -1;

    public int getLocale() {
        return this.locale;
    }

    public void setLocale(int n) {
        this.locale = n;
    }

    public void loadStringResources() {
        int n;
        this.resources = new String[locales.length][];
        for (n = 0; n < locales.length; ++n) {
            this.resources[n] = this.loadTextual(localeFiles[n]);
            Game.getInstance().increaseProgress(1);
        }
        this.helpLines = new String[locales.length][];
        this.creditsLines = new String[locales.length][];
        this.congratulationLines = new String[locales.length][];
        for (n = 0; n < locales.length; ++n) {
            this.helpLines[n] = ResourceManager.breakIntoLines(this.getStringResource(17, n), Settings.DEFAULT_FONT, 172);
            Game.getInstance().increaseProgress(1);
            this.creditsLines[n] = ResourceManager.breakIntoLines(this.getStringResource(19, n), Settings.DEFAULT_FONT, 172);
            Game.getInstance().increaseProgress(1);
            this.congratulationLines[n] = ResourceManager.breakIntoLines(this.getStringResource(5, n), Settings.DEFAULT_FONT, 172);
            Game.getInstance().increaseProgress(1);
        }
    }

    public String[] getCredits() {
        return this.creditsLines[this.locale];
    }

    public String[] getHelp() {
        return this.helpLines[this.locale];
    }

    public String[] getCongratulaion() {
        return this.congratulationLines[this.locale];
    }

    private final String[] loadTextual(String string) throws IllegalStateException {
        String[] stringArray = null;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + string));
            stringArray = new String[((DataInputStream)filterInputStream).readInt()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((DataInputStream)filterInputStream).readUTF();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        filterInputStream = null;
        return stringArray;
    }

    public String getStringResource(int n) {
        return this.resources[this.locale][n];
    }

    public String getStringResource(int n, int n2) {
        return this.resources[n2][n];
    }

    public Image getImage(String string) {
        Image image = null;
        System.out.println("name = " + string);
        try {
            image = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException(exception.toString());
        }
        return image;
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public static int getMaxLetterWidth() {
        if (maxLetterWidth < 0) {
            Font font = Settings.DEFAULT_FONT;
            for (int i = 0; i < INPUT_LETTERS.length; ++i) {
                if (font.stringWidth(INPUT_LETTERS[i]) <= maxLetterWidth) continue;
                maxLetterWidth = font.stringWidth(INPUT_LETTERS[i]);
            }
        }
        return maxLetterWidth;
    }

    public static String[] breakIntoLines(String string, Font font, int n) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        while (n4 < string.length()) {
            n2 = font.stringWidth(stringBuffer.toString());
            if (n2 > n) {
                if (n3 > 0) {
                    vector.addElement(stringBuffer.toString().substring(0, stringBuffer.length() - n4 + n3).trim());
                    n4 = n3 + 1;
                } else {
                    --n4;
                    vector.addElement(stringBuffer.toString().substring(0, stringBuffer.length() - 1).trim());
                }
                stringBuffer.delete(0, stringBuffer.length());
                n3 = 0;
                continue;
            }
            c = string.charAt(n4);
            if (c == '\n') {
                vector.addElement(stringBuffer.toString().trim());
                stringBuffer.delete(0, stringBuffer.length());
                n3 = 0;
            } else {
                stringBuffer.append(c);
                if (c == ' ') {
                    n3 = n4;
                }
            }
            ++n4;
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString().trim());
        }
        Object[] objectArray = null;
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }
}

