/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.sprites;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import ng.games.pacman.GameManager;
import ng.games.pacman.levels.Level;
import ng.games.pacman.util.Increaser;
import ng.games.pacman.util.image.ImageFramer;

public abstract class MovableObject {
    private ImageFramer frames;
    private int framesCount;
    private int speed;
    private Increaser frameIndexIncreaser;
    private Increaser xPosIncreaser;
    private Increaser yPosIncreaser;
    private Level level;
    private int direction;
    public short[][] distanceMatrice;
    private int lastX;
    private int lastY;
    private Vector addedPoints;
    private Vector newAddedPoints;
    private int nextXPoint;
    private int nextYPoint;
    private boolean canMove;
    private int[] animationFlow = new int[]{0, 1, 0, 2};

    protected abstract void cellReached(int var1, int var2);

    public void draw(Graphics graphics, int n, int n2) {
        this.frames.drawFrame(graphics, this.getCurrentFrameIndex(), n, n2);
    }

    public int getDirection() {
        return this.direction;
    }

    public int getFramesCount() {
        return this.framesCount;
    }

    public int getCurrentFrameIndex() {
        return this.animationFlow[this.frameIndexIncreaser.getValue()];
    }

    MovableObject(ImageFramer imageFramer, int n, int n2, int n3) {
        this.frames = imageFramer;
        this.framesCount = n;
        this.speed = n3;
        this.frameIndexIncreaser = new Increaser(0, n2, 0, this.animationFlow.length - 1);
        this.frameIndexIncreaser.setRoll(true);
    }

    public void updateLogic(long l) {
        this.updateIncreasers(l);
        if (this.isCellReached()) {
            int n = Math.abs(this.nextXPoint - this.getXPos()) + Math.abs(this.nextYPoint - this.getYPos());
            this.setXPos(this.nextXPoint);
            this.setYPos(this.nextYPoint);
            this.cellReached(this.getXCell(), this.getYCell());
            if (this.moveToNextCell()) {
                this.setXPos(this.getXPos() + n * GameManager.DIRECTION_INCREMENTS[this.direction][0]);
                this.setYPos(this.getYPos() + n * GameManager.DIRECTION_INCREMENTS[this.direction][1]);
            }
        }
    }

    private boolean isCellReached() {
        boolean bl = false;
        if (GameManager.DIRECTION_INCREMENTS[this.direction][0] > 0) {
            bl = this.getXPos() >= this.nextXPoint;
        } else if (GameManager.DIRECTION_INCREMENTS[this.direction][0] < 0) {
            boolean bl2 = bl = this.getXPos() <= this.nextXPoint;
        }
        if (GameManager.DIRECTION_INCREMENTS[this.direction][1] > 0) {
            bl = this.getYPos() >= this.nextYPoint;
        } else if (GameManager.DIRECTION_INCREMENTS[this.direction][1] < 0) {
            bl = this.getYPos() <= this.nextYPoint;
        }
        return bl;
    }

    private void setXPos(int n) {
        this.xPosIncreaser.setValue(n);
    }

    private void setYPos(int n) {
        this.yPosIncreaser.setValue(n);
    }

    private void updateIncreasers(long l) {
        this.frameIndexIncreaser.shiftTime((int)l);
        this.xPosIncreaser.shiftTime((int)l);
        this.yPosIncreaser.shiftTime((int)l);
        this.xPosIncreaser.increase();
        this.yPosIncreaser.increase();
        this.frameIndexIncreaser.increase();
    }

    private void checkNextCellReached() {
        if (this.getXCell() != this.nextXPoint / 16 || this.getYCell() != this.nextYPoint / 16) {
            int n = this.getXCell();
            int n2 = this.getYCell();
            this.cellReached(n, n2);
            this.moveToNextCell();
        }
    }

    protected Level getLevel() {
        return this.level;
    }

    public int getYCell() {
        return this.getYPos() / 16;
    }

    public int getXCell() {
        return this.getXPos() / 16;
    }

    public void setLevel(Level level) {
        this.xPosIncreaser = new Increaser(0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.yPosIncreaser = new Increaser(0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.level = level;
    }

    protected void makeTurn(int n) {
        this.setDirection(n);
        this.moveToNextCell();
    }

    protected boolean moveToNextCell() {
        this.canMove = this.canMove(this.direction);
        if (this.canMove) {
            this.nextXPoint = (this.getXCell() + GameManager.DIRECTION_INCREMENTS[this.direction][0]) * 16;
            this.nextYPoint = (this.getYCell() + GameManager.DIRECTION_INCREMENTS[this.direction][1]) * 16;
        }
        return this.canMove;
    }

    public void setSpeed(int n) {
        this.speed = n;
        if (this.xPosIncreaser != null) {
            this.xPosIncreaser.setIncrement(this.getXIncrement(this.direction));
        }
        if (this.yPosIncreaser != null) {
            this.yPosIncreaser.setIncrement(this.getYIncrement(this.direction));
        }
    }

    protected boolean canMove(int n) {
        return this.level.getObjectAt(this.getXCell() + GameManager.DIRECTION_INCREMENTS[n][0], this.getYCell() + GameManager.DIRECTION_INCREMENTS[n][1]) < 8;
    }

    public int getXPos() {
        return this.xPosIncreaser.getValue();
    }

    public int getYPos() {
        return this.yPosIncreaser.getValue();
    }

    protected void setDirection(int n) {
        this.direction = n;
        this.xPosIncreaser.setIncrement(this.getXIncrement(n));
        this.yPosIncreaser.setIncrement(this.getYIncrement(n));
    }

    private int getYIncrement(int n) {
        return this.speed * GameManager.DIRECTION_INCREMENTS[n][1];
    }

    private int getXIncrement(int n) {
        return this.speed * GameManager.DIRECTION_INCREMENTS[n][0];
    }

    public void setPosition(int n, int n2) {
        int n3 = n * 16;
        int n4 = n2 * 16;
        this.xPosIncreaser = new Increaser(n3, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.yPosIncreaser = new Increaser(n4, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int n5 = 0;
        while (!this.canMove(n5)) {
            ++n5;
        }
        this.makeTurn(n5);
        this.lastX = n3;
        this.lastY = n4;
    }

    protected void buildDistanceMatrice() {
        int n;
        int n2 = 0;
        this.distanceMatrice = new short[this.getLevel().getWidth()][this.getLevel().getHeight()];
        for (n = 0; n < this.getLevel().getWidth(); ++n) {
            for (int i = 0; i < this.getLevel().getHeight(); ++i) {
                this.distanceMatrice[n][i] = this.getLevel().getObjectAt(n, i) >= 8 ? -1 : 99;
            }
        }
        this.distanceMatrice[this.getXCell()][this.getYCell()] = 0;
        n = 1;
        if (this.addedPoints == null) {
            this.addedPoints = new Vector(100);
        }
        this.addedPoints.removeAllElements();
        if (this.newAddedPoints == null) {
            this.newAddedPoints = new Vector(100);
        }
        this.addedPoints.addElement(new int[]{this.getXCell(), this.getYCell()});
        while (n != 0) {
            n = 0;
            this.newAddedPoints.removeAllElements();
            for (int i = 0; i < this.addedPoints.size(); ++i) {
                int[] nArray = (int[])this.addedPoints.elementAt(i);
                for (int j = 0; j <= 3; ++j) {
                    int n3 = nArray[0] + GameManager.DIRECTION_INCREMENTS[j][0];
                    int n4 = nArray[1] + GameManager.DIRECTION_INCREMENTS[j][1];
                    if (n3 <= 0 || n3 >= this.getLevel().getWidth() || n4 <= 0 || n4 >= this.getLevel().getHeight() || this.distanceMatrice[n3][n4] <= this.distanceMatrice[nArray[0]][nArray[1]] + 1) continue;
                    this.distanceMatrice[n3][n4] = (short)(this.distanceMatrice[nArray[0]][nArray[1]] + 1);
                    n = 1;
                    this.newAddedPoints.addElement(new int[]{n3, n4});
                    ++n2;
                }
            }
            Vector vector = this.addedPoints;
            this.addedPoints = this.newAddedPoints;
            this.newAddedPoints = vector;
        }
    }

    protected void rebuildDistanceMatrice(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.getLevel().getWidth(); ++i) {
            for (int j = 0; j < this.getLevel().getHeight(); ++j) {
                int n5;
                if (this.distanceMatrice[i][j] < 0) continue;
                int n6 = Math.abs(n - i) + Math.abs(n2 - j);
                if (n6 > (n5 = Math.abs(n3 - i) + Math.abs(n4 - j))) {
                    short[] sArray = this.distanceMatrice[i];
                    int n7 = j;
                    sArray[n7] = (short)(sArray[n7] - 1);
                    continue;
                }
                if (n6 >= n5) continue;
                short[] sArray = this.distanceMatrice[i];
                int n8 = j;
                sArray[n8] = (short)(sArray[n8] + 1);
            }
        }
        System.out.println("MovableObject.rebuildDistanceMatrice");
    }

    public int getNextPointDirection(int n, int n2, int n3, int n4) {
        int[] nArray = new int[2];
        int n5 = 0;
        if (n2 < this.getYCell()) {
            nArray[n5++] = 3;
        } else if (n2 > this.getYCell()) {
            nArray[n5++] = 1;
        }
        if (n < this.getXCell()) {
            nArray[n5++] = 2;
        } else if (n > this.getXCell()) {
            nArray[n5++] = 0;
        }
        int n6 = n5 == 2 ? nArray[n3] : (n5 == 1 ? nArray[0] : 0);
        while (this.level.getObjectAt(n + GameManager.DIRECTION_INCREMENTS[n6][0], n2 + GameManager.DIRECTION_INCREMENTS[n6][1]) >= 8) {
            if (n4 == 0) {
                if (++n6 <= 3) continue;
                n6 = 0;
                continue;
            }
            if (--n6 >= 0) continue;
            n6 = 3;
        }
        return n6;
    }

    public int getDrawX() {
        return this.xPosIncreaser.getValue();
    }

    public int getDrawY() {
        return this.yPosIncreaser.getValue();
    }
}

