/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GameEngine;
import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Platform
extends GameObject {
    public int ptype = 0;
    public static final int TYPE_FIXED = 0;
    public static final int TYPE_JUMP = 1;
    public static final int TYPE_MOVE = 2;
    public static final int TYPE_ONCE = 3;
    public static final int TYPE_ONCE_DISMISSED = 4;
    public static final int IMG_FIXED = 0;
    public static final int IMG_JUMP = 1;
    public static final int IMG_JUMP_D = 2;
    public static final int IMG_JUMP_U = 3;
    public static final int IMG_MOVE = 4;
    public static final int IMG_ONCE = 5;
    public static final int IMG_ONCE_A = 6;
    public static final int IMG_ONCE_B = 7;
    public static final int ENEMY_HEIDAI = 0;
    public static final int ENEMY_ONION_HEAD = 1;
    public static final int ENEMY_TSONG = 2;
    public static Random ran = new Random();
    private long stepped = 0L;
    private int posOX = 0;
    private int vX = 0;
    private static final int HOFFSET_LONG = 125;
    private static final int HOFFSET_SHORT = 75;
    private static final int HALF_X = 40;
    private int moveLen = 125;
    public int enemy = -1;
    private static long last_enemy_time = 0L;
    public int bonus = -1;
    private static long last_bonus_time = 0L;
    public int bonusScoreIndex = 0;
    public long bonusTimeStamp = 0L;
    private static final int V_VERY_FAST = -11;
    private static final int V_FAST = -9;
    private static final int V_SLOW = -6;
    private static int[] P_TYPE_LEVELS = new int[]{50, 200, 550, 750, 1000, 1800, 2100, 2300, 2570, 2700, 2900, 3950, 4200, 6920, 9500, 12000, 13000, 14200, 16000, 10000000};
    private static int[][] P_TYPE_RAN;
    private static int prIndex;
    private static int pr;

    static {
        int[][] nArrayArray = new int[21][];
        nArrayArray[0] = new int[]{100, 100, 100, 100};
        nArrayArray[1] = new int[]{90, 100, 100, 100};
        nArrayArray[2] = new int[]{100, 100, 100, 100};
        int[] nArray = new int[4];
        nArray[1] = 100;
        nArray[2] = 100;
        nArray[3] = 100;
        nArrayArray[3] = nArray;
        nArrayArray[4] = new int[]{100, 100, 85, 100};
        nArrayArray[5] = new int[]{90, 70, 100, 100};
        int[] nArray2 = new int[4];
        nArray2[1] = 100;
        nArray2[2] = 100;
        nArray2[3] = 100;
        nArrayArray[6] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 100;
        nArray3[1] = 70;
        nArray3[3] = 100;
        nArrayArray[7] = nArray3;
        nArrayArray[8] = new int[]{93, 75, 55, 100};
        int[] nArray4 = new int[4];
        nArray4[0] = 95;
        nArray4[1] = 10;
        nArray4[2] = 5;
        nArrayArray[9] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 100;
        nArray5[1] = 50;
        nArray5[3] = 100;
        nArrayArray[10] = nArray5;
        nArrayArray[11] = new int[]{93, 85, 80, 65};
        int[] nArray6 = new int[4];
        nArray6[0] = 100;
        nArray6[1] = 50;
        nArray6[2] = 20;
        nArrayArray[12] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 95;
        nArray7[1] = 85;
        nArray7[2] = 30;
        nArrayArray[13] = nArray7;
        nArrayArray[14] = new int[]{85, 60, 40, 30};
        int[] nArray8 = new int[4];
        nArray8[0] = 95;
        nArray8[1] = 100;
        nArray8[2] = 100;
        nArrayArray[15] = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 100;
        nArray9[1] = 60;
        nArray9[2] = 40;
        nArrayArray[16] = nArray9;
        nArrayArray[17] = new int[]{93, 70, 50, 25};
        int[] nArray10 = new int[4];
        nArray10[0] = 100;
        nArray10[1] = 100;
        nArray10[2] = 80;
        nArrayArray[18] = nArray10;
        nArrayArray[19] = new int[]{95, 75, 55, 30};
        nArrayArray[20] = new int[]{95, 60, 40, 10};
        P_TYPE_RAN = nArrayArray;
        prIndex = 0;
        pr = 0;
    }

    public Platform(int index, int ptype, int posX, int posH) {
        this.type = 0;
        this.ptype = ptype;
        this.posX = posX;
        this.posH = posH;
        this.posOX = posX;
        this.vX = -6;
        this.enemy = -1;
        this.bonus = -1;
        this.bonusScoreIndex = 0;
    }

    public void setValues(int index, int ptype, int posX, int posH) {
        this.type = 0;
        this.ptype = ptype;
        this.posX = posX;
        this.posH = posH;
        this.posOX = posX;
        this.vX = -6;
        this.enemy = -1;
        this.bonus = -1;
        this.bonusScoreIndex = 0;
    }

    public static void reset() {
    }

    private int getNextPlatformType(int prevType) {
        int r = ran.nextInt(10000) % 98 + 1;
        int h = GameLogic.height / 10;
        int ret = 0;
        this.vX = -6;
        int index = 0;
        int i = P_TYPE_LEVELS.length - 1;
        while (i >= 0) {
            int hV = P_TYPE_LEVELS[i];
            if (h > hV) break;
            index = i--;
        }
        prIndex = index;
        pr = r;
        if (r > P_TYPE_RAN[index][0]) {
            ret = 1;
        } else if (r > P_TYPE_RAN[index][1]) {
            ret = 3;
        } else if (r > P_TYPE_RAN[index][2]) {
            ret = 2;
            this.vX = -6;
            this.moveLen = r % 10 >= 5 ? 125 : 75;
        } else if (r > P_TYPE_RAN[index][3]) {
            ret = 2;
            this.vX = -9;
            int n = this.moveLen = r % 10 >= 5 ? 125 : 75;
            if (GameLogic.height > 5000) {
                this.vX = -11;
            }
        } else {
            ret = 0;
        }
        return ret;
    }

    private int getNextEnemyType(int prevHeight, int prevType, int index) {
        int ret = -1;
        if (GameLogic.height < 7000) {
            return -1;
        }
        if (GameLogic.now - last_enemy_time > 0L) {
            ret = ran.nextInt(1000) % 3;
            last_enemy_time = GameLogic.now + (long)((15 + ran.nextInt(25)) * 1000);
        }
        return ret;
    }

    private int getNextBonusType(int prevHeight, int prevType, int index) {
        int ret = -1;
        if (GameLogic.height < 4000) {
            return -1;
        }
        if (GameLogic.now - last_bonus_time > 0L) {
            ret = ran.nextInt(1000) % 6;
            last_bonus_time = GameLogic.now + (long)((10 + ran.nextInt(20)) * 1000);
        }
        return ret;
    }

    public void eatBonus() {
        if (GameLogic.height > 6666) {
            GameLogic.bonusScore += 1000;
            this.bonusScoreIndex = 8;
        } else {
            GameLogic.bonusScore += 500;
            this.bonusScoreIndex = 6;
        }
        this.bonusTimeStamp = GameLogic.now;
    }

    private int getNextPlatformHeight(int prevHeight, int prevType, int enemy, int prevEnemy) {
        if (enemy != -1 || prevEnemy != -1) {
            return prevHeight + ran.nextInt(40) + 60;
        }
        int ret = 40;
        int h = GameLogic.height / 10;
        ret = h < 400 ? prevHeight + ran.nextInt(35) + 50 : (h < 700 ? prevHeight + ran.nextInt(35) + 65 : (h < 1600 ? prevHeight + ran.nextInt(40) + 80 : (h < 2000 ? prevHeight + ran.nextInt(55) + 95 : (h < 3000 ? prevHeight + ran.nextInt(50) + 115 : (h < 4000 ? prevHeight + ran.nextInt(50) + 125 : (h < 5000 ? prevHeight + ran.nextInt(45) + 150 : (h < 6000 ? prevHeight + ran.nextInt(68) + 130 : (h < 8000 ? prevHeight + ran.nextInt(30) + 170 : (h < 12000 ? prevHeight + ran.nextInt(28) + 180 : (h < 16000 ? prevHeight + ran.nextInt(30) + 190 : prevHeight + ran.nextInt(75) + 150))))))))));
        return ret;
    }

    private int getNextPlatformPosX(int prePosX, int enemy, int prevEnemy) {
        int ret = 180 + ran.nextInt(320) - 160;
        int diff = prePosX - ret;
        if (enemy != -1 || prevEnemy != -1) {
            if (diff < 95 && diff > -85) {
                ret = (ret + 180) % 360;
            }
        } else if (diff < 35 && diff > -35) {
            ret = (ret + 100) % 360;
        }
        if (ret < 40) {
            ret += 40;
        } else if (ret > 320) {
            ret -= 40;
        }
        return ret;
    }

    public void refreshNextPlatform(int index, int prevIndex) {
        Platform prevPlat = GameLogic.platforms[prevIndex];
        this.ptype = this.getNextPlatformType(prevPlat.ptype);
        this.enemy = this.getNextEnemyType(prevPlat.posH, prevPlat.ptype, prevIndex);
        this.bonus = this.getNextBonusType(prevPlat.posH, prevPlat.ptype, prevIndex);
        this.posH = this.getNextPlatformHeight(prevPlat.posH, prevPlat.ptype, this.enemy, prevPlat.enemy);
        this.posOX = this.posX = this.getNextPlatformPosX(prevPlat.posX, this.enemy, prevPlat.enemy);
        this.stepped = 0L;
        if (this.ptype != 0 && this.enemy != -1) {
            this.enemy = -1;
            last_enemy_time = GameLogic.now + 100L;
        }
        if (this.ptype != 0 || this.enemy != -1) {
            this.bonus = -1;
        }
    }

    public void draw(Graphics g, GameCanvas canvas) {
        if (this.ptype == 4) {
            long now = System.currentTimeMillis();
            if (this.stepped == 0L || now - this.stepped <= 500L) {
                if (this.stepped != 0L && now - this.stepped > 300L) {
                    Image pimg = GameObject.platImgs[7];
                    g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height) - 13, 20);
                } else {
                    Image pimg = GameObject.platImgs[6];
                    g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height) - 11, 20);
                }
            }
        } else if (this.ptype == 3) {
            Image pimg = GameObject.platImgs[5];
            g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height), 20);
        } else if (this.ptype == 1) {
            long now = System.currentTimeMillis();
            if (this.stepped != 0L && now - this.stepped > 600L) {
                Image pimg = GameObject.platImgs[1];
                g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height) - 4, 20);
            } else if (this.stepped != 0L && now - this.stepped > 300L) {
                Image pimg = GameObject.platImgs[3];
                g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height) - 14, 20);
            } else if (this.stepped != 0L && now - this.stepped > 0L) {
                Image pimg = GameObject.platImgs[2];
                g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height) - 16, 20);
            } else {
                Image pimg = GameObject.platImgs[1];
                g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height) - 4, 20);
            }
        } else if (this.ptype == 2) {
            Image pimg = GameObject.platImgs[4];
            g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height), 20);
        } else if (this.ptype == 0) {
            Image pimg = GameObject.platImgs[0];
            g.drawImage(pimg, this.posX - 40, 640 - (this.posH - GameLogic.height), 20);
        }
        if (this.enemy == 0) {
            Image pimg = GameObject.enemyImgs[0];
            g.drawImage(pimg, this.posX - pimg.getWidth() / 2, 640 - (this.posH - GameLogic.height) - pimg.getHeight(), 20);
        } else if (this.enemy == 1) {
            Image pimg = GameObject.enemyImgs[1];
            g.drawImage(pimg, this.posX - pimg.getWidth() / 2, 640 - (this.posH - GameLogic.height) - pimg.getHeight(), 20);
        } else if (this.enemy == 2) {
            Image pimg = GameObject.enemyImgs[2];
            g.drawImage(pimg, this.posX - pimg.getWidth() / 2, 640 - (this.posH - GameLogic.height) - pimg.getHeight(), 20);
        }
        if (this.bonus != -1) {
            if (this.bonusScoreIndex == 0) {
                Image pimg = GameObject.bonusImgs[this.bonus];
                g.drawImage(pimg, this.posX - pimg.getWidth() / 2, 640 - (this.posH - GameLogic.height) - pimg.getHeight(), 20);
            } else {
                int index = this.bonusScoreIndex;
                if (GameLogic.now - this.bonusTimeStamp > 1000L) {
                    return;
                }
                if (GameLogic.now - this.bonusTimeStamp > 500L) {
                    ++index;
                }
                Image pimg = GameObject.bonusImgs[index];
                g.drawImage(pimg, this.posX - pimg.getWidth() / 2, 640 - (this.posH - GameLogic.height) - pimg.getHeight(), 20);
            }
        }
    }

    public void drawDebug(Graphics g, GameCanvas canvas) {
        g.drawString("fps:" + String.valueOf(GameEngine.currentFps), 10, 100, 0);
        g.drawString("h:" + String.valueOf(GameLogic.height / 10), 10, 120, 0);
        g.drawString("index:" + String.valueOf(prIndex), 10, 140, 0);
        g.drawString("r:" + String.valueOf(pr), 10, 160, 0);
    }

    public void step() {
        if (this.ptype == 2) {
            if (this.vX > 0) {
                if (this.posX - this.posOX > 125 || this.posX + 40 > 360) {
                    this.vX *= -1;
                }
            } else if (this.posOX - this.posX > 125 || this.posX - 40 < 0) {
                this.vX *= -1;
            }
            this.posX += this.vX;
        }
    }

    public void stepOn() {
        this.stepped = System.currentTimeMillis();
        if (this.ptype == 3) {
            this.ptype = 4;
        }
    }
}

