/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Actor;
import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import cc.jmap.games.SoundPlayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Flying
extends GameObject {
    public static int fidcount = 0;
    public static int fno = 0;
    private static int[] trackIn = new int[4];
    public static int scoreForOneFoodBase = 100;
    public static int scoreForOneFoodMax = 1600;
    public static int scoreForOneFoodNow = 10;
    public static int lifeForOneFood = 40;
    public static int lifeForOnePoison = -45;
    public static int foodCount = 0;
    public static final int TYPE_A = 0;
    public static final int TYPE_B = 1;
    public static final int TYPE_LEG = 2;
    public static final int TYPE_POISON = 3;
    private static long lastFoodTime = 0L;
    private static long lastPrepareTime = 0L;
    public static final int FLYING_NO = 26;
    private boolean enabled = false;
    private boolean can_reset = false;
    private int score = 0;
    private int ftype = 0;
    private double vY = 0.0;
    private long hitTime = 0L;
    public static int hitCount = 0;
    public static int flyingSpeed = 0;

    public Flying() {
        ++fidcount;
        this.type = 2;
        this.ftype = 0;
        this.reset();
    }

    public static void classReset() {
        lastFoodTime = GameLogic.startTime;
        lastPrepareTime = GameLogic.startTime;
        fidcount = 0;
        fno = 0;
        Flying.trackIn[0] = 0;
        Flying.trackIn[1] = 0;
        Flying.trackIn[2] = 0;
        Flying.trackIn[3] = 0;
        scoreForOneFoodBase = 100;
        scoreForOneFoodMax = 1600;
        scoreForOneFoodNow = scoreForOneFoodBase;
        lifeForOneFood = 40;
        lifeForOnePoison = -45;
        foodCount = 0;
        int i = 0;
        while (i < GameLogic.flyings.size()) {
            ((Flying)GameLogic.flyings.elementAt(i)).reset();
            ((Flying)GameLogic.flyings.elementAt((int)i)).can_reset = true;
            ++i;
        }
        Flying.prepareMore();
    }

    public void reset() {
        this.enabled = false;
        this.posX = 0;
        this.posY = -60;
        this.score = 0;
        this.ftype = 0;
        this.vY = this.getFlyingSpeed(this.ftype);
        flyingSpeed = (int)(this.vY * 100.0);
        this.hitTime = 0L;
        this.can_reset = false;
        boolean flag = this.ramdomInit();
        if (!flag) {
            this.enabled = false;
            this.can_reset = true;
        }
    }

    public void setScore(int score) {
        this.score = score;
    }

    private int getFlyingType() {
        int ret = -1;
        int r = GameLogic.ran.nextInt(100);
        if (GameLogic.now - lastFoodTime < 250L) {
            return -1;
        }
        int diff = (int)((GameLogic.now - GameLogic.startTime) / 1000L);
        if (diff < 10) {
            return 0;
        }
        if (diff < 22) {
            if (r < 10) {
                return 3;
            }
            return 1;
        }
        if (diff < 35) {
            if (r < 15) {
                return 3;
            }
            return 2;
        }
        if (diff < 60) {
            scoreForOneFoodBase = 200;
            scoreForOneFoodMax = 3200;
            ret = r < 70 ? r % 3 : 3;
        } else if (diff < 80) {
            ret = r < 65 ? r % 3 : 3;
        } else if (diff < 90) {
            ret = r < 60 ? r % 3 : 3;
        } else if (diff < 105) {
            ret = r < 55 ? r % 3 : 3;
        } else if (diff < 120) {
            scoreForOneFoodBase = 400;
            scoreForOneFoodMax = 6400;
            ret = r < 50 ? r % 3 : 3;
        } else if (diff < 135) {
            ret = r < 45 ? r % 3 : 3;
        } else if (diff < 160) {
            scoreForOneFoodBase = 800;
            scoreForOneFoodMax = 6400;
            ret = r < 40 ? r % 3 : 3;
        } else {
            ret = r < 35 ? r % 3 : 3;
        }
        return ret;
    }

    private double getFlyingSpeed(int ftype) {
        double ret = 5.0;
        int r = GameLogic.ran.nextInt(10000);
        int diff = (int)((GameLogic.now - GameLogic.startTime) / 1000L);
        if (ftype == 3) {
            return 9.0;
        }
        ret = diff < 20 ? 2.0 + (double)(r % 20) / 10.0 : (diff < 40 ? 2.0 + (double)(r % 50) / 10.0 : (diff < 60 ? 3.0 + (double)(r % 70) / 10.0 : (diff < 80 ? 4.0 + (double)(r % 90) / 10.0 : (diff < 100 ? 5.0 + (double)(r % 100) / 10.0 : (diff < 130 ? 6.0 + (double)(r % 110) / 10.0 : (diff < 160 ? 7.0 + (double)(r % 120) / 10.0 : (diff < 190 ? 8.0 + (double)(r % 130) / 10.0 : 9.0 + (double)(r % 140) / 10.0)))))));
        ret = ((int)(ret / 4.0) + 1) * 4;
        return ret;
    }

    public boolean ramdomInit() {
        if (Flying.getFreeTrack() == 0) {
            return false;
        }
        int ftmp = this.getFlyingType();
        if (ftmp == -1) {
            return false;
        }
        this.ftype = ftmp;
        int r = GameLogic.ran.nextInt(100) % 4;
        int count = 0;
        while (trackIn[r] == 1) {
            if (count++ > 40) {
                return false;
            }
            r = GameLogic.ran.nextInt(100) % 4;
        }
        Flying.trackIn[r] = 1;
        this.posX = 75 + r * 70;
        this.posY = -60;
        this.vY = this.getFlyingSpeed(this.ftype);
        this.enabled = true;
        ++fno;
        return true;
    }

    private boolean isIn(int x1, int y1, int x2, int y2, int r) {
        return r * r >= (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public boolean collisionCheck(Actor actor) {
        int ax = actor.getCenterX();
        int ay = actor.getCenterY();
        int ar = actor.getR();
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (this.ftype == 0) {
            x1 = 2;
            y1 = 11;
            x2 = 56;
            y2 = 56;
        } else if (this.ftype == 1) {
            x1 = 1;
            y1 = 12;
            x2 = 57;
            y2 = 58;
        } else if (this.ftype == 2) {
            x1 = 5;
            y1 = 0;
            x2 = 60;
            y2 = 58;
        }
        if (this.ftype != 3 && (this.isIn(x1 += this.posX, y1 += this.posY, ax, ay, ar) || this.isIn(x2 += this.posX, y2 += this.posY, ax, ay, ar) || this.isIn(x1, y2, ax, ay, ar) || this.isIn(x2, y1, ax, ay, ar))) {
            if (hitCount == 0) {
                SoundPlayer.playFile(4);
            }
            if (hitCount == 1) {
                SoundPlayer.playFile(5);
            }
            if (hitCount == 2) {
                SoundPlayer.playFile(6);
            }
            if (hitCount == 3) {
                SoundPlayer.playFile(7);
            }
            ++hitCount;
            this.enabled = false;
            this.can_reset = false;
            --fno;
            this.score = scoreForOneFoodNow;
            GameLogic.addLife(lifeForOneFood);
            GameLogic.addScore(scoreForOneFoodNow);
            if ((scoreForOneFoodNow *= 2) > scoreForOneFoodMax) {
                scoreForOneFoodNow = scoreForOneFoodMax;
            }
            this.hitTime = GameLogic.now;
            actor.setHit();
            return true;
        }
        if (this.ftype == 3 && 2916 > ((x1 = this.posX + 27) - ax) * (x1 - ax) + ((y1 = this.posY + 27) - ay) * (y1 - ay)) {
            hitCount = 0;
            foodCount = 0;
            SoundPlayer.playFile(8);
            this.enabled = false;
            this.can_reset = false;
            --fno;
            this.score = -200;
            GameLogic.addLife(-130.0);
            GameLogic.addScore(-200);
            scoreForOneFoodNow = scoreForOneFoodBase;
            this.hitTime = GameLogic.now;
            actor.setHit();
            return true;
        }
        return false;
    }

    private static int getFreeTrack() {
        int count = 0;
        int i = 0;
        while (i < 4) {
            if (trackIn[i] == 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int getMaxRowNo() {
        int ret = 1;
        int diff = (int)(GameLogic.now - GameLogic.startTime) / 1000;
        ret = diff < 20 ? 1 : (diff < 40 ? 2 : (diff < 70 ? 3 : (diff < 110 ? 4 : 4)));
        return ret;
    }

    private static int getPeriod() {
        int ret = 2000;
        int unit = 400;
        int r = GameLogic.ran.nextInt(1000);
        int diff = (int)(GameLogic.now - GameLogic.startTime) / 1000;
        ret = diff < 10 ? (4 + r % 4) * unit : (diff < 20 ? (4 + r % 4) * unit : (diff < 40 ? (4 + r % 3) * unit : (diff < 60 ? (3 + r % 3) * unit : (diff < 90 ? (3 + r % 2) * unit : (diff < 110 ? (3 + r % 2) * unit : (diff < 130 ? (2 + r % 2) * unit : (diff < 150 ? 2 * unit : (diff < 120 ? unit : unit))))))));
        return ret;
    }

    public static void prepareMore() {
        int free;
        if (GameLogic.now - lastPrepareTime < (long)Flying.getPeriod()) {
            return;
        }
        int count = 0;
        int r = GameLogic.ran.nextInt(1000) % Flying.getMaxRowNo();
        int n = r = r > (free = Flying.getFreeTrack()) ? free : r;
        if (fno < 17 && free > 0) {
            int i = 0;
            while (i < GameLogic.flyings.size()) {
                Flying f = (Flying)GameLogic.flyings.elementAt(i);
                if (!f.isEnabled() && f.can_reset) {
                    f.reset();
                    if (++count > r) break;
                }
                ++i;
            }
            lastPrepareTime = GameLogic.now;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void step() {
        if (this.enabled) {
            if (this.posY > 500) {
                this.posY += 8;
            } else if (this.posY < 0) {
                this.posY += 2;
                Flying.trackIn[(this.posX - 75) / 70] = 0;
            } else {
                this.posY = (int)((double)this.posY + this.vY);
            }
            if (this.posY > 640) {
                this.enabled = false;
                --fno;
            }
        }
    }

    public void render(Graphics g, GameCanvas canvas) {
        if (GameLogic.state != 1 && GameLogic.state != 3) {
            return;
        }
        long diff = GameLogic.now - this.hitTime;
        Image aImg = null;
        int fImgIdx = 4;
        if (this.ftype == 3) {
            fImgIdx = 7;
        }
        if (this.isEnabled()) {
            aImg = GameObject.flyImgs[this.ftype];
            g.drawImage(aImg, this.posX, this.posY, 20);
        }
        if (diff < 400L) {
            aImg = GameObject.flyImgs[fImgIdx];
            g.drawImage(aImg, this.posX, this.posY, 20);
        } else if (diff < 700L) {
            aImg = GameObject.flyImgs[fImgIdx + 1];
            g.drawImage(aImg, this.posX, this.posY, 20);
        } else if (diff < 1000L) {
            aImg = GameObject.flyImgs[fImgIdx + 2];
            g.drawImage(aImg, this.posX, this.posY, 20);
        } else {
            this.can_reset = true;
            this.score = 0;
        }
        if (this.score != 0) {
            GameLogic.drawFoodScore(g, canvas, this.posX + 45, this.posY + 10, this.score);
        }
    }
}

