/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.TastyDreamMidlet;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class SoundPlayer
extends Thread {
    public static final int SOUND_START = 0;
    public static final int SOUND_BGM = 1;
    public static final int SOUND_GAMEOVER = 2;
    public static final int SOUND_JUMP = 3;
    public static final int SOUND_EAT_1 = 4;
    public static final int SOUND_EAT_2 = 5;
    public static final int SOUND_EAT_3 = 6;
    public static final int SOUND_EAT_4 = 7;
    public static final int SOUND_POISON = 8;
    public static final int SOUND_ALERT = 9;
    private static Player startPlayer;
    private static Player bgmPlayer;
    private static Player gameOverPlayer;
    private static Player jumpPlayer;
    private static Player eatPlayer1;
    private static Player eatPlayer2;
    private static Player eatPlayer3;
    private static Player eatPlayer4;
    private static Player poisonPlayer;
    private static Player alertPlayer;
    public static boolean musicFlag;
    public static boolean soundFlag;
    public static SoundPlayer instance;
    private boolean running = true;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private Command[] commands = new Command[10];
    private static final String RMS_NAME = "sound";
    private static final int RECORD_ID = 1;
    private static byte[] data;

    static {
        musicFlag = true;
        soundFlag = true;
        instance = null;
        data = new byte[2];
    }

    public SoundPlayer() {
        instance = this;
        SoundPlayer.restoreData();
        int i = 0;
        while (i < 10) {
            this.commands[i] = new Command();
            ++i;
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.producerIndex > this.consumerIndex) {
                    Command cmd = this.commands[this.consumerIndex % 10];
                    if (cmd.type >= 10) {
                        this.playMidiInternal(cmd.type - 10);
                    } else {
                        this.playFileInternal(cmd.type);
                    }
                    ++this.consumerIndex;
                    continue;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public void closeResource() {
        this.running = false;
    }

    private synchronized void addCommand(int type, boolean playOrStop) {
        Command cmd = this.commands[this.producerIndex % 10];
        cmd.type = type;
        cmd.play = playOrStop;
        ++this.producerIndex;
    }

    public static void toggleMusicState() {
        if (musicFlag) {
            musicFlag = false;
            SoundPlayer.playStop(1);
        } else {
            musicFlag = true;
            SoundPlayer.playFile(1);
        }
        SoundPlayer.saveData();
    }

    public static void toggleSoundState() {
        soundFlag = !soundFlag;
        SoundPlayer.saveData();
    }

    public static void resume() {
        if (instance != null && musicFlag) {
            SoundPlayer.playFile(1);
        }
    }

    public static void pause() {
        if (instance != null) {
            SoundPlayer.playStop(1);
            SoundPlayer.playStop(2);
        }
    }

    public static void soundInit() {
        InputStream in2;
        if (bgmPlayer == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_bgm.mp3");
                bgmPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                bgmPlayer.setLoopCount(-1);
                bgmPlayer.realize();
                bgmPlayer.prefetch();
            }
            catch (Exception in2) {
                // empty catch block
            }
        }
        if (gameOverPlayer == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_gameover.mp3");
                gameOverPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                gameOverPlayer.realize();
                gameOverPlayer.prefetch();
            }
            catch (Exception in3) {
                // empty catch block
            }
        }
        if (jumpPlayer == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_jump.mp3");
                jumpPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                jumpPlayer.realize();
                jumpPlayer.prefetch();
            }
            catch (Exception in4) {
                // empty catch block
            }
        }
        if (eatPlayer1 == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_eat_1.wav");
                eatPlayer1 = Manager.createPlayer((InputStream)in2, (String)"audio/wav");
                eatPlayer1.realize();
                eatPlayer1.prefetch();
            }
            catch (Exception in5) {
                // empty catch block
            }
        }
        if (eatPlayer2 == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_eat_2.wav");
                eatPlayer2 = Manager.createPlayer((InputStream)in2, (String)"audio/wav");
                eatPlayer2.realize();
                eatPlayer2.prefetch();
            }
            catch (Exception in6) {
                // empty catch block
            }
        }
        if (eatPlayer3 == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_eat_3.wav");
                eatPlayer3 = Manager.createPlayer((InputStream)in2, (String)"audio/wav");
                eatPlayer3.realize();
                eatPlayer3.prefetch();
            }
            catch (Exception in7) {
                // empty catch block
            }
        }
        if (eatPlayer4 == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_eat_4.wav");
                eatPlayer4 = Manager.createPlayer((InputStream)in2, (String)"audio/wav");
                eatPlayer4.realize();
                eatPlayer4.prefetch();
            }
            catch (Exception in8) {
                // empty catch block
            }
        }
        if (poisonPlayer == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_poison.wav");
                poisonPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/wav");
                poisonPlayer.realize();
                poisonPlayer.prefetch();
            }
            catch (Exception in9) {
                // empty catch block
            }
        }
        if (alertPlayer == null) {
            try {
                in2 = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/onion_dream_alert.mp3");
                alertPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                alertPlayer.realize();
                alertPlayer.prefetch();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void soundFinalize() {
        try {
            if (startPlayer != null) {
                startPlayer.close();
            } else if (bgmPlayer != null) {
                bgmPlayer.close();
            } else if (gameOverPlayer != null) {
                gameOverPlayer.close();
            } else if (jumpPlayer != null) {
                jumpPlayer.close();
            } else if (eatPlayer1 != null) {
                eatPlayer1.close();
            } else if (eatPlayer2 != null) {
                eatPlayer2.close();
            } else if (eatPlayer3 != null) {
                eatPlayer3.close();
            } else if (eatPlayer4 != null) {
                eatPlayer4.close();
            } else if (poisonPlayer != null) {
                poisonPlayer.close();
            } else if (alertPlayer != null) {
                alertPlayer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void playStop(int sound) {
        try {
            SoundPlayer.soundInit();
            if (sound == 0 && startPlayer != null) {
                startPlayer.stop();
            }
            if (sound == 1 && bgmPlayer != null) {
                bgmPlayer.stop();
            }
            if (sound == 2 && gameOverPlayer != null) {
                gameOverPlayer.stop();
            }
            if (sound == 3 && jumpPlayer != null) {
                jumpPlayer.stop();
            }
            if (sound == 4 && eatPlayer1 != null) {
                eatPlayer1.stop();
            }
            if (sound == 5 && eatPlayer2 != null) {
                eatPlayer2.stop();
            }
            if (sound == 6 && eatPlayer3 != null) {
                eatPlayer3.stop();
            }
            if (sound == 7 && eatPlayer4 != null) {
                eatPlayer4.stop();
            }
            if (sound == 8 && poisonPlayer != null) {
                poisonPlayer.stop();
            }
            if (sound == 9 && alertPlayer != null) {
                alertPlayer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void playFileInternal(int sound) {
        try {
            SoundPlayer.soundInit();
            if (sound == 1 && bgmPlayer != null && musicFlag) {
                bgmPlayer.setMediaTime(0L);
                bgmPlayer.start();
            }
            if (soundFlag) {
                if (sound == 0 && startPlayer != null) {
                    startPlayer.start();
                } else if (sound == 2 && gameOverPlayer != null) {
                    gameOverPlayer.start();
                } else if (sound == 3 && jumpPlayer != null) {
                    jumpPlayer.start();
                } else if (sound == 4 && eatPlayer1 != null) {
                    eatPlayer1.start();
                } else if (sound == 5 && eatPlayer2 != null) {
                    eatPlayer2.start();
                } else if (sound == 6 && eatPlayer3 != null) {
                    eatPlayer3.start();
                } else if (sound == 7 && eatPlayer4 != null) {
                    eatPlayer4.start();
                } else if (sound == 8 && poisonPlayer != null) {
                    poisonPlayer.start();
                } else if (sound == 9 && alertPlayer != null) {
                    alertPlayer.start();
                }
            }
            if (sound == 2 && bgmPlayer != null) {
                bgmPlayer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void playFile(int file) {
        try {
            instance.addCommand(file, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playMidiInternal(int note) {
        try {
            int base;
            int noteVal = base = 72;
            if (note == 0) {
                noteVal = base;
            } else if (note == 1) {
                noteVal = base + 2;
            } else if (note == 2) {
                noteVal = base + 4;
            } else if (note == 3) {
                noteVal = base + 5;
            } else if (note == 4) {
                noteVal = base + 7;
            } else if (note == 5) {
                noteVal = base + 9;
            } else if (note == 6) {
                noteVal = base + 11;
            } else if (note == 7) {
                noteVal = base + 12;
            }
            Manager.playTone((int)noteVal, (int)200, (int)100);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public static void playMidi(int note) {
        try {
            instance.addCommand(note + 10, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playStart() {
        if (startPlayer == null && musicFlag) {
            try {
                InputStream in = TastyDreamMidlet.instance.getClass().getResourceAsStream("/sounds/game_start.mp3");
                startPlayer = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
                startPlayer.realize();
                startPlayer.prefetch();
                startPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void saveData() {
        System.out.println("saveData");
        SoundPlayer.data[0] = (byte)(musicFlag ? 1 : 0);
        SoundPlayer.data[1] = (byte)(soundFlag ? 1 : 0);
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (rs.getNextRecordID() == 1) {
                int recordID = rs.addRecord(data, 0, data.length);
                System.out.println("saveData #1");
            } else {
                rs.setRecord(1, data, 0, data.length);
                System.out.println("saveData #1B");
            }
            rs.closeRecordStore();
            System.out.println("saveData #2");
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        System.out.println("saveData #N");
    }

    public static void restoreData() {
        System.out.println("restoreData");
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            byte[] d = rs.getRecord(1);
            rs.closeRecordStore();
            SoundPlayer.data[0] = d[0];
            SoundPlayer.data[1] = d[1];
            System.out.println("restoreData() data[0]:" + data[0] + "/data[1]:" + data[1]);
            musicFlag = data[0] == 1;
            soundFlag = data[1] == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            SoundPlayer.saveData();
        }
        System.out.println("restoreData #N");
    }

    class Command {
        public int type = 0;
        public boolean play = true;
    }
}

