/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class DChocByteArray
implements IByteArray {
    private boolean readMode;
    private int size;
    private int offset;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    private byte[] data;
    private ByteArrayOutputStream byteArrayOut;

    private DChocByteArray() {
    }

    public static DChocByteArray createByteArrayForReading(byte[] byArray, int n, int n2) {
        DChocByteArray dChocByteArray = new DChocByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        dChocByteArray.dataIn = new DataInputStream(byteArrayInputStream);
        dChocByteArray.data = byArray;
        dChocByteArray.size = n2;
        dChocByteArray.offset = n;
        dChocByteArray.readMode = true;
        return dChocByteArray;
    }

    public static DChocByteArray createByteArrayForWriting() {
        DChocByteArray dChocByteArray = new DChocByteArray();
        dChocByteArray.byteArrayOut = new ByteArrayOutputStream();
        dChocByteArray.dataOut = new DataOutputStream(dChocByteArray.byteArrayOut);
        dChocByteArray.readMode = false;
        return dChocByteArray;
    }

    public int getSize() {
        if (this.readMode) {
            return this.size;
        }
        return this.byteArrayOut.size();
    }

    public boolean readBoolean() throws EOFException {
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public byte readByte() throws EOFException {
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public int readUnsignedByte() throws EOFException {
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public short readShort() throws EOFException {
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public int readUnsignedShort() throws EOFException {
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public int readInt() throws EOFException {
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String readUTF() throws EOFException {
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void skip(int n) {
        try {
            this.dataIn.skipBytes(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeBoolean(boolean bl) {
        if (!this.readMode) {
            try {
                this.dataOut.writeBoolean(bl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeByte(int n) {
        if (!this.readMode) {
            try {
                this.dataOut.writeByte(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeShort(int n) {
        if (!this.readMode) {
            try {
                this.dataOut.writeShort(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeInt(int n) {
        if (!this.readMode) {
            try {
                this.dataOut.writeInt(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeUTF(String string) {
        if (!this.readMode) {
            try {
                this.dataOut.writeUTF(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte[] getBytes() {
        if (this.readMode) {
            if (this.offset != 0 || this.size != this.data.length) {
                byte[] byArray = new byte[this.size];
                System.arraycopy(this.data, this.offset, byArray, 0, this.size);
                return byArray;
            }
            return this.data;
        }
        return this.byteArrayOut.toByteArray();
    }
}

