/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageFont {
    public static final int BORDER_DISABLED = -1;
    private Image mFontImage;
    private Font mSystemFont;
    private int mSystemFontColor;
    private int mSystemFontBorderColor;
    private boolean mEnableSystemBorders;
    private int mCharacterSpacing;
    private int mFontAscent;
    private int mFontDescent;
    private byte[] mCharacterXs;
    private short[] mCharacterYs;
    private byte[] mCharacterWidths;
    private byte[] mCharacterHeights;
    private byte[] mCharacterAscents;
    private static final int CHARACTER_NOT_FOUND = -1;
    private static final int SYSTEM_FONT_BORDER_WIDTH = 1;
    private int[] mHashTableEntries;

    public ImageFont(Image image, DataInputStream dataInputStream, Font font, int n, int n2) throws IOException {
        this.mSystemFont = font;
        this.mSystemFontColor = n;
        this.mSystemFontBorderColor = n2;
        this.mEnableSystemBorders = n2 != -1;
    }

    private int getCharIndex(char c) {
        int n = this.hashTableGet(c);
        if (n == -1) {
            n = this.hashTableGet(' ');
        }
        return n;
    }

    public final int stringWidth(String string) {
        return this.mSystemFont.stringWidth(string) + (this.mEnableSystemBorders ? 2 : 0);
    }

    public int charWidth(char c) {
        return this.mSystemFont.charWidth(c);
    }

    public int getEmptyStringWidth() {
        return this.mEnableSystemBorders ? 2 : 0;
    }

    public final int getHeight() {
        return this.mSystemFont.getHeight() + (this.mEnableSystemBorders ? 2 : 0);
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        graphics.setFont(this.mSystemFont);
        int n4 = graphics.getColor();
        if (this.mEnableSystemBorders) {
            if ((n3 & 4) != 0) {
                ++n;
            } else if ((n3 & 8) != 0) {
                --n;
            }
            if ((n3 & 0x10) != 0) {
                ++n2;
            } else if ((n3 & 0x20) != 0) {
                --n2;
            }
            graphics.setColor(this.mSystemFontBorderColor);
            graphics.drawString(string, n, n2 - 1, n3);
            graphics.drawString(string, n - 1, n2, n3);
            graphics.drawString(string, n + 1, n2, n3);
            graphics.drawString(string, n, n2 + 1, n3);
        }
        graphics.setColor(this.mSystemFontColor);
        graphics.drawString(string, n, n2, n3);
        graphics.setColor(n4);
    }

    public void drawChar(Graphics graphics, char c, int n, int n2, int n3) {
        graphics.setFont(this.mSystemFont);
        int n4 = graphics.getColor();
        if (this.mEnableSystemBorders) {
            if ((n3 & 4) != 0) {
                ++n;
            } else if ((n3 & 8) != 0) {
                --n;
            }
            if ((n3 & 0x10) != 0) {
                ++n2;
            } else if ((n3 & 0x20) != 0) {
                --n2;
            }
            graphics.setColor(this.mSystemFontBorderColor);
            graphics.drawChar(c, n, n2 - 1, n3);
            graphics.drawChar(c, n - 1, n2, n3);
            graphics.drawChar(c, n + 1, n2, n3);
            graphics.drawChar(c, n, n2 + 1, n3);
        }
        graphics.setColor(this.mSystemFontColor);
        graphics.drawChar(c, n, n2, n3);
        graphics.setColor(n4);
    }

    private void hashTableCreate(int n) {
        this.mHashTableEntries = new int[n];
    }

    private void hashTablePut(char c, short s) {
        int n = this.hashTableHashCode(c);
        for (int i = 0; i < this.mHashTableEntries.length; ++i) {
            int n2 = this.mHashTableEntries[n & this.mHashTableEntries.length - 1];
            if (n2 == 0) {
                this.mHashTableEntries[n & this.mHashTableEntries.length - 1] = c << 16 | s & 0xFFFF;
                break;
            }
            ++n;
        }
    }

    private int hashTableGet(char c) {
        int n;
        int n2 = this.hashTableHashCode(c);
        for (int i = 0; i < this.mHashTableEntries.length && (n = this.mHashTableEntries[n2 & this.mHashTableEntries.length - 1]) != 0; ++i) {
            if (n >>> 16 == c) {
                return n & 0xFFFF;
            }
            ++n2;
        }
        return -1;
    }

    private int hashTableHashCode(char c) {
        return (c + 4660) * (c + 17185);
    }

    public int getBaselinePosition() {
        return this.mSystemFont.getBaselinePosition();
    }

    public int getSystemFontColor() {
        return this.mSystemFontColor;
    }
}

