/*
 * Decompiled with CFR 0.152.
 */
public class MathUtils {
    private static int[] smSinTable;
    public static final int SIN_ACCURACY = 15;
    public static final int ANGLE_ACCURACY = 8;
    private static int randSeed;

    private static void precalcSinTable() {
        int n;
        smSinTable = new int[256];
        int n2 = 0;
        int n3 = 32768;
        for (n = 0; n < 64; ++n) {
            MathUtils.smSinTable[n] = n2;
            n2 += (n3 -= n2 * 804 >> 15) * 804 >> 15;
        }
        MathUtils.smSinTable[n++] = 32768;
        while (n <= 128) {
            MathUtils.smSinTable[n] = smSinTable[64 - (n - 64)];
            ++n;
        }
        while (n < 256) {
            MathUtils.smSinTable[n] = -smSinTable[n - 128];
            ++n;
        }
    }

    public static final int sin(int n) {
        if (smSinTable == null) {
            MathUtils.precalcSinTable();
        }
        int n2 = n & 0xFF;
        return smSinTable[(n >>= 8) + 1 & 0xFF] * n2 + smSinTable[n & 0xFF] * (256 - n2) >> 8;
    }

    public static final int cos(int n) {
        return MathUtils.sin(n + 16384);
    }

    public static void setSeed(int n) {
        randSeed = n;
    }

    public static final int random() {
        int n = randSeed;
        n *= 1103515245;
        randSeed = n += 12345;
        return n;
    }

    public static final int random(int n) {
        return (MathUtils.random() >>> 15) * n >>> 17;
    }

    public static final boolean randomBoolean() {
        return MathUtils.random() > 0;
    }
}

