/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class World {
    static final boolean DEBUG_AREAS = false;
    public static int smWorldAnchorPointX;
    public static int smWorldAnchorPointY;
    public static int smScrollOffsetX;
    public static int smScrollOffsetY;
    public static Camera mCamera;
    public static IngameBg mBackground;
    public static PhysicsFP smPhysics;
    public static final int PLAYER_1 = 0;
    public static final int PLAYER_CPU = 1;
    public static final int PLAYER_TOURNAMENT_COUNT = 2;
    public static final int PLAYER_QUICKGAME_COUNT = 1;
    public static Fisherman[] smFishermans;
    public static boolean smGameIsPaused;
    public static int smStartingCameraX;
    public static int smStartingCameraY;
    public static int smPlayersCount;
    private Weather mWeather;
    private int mRainStartX;
    private int mRainStartY;
    private int mRainWidth;
    private Bubbles mBubbles;
    public static final int FISH_BUBBLE_RATE = 30;
    public static int smProportionalCameraOffsetX;
    public static int smProportionalCameraOffsetY;
    private int mFishesCount;
    public static Fish[] mFishesOfStage;
    public static Random mRandom;
    public static int minWorldFishCoorX;
    public static int maxWorldFishCoorX;
    public static int minWorldFishCoorY;
    public static int maxWorldFishCoorY;
    private int[] hookWorldX;
    private int[] hookWorldY;
    private boolean[] mActionButtonIsPressed;
    private boolean[] hookIsEmpty;
    private boolean[] lineIsBroken;
    private boolean[] hookIsUnderWater;
    private int[] rodTopX;
    private int[] rodTopY;
    private static int FIXED_POINT;

    public World() {
        Hud.smLastLevel = -1;
        mRandom = new Random();
        mRandom.setSeed(System.currentTimeMillis());
    }

    public int getLoadingCount() {
        return 8;
    }

    public void load(int n) {
        if (n == 0) {
            smPlayersCount = GameEngine.smPlayMode == 1 ? 1 : 2;
            smFishermans = new Fisherman[smPlayersCount];
            World.smFishermans[0] = new Fisherman(0);
            if (GameEngine.smPlayMode == 0) {
                World.smFishermans[1] = new Fisherman(1);
            }
        } else if (n == 1) {
            smFishermans[0].boatLoad();
        } else if (n == 2) {
            if (GameEngine.smPlayMode == 0) {
                smFishermans[1].boatLoad();
            }
        } else if (n == 3) {
            mCamera = new Camera();
        } else if (n == 4) {
            smPhysics = new PhysicsFP();
        } else if (n == 5) {
            Hud.load();
            World.worldAnchorPointReset();
        } else if (n == 6) {
            this.setCurrentLevel();
            this.loadLevel(0);
        }
    }

    public int getFishesLoadingCount() {
        this.setCurrentLevel();
        return Hud.smLastLevel != Hud.smCurrentLevel ? 1 : 0;
    }

    public void loadLevel(int n) {
        if (n == 0) {
            if (mBackground != null) {
                IngameBg.freeResources();
                mBackground = null;
            }
            this.fishesOfStageFreeResources();
            System.gc();
            mBackground = new IngameBg();
            mBackground.load();
            this.fishesOfStageLoad();
        }
    }

    public void setCurrentLevel() {
        if (GameEngine.smPlayMode == 0) {
            Hud.smCurrentLevel = 0;
            for (int i = 0; i < Game.smTournamentToPlay; ++i) {
                Hud.smCurrentLevel += Game.ROUND_TOTAL[i];
            }
            Hud.smCurrentLevel += Game.smRoundToPlay;
        } else {
            Hud.smCurrentLevel = Tuner.smLevels.length - 1;
        }
    }

    public void init() {
        int n;
        this.setCurrentLevel();
        smPlayersCount = GameEngine.smPlayMode == 1 ? 1 : 2;
        smPhysics.init();
        Trigonometry.init();
        World.worldAnchorPointReset();
        smFishermans[0].boatAndRodInit(smWorldAnchorPointX, smWorldAnchorPointY, GameEngine.smBaitCurrent, GameEngine.smLineStrengthCurrent, GameEngine.smLineLengthCurrent);
        int n2 = Game.smTournamentToPlay * 2 + 1;
        for (n = 1; n < smPlayersCount; ++n) {
            smFishermans[n].boatAndRodInit(smWorldAnchorPointX + n * (Toolkit.getScreenWidth() / 2) + -260, smWorldAnchorPointY, n2, n2, n2);
        }
        this.refreshWordPos();
        this.fishesOfStageInit();
        Hud.init();
        for (n = 0; n < smPlayersCount; ++n) {
            smFishermans[n].hookInit();
            smFishermans[n].ropeInit();
            World.smFishermans[n].mFishedLegendaryFish = false;
        }
        smStartingCameraX = FP.toInt(World.smPhysics.pX[World.smFishermans[0].mRopeParticle[0]]) - smWorldAnchorPointX - Toolkit.getScreenWidth() / 2;
        smStartingCameraY = FP.toInt(World.smPhysics.pY[World.smFishermans[0].mRopeParticle[0]]) - smWorldAnchorPointY - Toolkit.getScreenHeight() / 3;
        this.cameraSetXY(smStartingCameraX, smStartingCameraY);
        mBackground.init(smWorldAnchorPointX, smWorldAnchorPointY);
    }

    public static void worldAnchorPointReset() {
        smWorldAnchorPointX = 59;
        if (Toolkit.getScreenWidth() < Toolkit.getScreenHeight()) {
            Camera.smCameraMaxY = 120;
            smProportionalCameraOffsetX = 120;
            smProportionalCameraOffsetY = 128;
        } else {
            Camera.smCameraMaxY = 32;
            if (Toolkit.getScreenWidth() > Toolkit.getScreenHeight()) {
                smProportionalCameraOffsetX = 160;
                smProportionalCameraOffsetY = 120;
            } else {
                smProportionalCameraOffsetX = 120;
                smProportionalCameraOffsetY = 120;
            }
        }
        smWorldAnchorPointY = Camera.smCameraMaxY;
    }

    public boolean isRaining() {
        return Tuner.smRivalsBg[Game.smCountryEnemyID][5] == 0;
    }

    public void initCamera() {
        this.cameraSetXY(smStartingCameraX, smStartingCameraY);
    }

    public void cameraSetXY(int n, int n2) {
        mCamera.cameraSetXY(n, n2);
    }

    public void refreshWordPos() {
        smFishermans[0].boatRefreshWordPos(smWorldAnchorPointX, smWorldAnchorPointY);
        for (int i = 1; i < smPlayersCount; ++i) {
            smFishermans[i].boatRefreshWordPos(smWorldAnchorPointX + i * (Toolkit.getScreenWidth() / 2) + -260, smWorldAnchorPointY);
        }
        mBackground.refreshWordPos(smWorldAnchorPointX, smWorldAnchorPointY);
    }

    public int logicUpdate(int n, boolean bl) {
        int n2;
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 0;
        }
        smPhysics.setGravity(0x273333);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 1;
        }
        if (smGameIsPaused = bl) {
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 2;
            }
            for (n2 = 0; n2 < smPlayersCount; ++n2) {
                World.smFishermans[n2].mMustWaitEndTurn = false;
                World.smFishermans[n2].mActionButtonIsPressed = false;
            }
        } else {
            Statistics.statsIngameLogicUpdate();
            for (n2 = 0; n2 < smPlayersCount; ++n2) {
                smFishermans[n2].hookLogicUpdate(n);
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 3;
                }
                smFishermans[n2].boatLogicUpdate(n);
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 4;
                }
                smFishermans[n2].ropeProcessDrag(1);
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 5;
                }
                World.smFishermans[n2].mHasSomeFishBiting = false;
            }
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 6;
        }
        if (GameEngine.smGameState <= 3) {
            this.fishesOfStageLogicUpdate(n);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 38;
        }
        mBackground.logicUpdate(n);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 39;
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 40;
        }
        n2 = Hud.logicUpdate(n, smGameIsPaused);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 41;
        }
        for (int i = 0; i < smPlayersCount; ++i) {
            if (!World.smFishermans[i].mFishedLegendaryFish) continue;
            this.fishesOfStageLevelEnds();
            n2 = 1;
        }
        if (n2 == 1) {
            this.fishesOfStageLevelEnds();
        } else if (smGameIsPaused) {
            n2 = -1;
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 42;
        }
        return n2;
    }

    public void doDraw(Graphics graphics) {
        int n;
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 43;
        }
        smScrollOffsetX = smWorldAnchorPointX + World.mCamera.mCameraX;
        smScrollOffsetY = smWorldAnchorPointY + World.mCamera.mCameraY;
        int n2 = Toolkit.getScreenWidth();
        int n3 = Toolkit.getScreenHeight();
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 44;
        }
        mBackground.doDraw(graphics, smWorldAnchorPointX, smWorldAnchorPointY, smScrollOffsetX, smScrollOffsetY, 0);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 45;
        }
        int n4 = 0;
        smScrollOffsetX = smScrollOffsetX == -257 && GameEngine.smGameState <= 3 ? -49 : smWorldAnchorPointX + World.mCamera.mCameraX;
        smFishermans[0].boatDraw(graphics, smScrollOffsetX + n4, smScrollOffsetY - n4, false);
        if (GameEngine.smPlayMode == 0) {
            smFishermans[1].boatDraw(graphics, smScrollOffsetX - n4, smScrollOffsetY + n4, false);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 46;
        }
        GameEngine.introDoDraw(graphics);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 47;
        }
        this.fishesOfStageDoDraw(graphics, smScrollOffsetX, smScrollOffsetY, n2, n3);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 48;
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 49;
        }
        smFishermans[0].boatDraw(graphics, smScrollOffsetX + n4, smScrollOffsetY - n4, true);
        if (GameEngine.smPlayMode == 0) {
            smFishermans[1].boatDraw(graphics, smScrollOffsetX - n4, smScrollOffsetY + n4, true);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 50;
        }
        for (n = 0; n < smPlayersCount; ++n) {
            smFishermans[n].hookDoDraw(graphics, smScrollOffsetX, smScrollOffsetY);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 51;
        }
        if (World.smFishermans[0].mHookedFishID != -1) {
            mFishesOfStage[World.smFishermans[0].mHookedFishID].doDraw(graphics, smScrollOffsetX, smScrollOffsetY, n2, n3);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 52;
        }
        mBackground.doDraw(graphics, smWorldAnchorPointX, smWorldAnchorPointY, smScrollOffsetX, smScrollOffsetY, 1);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 53;
        }
        for (int i = 0; i < smPlayersCount; ++i) {
            n = Tuner.strengthHook[World.smFishermans[i].mLineStrengthType] * 60 / 100;
            if (World.smFishermans[i].mLineTension <= n || World.smFishermans[i].mHookedFishID == -1) continue;
            int n5 = FP.toInt(World.smPhysics.pX[World.smPhysics.cpA[World.smFishermans[i].mRopeSegment[0]]] + World.smPhysics.pX[World.smPhysics.cpB[World.smFishermans[i].mRopeSegment[0]]]) / 2 - smScrollOffsetX;
            int n6 = FP.toInt(World.smPhysics.pY[World.smPhysics.cpA[World.smFishermans[i].mRopeSegment[0]]] + World.smPhysics.pY[World.smPhysics.cpB[World.smFishermans[i].mRopeSegment[0]]]) / 2 - smScrollOffsetY;
            Hud.breakingLineFeedbackDraw(graphics, Game.worldToPixel(n5), Game.worldToPixel(n6), World.smFishermans[i].mLineTension - n, Tuner.strengthHook[World.smFishermans[i].mLineStrengthType] - n);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 54;
        }
        smPhysics.draw(graphics, smScrollOffsetX, smScrollOffsetY);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 55;
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 56;
        }
        if (GameEngine.smGameState == 3) {
            Hud.showPress5FeedbackMsg(graphics, n2 >> 1, n3 * 25 / 100 + 15);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 57;
        }
        Hud.draw(graphics, n2, n3);
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 58;
        }
    }

    private void fishesOfStageInit() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        this.mFishesCount = 0;
        for (n15 = 0; n15 < 20; ++n15) {
            if (Tuner.smLevels[Hud.smCurrentLevel][25 + n15] == -1) continue;
            this.mFishesCount += Tuner.smLevels[Hud.smCurrentLevel][25 + n15];
        }
        if (GameEngine.smPlayMode == 1) {
            ++this.mFishesCount;
        }
        minWorldFishCoorX = smWorldAnchorPointX + World.smFishermans[0].mBoatBackSpr.getWidth();
        maxWorldFishCoorX = minWorldFishCoorX + mBackground.getBackgroundWidth();
        minWorldFishCoorY = World.mBackground.mWavesBottomWorldPosY + 37;
        maxWorldFishCoorY = minWorldFishCoorY + 210;
        int n16 = 0;
        for (int i = 0; i < 20; ++i) {
            int n17 = Tuner.smLevels[Hud.smCurrentLevel][5 + i];
            if (n17 == -1) continue;
            n14 = Tuner.smLevels[Hud.smCurrentLevel][45 + i] == -1 ? Tuner.Specie[n17][4] : Tuner.smLevels[Hud.smCurrentLevel][45 + i];
            n13 = minWorldFishCoorX + Tuner.Areas[n14][0] * (maxWorldFishCoorX - minWorldFishCoorX) / 100;
            n12 = minWorldFishCoorY + Tuner.Areas[n14][1] * (maxWorldFishCoorY - minWorldFishCoorY) / 100;
            n11 = (Tuner.Areas[n14][2] - Tuner.Areas[n14][0]) * (maxWorldFishCoorX - minWorldFishCoorX) / 100;
            n10 = (Tuner.Areas[n14][3] - Tuner.Areas[n14][1]) * (maxWorldFishCoorY - minWorldFishCoorY) / 100;
            for (int j = n16; j < n16 + Tuner.smLevels[Hud.smCurrentLevel][25 + i]; ++j) {
                n15 = n13 + n11 / 2;
                if (n14 >= 193) {
                    n15 += mRandom.nextInt() % (n11 / 2);
                }
                n9 = n12 + Math.abs(mRandom.nextInt()) % n10;
                n8 = Tuner.Specie[n17][0] - Tuner.Specie[n17][1] / 2 + Math.abs(mRandom.nextInt() % Tuner.Specie[n17][1]);
                n7 = Tuner.Specie[n17][2] - Tuner.Specie[n17][3] / 2 + Math.abs(mRandom.nextInt() % Tuner.Specie[n17][3]);
                n6 = World.timeToDist(Tuner.Specie[n17][5] + Math.abs(mRandom.nextInt()) % Tuner.Specie[n17][6]);
                n5 = mRandom.nextInt() % n6 / 4;
                n4 = n15 - n6;
                n3 = n15 + n6;
                n2 = n9 + n5;
                n = n9 - n5;
                mFishesOfStage[j].fishInit(j, n8, n7);
                mFishesOfStage[j].setInWorldPos(n15, n9);
                mFishesOfStage[j].setSwimLimits(n4, n2, n3, n);
            }
            n16 += Tuner.smLevels[Hud.smCurrentLevel][25 + i];
        }
        if (GameEngine.smPlayMode == 1) {
            n14 = Tuner.Specie[27][4];
            n13 = minWorldFishCoorX + Tuner.Areas[n14][0] * (maxWorldFishCoorX - minWorldFishCoorX) / 100;
            n12 = minWorldFishCoorY + Tuner.Areas[n14][1] * (maxWorldFishCoorY - minWorldFishCoorY) / 100;
            n11 = (Tuner.Areas[n14][2] - Tuner.Areas[n14][0]) * (maxWorldFishCoorX - minWorldFishCoorX) / 100;
            n10 = (Tuner.Areas[n14][3] - Tuner.Areas[n14][1]) * (maxWorldFishCoorY - minWorldFishCoorY) / 100;
            n15 = n13 + n11 / 2;
            if (n14 >= 193) {
                n15 += mRandom.nextInt() % (n11 / 2);
            }
            n9 = n12 + Math.abs(mRandom.nextInt()) % n10;
            n8 = Tuner.Specie[27][0] - Tuner.Specie[27][1] / 2 + Math.abs(mRandom.nextInt() % Tuner.Specie[27][1]);
            n7 = Tuner.Specie[27][2] - Tuner.Specie[27][3] / 2 + Math.abs(mRandom.nextInt() % Tuner.Specie[27][3]);
            n6 = World.timeToDist(Tuner.Specie[27][5] + Math.abs(mRandom.nextInt()) % Tuner.Specie[27][6]);
            n5 = mRandom.nextInt() % n6 / 4;
            n4 = n15 - n6;
            n3 = n15 + n6;
            n2 = n9 + n5;
            n = n9 - n5;
            n8 = Tuner.Specie[27][0] - Tuner.Specie[27][1] / 2 + Math.abs(mRandom.nextInt() % Tuner.Specie[27][1]);
            n7 = Tuner.Specie[27][2] - Tuner.Specie[27][3] / 2 + Math.abs(mRandom.nextInt() % Tuner.Specie[27][3]);
            mFishesOfStage[n16].fishInit(n16, n8, n7);
            mFishesOfStage[n16].changeState(7);
            mFishesOfStage[n16].setInWorldPos(n15, n9);
            mFishesOfStage[n16].setSwimLimits(n4, n2, n3, n);
        }
    }

    public static int timeToDist(int n) {
        return n * 3 / 50;
    }

    public static int distToTime(int n) {
        return n * 50 / 3;
    }

    private void fishesOfStageLoad() {
        int n;
        this.setCurrentLevel();
        Hud.smLastLevel = Hud.smCurrentLevel;
        this.mFishesCount = 0;
        for (n = 0; n < 20; ++n) {
            if (Tuner.smLevels[Hud.smCurrentLevel][25 + n] == -1) continue;
            this.mFishesCount += Tuner.smLevels[Hud.smCurrentLevel][25 + n];
        }
        if (GameEngine.smPlayMode == 1) {
            ++this.mFishesCount;
        }
        if (mFishesOfStage != null) {
            this.fishesOfStageFreeResources();
            mFishesOfStage = null;
        }
        mFishesOfStage = new Fish[this.mFishesCount];
        n = 0;
        for (int i = 0; i < 20; ++i) {
            int n2 = Tuner.smLevels[Hud.smCurrentLevel][5 + i];
            if (n2 == -1) continue;
            for (int j = n; j < n + Tuner.smLevels[Hud.smCurrentLevel][25 + i]; ++j) {
                World.mFishesOfStage[j] = new Fish();
                n2 = Tuner.smLevels[Hud.smCurrentLevel][5 + i];
                mFishesOfStage[j].fishLoad(n2);
            }
            n += Tuner.smLevels[Hud.smCurrentLevel][25 + i];
        }
        if (GameEngine.smPlayMode == 1) {
            World.mFishesOfStage[n] = new Fish();
            mFishesOfStage[n].fishLoad(27);
        }
        this.hookWorldX = new int[smPlayersCount];
        this.hookWorldY = new int[smPlayersCount];
        this.mActionButtonIsPressed = new boolean[smPlayersCount];
        this.hookIsEmpty = new boolean[smPlayersCount];
        this.lineIsBroken = new boolean[smPlayersCount];
        this.hookIsUnderWater = new boolean[smPlayersCount];
        this.rodTopX = new int[smPlayersCount];
        this.rodTopY = new int[smPlayersCount];
    }

    public void fishesOfStageLogicUpdate(int n) {
        int n2;
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 26;
        }
        for (n2 = 0; n2 < smPlayersCount; ++n2) {
            if (Debug.CATCH) {
                Debug.smLastMethodPos = n2;
            }
            this.hookWorldX[n2] = FP.toInt(World.smPhysics.pX[World.smFishermans[n2].mRopeParticle[0]]);
            this.hookWorldY[n2] = FP.toInt(World.smPhysics.pY[World.smFishermans[n2].mRopeParticle[0]]);
            this.mActionButtonIsPressed[n2] = World.smFishermans[n2].mActionButtonIsPressed;
            this.hookIsEmpty[n2] = World.smFishermans[n2].mHookedFishID == -1;
            this.lineIsBroken[n2] = World.smFishermans[n2].mIsLineBroken;
            this.hookIsUnderWater[n2] = World.smFishermans[n2].mHookIsUnderWater;
            this.rodTopX[n2] = FP.toInt(World.smPhysics.pX[World.smFishermans[n2].mRodTopPartId]);
            this.rodTopY[n2] = FP.toInt(World.smPhysics.pY[World.smFishermans[n2].mRodTopPartId]);
        }
        n2 = -1;
        for (int i = 0; i < this.mFishesCount; ++i) {
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 27;
                Debug.smLastMethodPos = i;
            }
            n2 = mFishesOfStage[i].logicUpdate(n, this.hookWorldX, this.hookWorldY, this.mActionButtonIsPressed, this.hookIsEmpty, this.lineIsBroken, this.hookIsUnderWater, this.rodTopX, this.rodTopY);
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 28;
            }
            if (n2 != -1) {
                World.smFishermans[n2].mHookedFishID = i;
            }
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 29;
            }
            if (World.mFishesOfStage[i].mState != 6 && World.mFishesOfStage[i].mState != 10 || World.mFishesOfStage[i].mSpeedPullingX == 0 && World.mFishesOfStage[i].mSpeedPullingY == 0) continue;
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 30;
            }
            int n3 = World.smPhysics.pX[World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mRopeParticle[0]] - World.smPhysics.ppX[World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mRopeParticle[0]];
            int n4 = World.smPhysics.pY[World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mRopeParticle[0]] - World.smPhysics.ppY[World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mRopeParticle[0]];
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 31;
            }
            if (World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mHookIsUnderWater) {
                if (n3 > -445644) {
                    World.mFishesOfStage[i].mSpeedPullingX += -445644;
                }
                if (n4 < 183500) {
                    World.mFishesOfStage[i].mSpeedPullingY += 183500;
                }
            }
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 32;
            }
            if (World.mFishesOfStage[i].mSpeedPullingX > 0x3C0000) {
                World.mFishesOfStage[i].mSpeedPullingX = 0x3C0000;
            }
            if (World.mFishesOfStage[i].mSpeedPullingX < -3932160) {
                World.mFishesOfStage[i].mSpeedPullingX = -3932160;
            }
            if (World.mFishesOfStage[i].mSpeedPullingY > 0x3C0000) {
                World.mFishesOfStage[i].mSpeedPullingY = 0x3C0000;
            }
            if (World.mFishesOfStage[i].mSpeedPullingY < -3932160) {
                World.mFishesOfStage[i].mSpeedPullingY = -3932160;
            }
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 33;
            }
            int n5 = World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mRopeParticle[0];
            World.smPhysics.ppX[n5] = World.smPhysics.ppX[n5] + World.mFishesOfStage[i].mSpeedPullingX;
            int n6 = World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mRopeParticle[0];
            World.smPhysics.ppY[n6] = World.smPhysics.ppY[n6] + World.mFishesOfStage[i].mSpeedPullingY;
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 34;
            }
            World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mLineTension += Math.abs(FP.toInt(World.mFishesOfStage[i].mSpeedPullingY / 2 * 4));
            World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mLineTension += Math.abs(FP.toInt(World.mFishesOfStage[i].mSpeedPullingX / 2 * 4));
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 35;
            }
            World.mFishesOfStage[i].mSpeedPullingX = 0;
            World.mFishesOfStage[i].mSpeedPullingY = 0;
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 36;
            }
            if (World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mLineTension > Tuner.strengthHook[World.smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].mLineStrengthType]) {
                smFishermans[World.mFishesOfStage[i].mFishermanCatchingIt].hookChangeState(5);
            }
            if (!Debug.CATCH) continue;
            Debug.smLastMethodInfo = 37;
        }
    }

    private void fishesOfStageDoDraw(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mFishesCount; ++i) {
            mFishesOfStage[i].doDraw(graphics, n, n2, n3, n4);
        }
    }

    private void fishesOfStageLevelEnds() {
        for (int i = 0; i < this.mFishesCount; ++i) {
            mFishesOfStage[i].kill();
        }
    }

    private void fishesOfStageFreeResources() {
        Fish.freeResources();
        mFishesOfStage = null;
    }

    private static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        boolean bl;
        int n10 = n3 - n;
        int n11 = n4 - n2;
        int n12 = -n11;
        int n13 = n10;
        int n14 = World.sqrt(n10 * n10 + n11 * n11) >> FIXED_POINT;
        if (n14 != 0) {
            n12 = (n12 << FIXED_POINT) / n14;
            n13 = (n13 << FIXED_POINT) / n14;
        }
        if (n5 % 2 != 0) {
            ++n5;
        }
        n3 = (n += n12 * -(n5 >> 1) >> FIXED_POINT) + (n12 * n5 >> FIXED_POINT);
        n4 = (n2 += n13 * -(n5 >> 1) >> FIXED_POINT) + (n13 * n5 >> FIXED_POINT);
        boolean bl2 = bl = Math.abs(n4 - n2) > Math.abs(n3 - n);
        if (bl) {
            n9 = n2;
            n2 = n;
            n = n9;
            n9 = n4;
            n4 = n3;
            n3 = n9;
        }
        if (n > n3) {
            n9 = n3;
            n3 = n;
            n = n9;
            n9 = n4;
            n4 = n2;
            n2 = n9;
        }
        n9 = n3 - n;
        int n15 = Math.abs(n4 - n2);
        int n16 = -(n9 + 1 >> 1);
        int n17 = -1;
        int n18 = n2;
        if (n2 < n4) {
            n17 = 1;
        }
        for (int i = n; i < n3; ++i) {
            if (n6 > 0 && (i < n + n6 || i > n3 - n6)) {
                graphics.setColor(n8);
            } else {
                graphics.setColor(n7);
            }
            if (bl) {
                graphics.drawLine(n18, i, n18 + n10, i + n11);
                graphics.drawLine(n18, i + 1, n18 + n10, i + 1 + n11);
            } else {
                graphics.drawLine(i, n18, i + n10, n18 + n11);
                graphics.drawLine(i, n18 + 1, i + n10, n18 + 1 + n11);
            }
            if ((n16 += n15) < 0) continue;
            n18 += n17;
            n16 -= n9;
        }
    }

    private static int sqrt(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = (n <<= FIXED_POINT) >> 1;
        if (n2 == 0) {
            n2 = 1 << FIXED_POINT;
        }
        for (int i = 0; i < 10; ++i) {
            n2 = n2 + (n / n2 << FIXED_POINT) >> 1;
        }
        return n2;
    }

    public void freeResources() {
        mCamera = null;
        IngameBg.freeResources();
        mBackground = null;
        this.fishesOfStageFreeResources();
        smPhysics = null;
        Fisherman.freeResources();
        smFishermans = null;
        Hud.freeResources();
        System.gc();
    }

    static {
        FIXED_POINT = 10;
    }
}

