/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Texture2D;

public class DChocImage {
    public static final byte COLOR_DEPTH_DEFAULT = -1;
    public static final byte COLOR_DEPTH_8888 = 0;
    public static final byte COLOR_DEPTH_5551 = 1;
    public static final byte COLOR_DEPTH_4444 = 2;
    public static final byte COLOR_DEPTH_565 = 3;
    private Image2D image2d;
    private Texture2D texture2d;
    private Image mDelegate;
    private Graphics mGraphics;
    private int[] mEffectParam;
    private int[][] mBuffer;
    private int mRegionX;
    private int mRegionY;
    private int mRegionWidth;
    private int mRegionHeight;
    private static Image smGetRGBImage;
    private static Graphics smGetRGBGraphics;

    public DChocImage(Image image) {
        this.mDelegate = image;
        if (image.isMutable()) {
            this.mGraphics = image.getGraphics();
        }
    }

    public DChocImage(DChocImage dChocImage) {
        this.mDelegate = dChocImage.getImage();
        if (dChocImage.isMutable()) {
            this.mGraphics = dChocImage.getGraphics();
        }
        this.setRegion(dChocImage.getRegionX(), dChocImage.getRegionY(), dChocImage.getRegionWidth(), dChocImage.getRegionHeight());
    }

    public DChocImage(int n, int n2) {
        this.mDelegate = Image.createImage((int)n, (int)n2);
        this.mGraphics = this.mDelegate.getGraphics();
    }

    public DChocImage(int n) {
        this(Toolkit.getImage(n));
    }

    public DChocImage(int n, byte by) {
        this(Toolkit.getImage(n));
    }

    public void setBuffer(int[][] nArray) {
        this.mBuffer = nArray;
    }

    public int[][] getBuffer() {
        return this.mBuffer;
    }

    public int[] getEffectParams() {
        return this.mEffectParam;
    }

    public void copyEffectParam(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length;
            if (this.mEffectParam == null) {
                this.mEffectParam = new int[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.mEffectParam[n2] = nArray[n2];
            }
        } else {
            this.mEffectParam = null;
        }
    }

    public void setRegion(int n, int n2, int n3, int n4) {
        this.mRegionX = n;
        this.mRegionY = n2;
        this.mRegionWidth = n3;
        this.mRegionHeight = n4;
        if (this.isMutable()) {
            if (this.isRegioned()) {
                this.mGraphics.setClip(n, n2, n3, n4);
            } else {
                this.mGraphics.setClip(0, 0, this.mDelegate.getWidth(), this.mDelegate.getHeight());
            }
        }
    }

    public void clearRegion() {
        this.setRegion(0, 0, 0, 0);
    }

    public boolean isRegioned() {
        return this.mRegionWidth != 0 && this.mRegionHeight != 0;
    }

    public int getRegionX() {
        return this.mRegionX;
    }

    public int getRegionY() {
        return this.mRegionY;
    }

    public int getRegionWidth() {
        return this.mRegionWidth;
    }

    public int getRegionHeight() {
        return this.mRegionHeight;
    }

    public Image getImage() {
        return this.mDelegate;
    }

    public Graphics getGraphics() {
        return this.mGraphics;
    }

    public int getHeight() {
        if (this.mRegionHeight != 0) {
            return this.mRegionHeight;
        }
        return this.mDelegate.getHeight();
    }

    public void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isRegioned()) {
            n3 += this.mRegionX;
            n4 += this.mRegionY;
        }
        this.mDelegate.getRGB(nArray, n, n2, n3, n4, n5, n6);
    }

    public int getWidth() {
        if (this.mRegionWidth != 0) {
            return this.mRegionWidth;
        }
        return this.mDelegate.getWidth();
    }

    public boolean isMutable() {
        return this.mDelegate.isMutable();
    }

    public boolean isLoadingCompleted() {
        return true;
    }

    public Texture2D getTexture2D() {
        return this.texture2d;
    }

    public Image2D getImage2D() {
        return this.image2d;
    }
}

