/*
 * Decompiled with CFR 0.152.
 */
public class Displace {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_ACELERATE = 1;
    public static final int MODE_DECELERATE = 2;
    public static final int MODE_ACELERATE_PINGPONG = 3;
    public static final int MODE_ACELERATE_DECELERATE = 4;
    public static final int MODE_IPHONE_BOING = 5;
    public int mX;
    public int mY;
    public int mDistance;
    public int mDistance2;
    public int mPivot;
    public int mTotalSteps;
    public int mCurrentStep;
    public int mMode;
    public boolean mSide;
    public boolean mEnabled;
    public boolean mPaused;
    private static long smTimePassed;
    public long mTimeAtStart;

    public Displace() {
        this.mEnabled = false;
        this.mPaused = true;
    }

    public Displace(int n, int n2, boolean bl, int n3) {
        this.create(n, n2, bl, n3);
    }

    public void create(int n, int n2, boolean bl, int n3) {
        this.mDistance2 = n;
        if (n3 == 5) {
            n += n >> 3;
        }
        this.mDistance = n;
        this.mTotalSteps = n2;
        this.mMode = n3;
        this.mSide = bl;
        this.mCurrentStep = 0;
        this.mPivot = 0;
        this.mEnabled = true;
        this.mPaused = false;
        this.mTimeAtStart = smTimePassed;
    }

    public void restart() {
        int n = this.mPivot;
        this.create(this.mDistance2, this.mTotalSteps, this.mSide, this.mMode);
        this.mPivot = n;
    }

    public int getOffset() {
        if (!this.mEnabled) {
            return 0;
        }
        int n = 0;
        if (!this.mPaused) {
            n = (int)(smTimePassed - this.mTimeAtStart);
        }
        if (n > 0) {
            this.mCurrentStep += n;
            if (this.mCurrentStep > this.mTotalSteps) {
                this.mCurrentStep = this.mTotalSteps;
            }
            this.mTimeAtStart = smTimePassed;
        }
        return this.calculateOffset(this.mCurrentStep);
    }

    public int getOffset(int n) {
        return this.calculateOffset(n);
    }

    private int calculateOffset(int n) {
        int n2 = 0;
        switch (this.mMode) {
            case 0: {
                n2 = this.regla3(n, this.mTotalSteps, this.mDistance);
                break;
            }
            case 1: {
                n = this.regla3(n, this.mTotalSteps, 16384);
                n2 = this.regla3(DavinciUtilities.sin(n + 16384), 32768, this.mDistance);
                n2 = this.mDistance - n2;
                break;
            }
            case 3: {
                n = this.regla3(n, this.mTotalSteps, 32768);
                n2 = this.regla3(DavinciUtilities.sin(n), 32768, this.mDistance);
                break;
            }
            case 4: {
                n = this.regla3(n, this.mTotalSteps, 32768);
                n2 = this.regla3(DavinciUtilities.sin(n + 16384), 32768, this.mDistance);
                n2 += this.mDistance;
                n2 = this.mDistance - (n2 >> 1);
                break;
            }
            case 2: {
                n = this.regla3(n, this.mTotalSteps, 16384);
                n2 = this.regla3(DavinciUtilities.sin(n), 32768, this.mDistance);
                break;
            }
            case 5: {
                n = this.regla3(n, this.mTotalSteps, 20480);
                n2 = this.regla3(DavinciUtilities.sin(n), 32768, this.mDistance);
            }
        }
        return this.mPivot + (this.mSide ? n2 : this.mDistance2 - n2);
    }

    public void setFinished() {
        this.mCurrentStep = this.mTotalSteps;
    }

    public boolean isFinished() {
        return this.mCurrentStep >= this.mTotalSteps;
    }

    public void setPaused(boolean bl) {
        if (this.mPaused != bl) {
            this.mPaused = bl;
            this.mTimeAtStart = smTimePassed;
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public static void logicUpdate(int n) {
        smTimePassed += (long)n;
    }

    private int regla3(int n, int n2, int n3) {
        return n * n3 / n2;
    }
}

