/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Fish {
    static final boolean DEBUG_FISH = false;
    public static final int ORANGE_FISH = 0;
    public static final int GREEN_FISH = 1;
    public static final int RED_FISH = 2;
    public static final int ALL_FISHES = 3;
    public static final int FISH_STATE_NONE = -1;
    public static final int FISH_STATE_SWIMMING_ALONE = 0;
    public static final int FISH_STATE_SWIMMING_FOLOWING_GROUP = 1;
    public static final int FISH_STATE_SWIMMING_FASTER_HUNGRY = 2;
    public static final int FISH_STATE_SWIMMING_FASTER_SCARED = 3;
    public static final int FISH_STATE_JUMPING_OUTSIDE_WATER = 4;
    public static final int FISH_STATE_BITING = 5;
    public static final int FISH_STATE_PULLING = 6;
    public static final int FISH_STATE_CATCHED = 7;
    public static final int FISH_STATE_TURNING = 8;
    public static final int FISH_STATE_ROLLING_TO_BOAT = 9;
    public static final int FISH_STATE_GOING_TO_JUMP_OUTSIDE_WATER = 10;
    public static final int FISH_STATE_WAITING_RESPAWN = 11;
    public static final int FISH_STATE_RESPAWNING = 12;
    public static final int FISH_STATE_COUNT = 13;
    public static final int FISH_PULLING_SEQUENCE_NUMBER = 10;
    public int mState;
    public static final boolean[] mIsFishable = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, true};
    public static final boolean[] mIsAlive = new boolean[]{true, true, true, true, true, true, true, false, true, true, true, false, true};
    public int mWeight;
    public int mDifficulty;
    public int mTimeMaxBiting;
    public int mTimeElapsedBiting;
    public int mSpecie;
    public static final boolean[] mIsSpecieLegendaryFish = new boolean[]{false, false, true};
    public int[] mProbOfFishingWithLureType;
    boolean mIsInPath;
    public int mWorldPosX;
    public int mWorldPosMinX;
    public int mWorldPosMaxX;
    public int mWorldPosY;
    public int mWorldPosY1;
    public int mWorldPosY2;
    private int mFirstWorldPosX;
    private int mFirstWorldPosY;
    private int mWorldPosYCopy;
    public int mSpeed;
    public static final int SIDE_LEFT = -1;
    public static final int SIDE_RIGHT = 1;
    public int mLookingToSide;
    public int mAngle;
    private int mTimeElapsedSwimmingInSameDir;
    private int mTimeMaxSwimmingInSameDir;
    private SpriteObject mFishAnims;
    public static final int FISH_ANIM_SWIM_LEFT = 0;
    public static final int FISH_ANIM_SWIM_RIGHT = 1;
    public static final int FISH_ANIM_TURN_LEFT = 2;
    public static final int FISH_ANIM_TURN_RIGHT = 3;
    public static final int FISH_ANIM_BITING_LEFT = 4;
    public static final int FISH_ANIM_BITING_RIGHT = 5;
    public static final int FISH_ANIM_FISHED_LEFT = 6;
    public static final int FISH_ANIM_FISHED_RIGHT = 7;
    public static final int FISH_ANIM_COUNT = 8;
    private int mCurrentFishAnim;
    private int mTimeElapsedInCurrentFishAnim;
    private int mTimeSinceLastPulling;
    private int mTimesPulled;
    public int mSpeedPullingX;
    public int mSpeedPullingY;
    public int mBarrelRolStartDistanceX;
    public int mBarrelRolStartDistanceY;
    public int mBarrelRolStartAngle;
    public int mBarrelRolStartX;
    public int mBarrelRolStartY;
    public int mBarrelRolOffsetX;
    public int mBarrelRolOffsetY;
    public int mBarrelRolTimeElapsed;
    public static final int BARREL_ROL_TOTAL_TIME = 800;
    private static int smLegendaryElapsedTime;
    public int mFishermanCatchingIt;
    public int mLastFishermanWhoCatchedIt;
    public boolean mIsSomeFishermanCachingIt;
    public static Random mRnd;
    private int mRespawnElapsedTime;
    public int mFishId;
    private int smAngleAddition;
    private static final int FISH_TEMP_WIDTH = 32;
    private static Vector smSpriteObjectCache;

    public Fish() {
        mRnd = new Random();
        mRnd.setSeed(System.currentTimeMillis());
    }

    public void setMFishAnims(SpriteObject spriteObject) {
        this.mFishAnims = spriteObject;
    }

    public void fishLoad(int n) {
        this.mSpecie = n;
        int[][] nArray = FishLoading.initFishArray();
        this.mFishAnims = Fish.loadSpriteObject(nArray[this.mSpecie], true);
    }

    public void fishInit(int n, int n2, int n3) {
        this.mFishId = n;
        this.mWeight = n2;
        this.mDifficulty = n3;
        smLegendaryElapsedTime = 0;
        this.mRespawnElapsedTime = 0;
        this.changeState(0);
        this.mLastFishermanWhoCatchedIt = 0;
        this.mIsSomeFishermanCachingIt = false;
        if (Math.abs(mRnd.nextInt()) % 2 == 0) {
            this.mLookingToSide = 1;
            this.mCurrentFishAnim = 1;
        } else {
            this.mLookingToSide = -1;
            this.mCurrentFishAnim = 0;
        }
        this.mTimeMaxBiting = Tuner.Specie[this.mSpecie][7] - Tuner.Specie[this.mSpecie][8] / 2 + Math.abs(mRnd.nextInt()) % Tuner.Specie[this.mSpecie][8];
        this.mTimeSinceLastPulling = 0;
        this.mBarrelRolTimeElapsed = 0;
        this.mTimesPulled = 0;
        this.mAngle = 0;
        this.mSpeed = 0;
        this.mTimeElapsedBiting = 0;
        this.mTimeElapsedSwimmingInSameDir = 0;
        this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
        this.mTimeElapsedInCurrentFishAnim = 0;
        int n4 = this.mFishAnims.getFrameCount();
        int n5 = Math.abs(mRnd.nextInt()) % n4;
        this.mFishAnims.setAnimationFrame(n5);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public int logicUpdate(int var1_1, int[] var2_2, int[] var3_3, boolean[] var4_4, boolean[] var5_5, boolean[] var6_6, boolean[] var7_7, int[] var8_8, int[] var9_9) {
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 9;
        }
        var10_10 = -1;
        var12_11 = new int[World.smPlayersCount];
        var13_12 = new int[World.smPlayersCount];
        for (var14_13 = 0; var14_13 < World.smPlayersCount; ++var14_13) {
            if (Debug.CATCH) {
                Debug.smLastMethodInfo = 10;
                Debug.smLastMethodPos = var14_13;
            }
            var12_11[var14_13] = var1_1 / 5 < Math.abs(this.mWorldPosX - var2_2[var14_13]) ? var1_1 / 5 : Math.abs(this.mWorldPosX - var2_2[var14_13]);
            var13_12[var14_13] = var1_1 / 5 < Math.abs(this.mWorldPosY - var3_3[var14_13]) ? var1_1 / 5 : Math.abs(this.mWorldPosY - var3_3[var14_13]);
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 11;
        }
        this.mFishAnims.logicUpdate(var1_1);
        if (Fish.mIsAlive[this.mState]) {
            for (var14_13 = 0; var14_13 < World.smPlayersCount; ++var14_13) {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 12;
                    Debug.smLastMethodPos = var14_13;
                }
                if (!Fish.mIsFishable[this.mState] || World.smFishermans[var14_13].mHasSomeFishBiting || !this.isNearHook(var14_13, var2_2[var14_13], var3_3[var14_13]) || !var5_5[var14_13] || var6_6[var14_13]) continue;
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 13;
                }
                this.mLastFishermanWhoCatchedIt = this.mFishermanCatchingIt = var14_13;
                this.mIsSomeFishermanCachingIt = true;
                this.changeState(2);
            }
        }
        if (Debug.CATCH) {
            Debug.smLastMethodInfo = 14;
            Debug.smLastMethodPos = this.mFishId;
        }
        switch (this.mState) {
            case 0: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 15;
                    Debug.smLastMethodPos = this.mFishId;
                }
                this.mFishermanCatchingIt = -1;
                this.mTimeElapsedSwimmingInSameDir += var1_1;
                var14_13 = 0;
                if (this.mIsInPath) ** GOTO lbl68
                if (this.mFishAnims.isFinishedAnimation()) {
                    this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                    this.mTimeElapsedInCurrentFishAnim = 0;
                }
                if (this.mTimeElapsedSwimmingInSameDir <= 30) ** GOTO lbl88
                this.mTimeElapsedSwimmingInSameDir = 0;
                if (this.mWorldPosY >= World.mBackground.mWavesBottomWorldPosY) ** GOTO lbl49
                ++this.mWorldPosX;
                this.mWorldPosY += 6;
                ** GOTO lbl88
lbl49:
                // 1 sources

                var15_14 = this.mFirstWorldPosX - this.mWorldPosX;
                var16_17 = this.mFirstWorldPosY - this.mWorldPosY;
                if (var15_14 <= 0 || this.mLookingToSide != -1) ** GOTO lbl55
                this.mCurrentFishAnim = 3;
                var14_13 = 1;
                ** GOTO lbl88
lbl55:
                // 1 sources

                if (var15_14 < 0 && this.mLookingToSide == 1) {
                    this.mCurrentFishAnim = 2;
                    var14_13 = 1;
                } else {
                    if (var15_14 != 0) {
                        this.mWorldPosX += var15_14 > 0 ? 1 : -1;
                    }
                    if (var16_17 != 0) {
                        this.mWorldPosY += var16_17 > 0 ? 1 : -1;
                    }
                    if (var15_14 != 0) return var10_10;
                    if (var16_17 != 0) return var10_10;
                    this.mIsInPath = true;
                    this.mTimeElapsedSwimmingInSameDir = this.mTimeMaxSwimmingInSameDir / 2;
                    return var10_10;
                }
lbl68:
                // 1 sources

                if (this.mLookingToSide == -1) {
                    var15_15 = this.mWorldPosMaxX;
                    var16_18 = this.mWorldPosY2;
                    var17_21 = this.mWorldPosMinX;
                    var18_24 = this.mWorldPosY1;
                } else {
                    var15_15 = this.mWorldPosMinX;
                    var16_18 = this.mWorldPosY1;
                    var17_21 = this.mWorldPosMaxX;
                    var18_24 = this.mWorldPosY2;
                }
                this.mWorldPosX = var15_15 + (var17_21 - var15_15) * this.mTimeElapsedSwimmingInSameDir / this.mTimeMaxSwimmingInSameDir;
                this.mWorldPosY = var16_18 + (var18_24 - var16_18) * this.mTimeElapsedSwimmingInSameDir / this.mTimeMaxSwimmingInSameDir;
                if (this.mLookingToSide == -1) {
                    if (this.mWorldPosX < this.mWorldPosMinX) {
                        this.mCurrentFishAnim = 3;
                        var14_13 = 1;
                    }
                } else if (this.mWorldPosX > this.mWorldPosMaxX) {
                    this.mCurrentFishAnim = 2;
                    var14_13 = 1;
                }
lbl88:
                // 8 sources

                if (var14_13 != 0) {
                    this.mTimeElapsedSwimmingInSameDir = 0;
                    this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                    this.mTimeElapsedInCurrentFishAnim = 0;
                    this.changeState(8);
                    return var10_10;
                }
                if (this.mFishAnims.isFinishedAnimation() == false) return var10_10;
                this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                this.mTimeElapsedInCurrentFishAnim = 0;
                return var10_10;
            }
            case 8: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 16;
                    Debug.smLastMethodPos = this.mFishId;
                }
                if (!this.mFishAnims.isFinishedAnimation()) {
                    if (this.mTimeElapsedInCurrentFishAnim <= this.mFishAnims.getAnimationLength()) return var10_10;
                }
                if (this.mLookingToSide == -1) {
                    this.mLookingToSide = 1;
                    this.mCurrentFishAnim = 1;
                } else {
                    this.mLookingToSide = -1;
                    this.mCurrentFishAnim = 0;
                }
                this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                this.mTimeElapsedInCurrentFishAnim = 0;
                this.changeState(0);
                return var10_10;
            }
            case 2: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 17;
                    Debug.smLastMethodPos = this.mFishId;
                }
                if (var5_5[this.mFishermanCatchingIt] && var7_7[this.mFishermanCatchingIt] && !var6_6[this.mFishermanCatchingIt]) {
                    if (this.mWorldPosX > var2_2[this.mFishermanCatchingIt] - 2 && this.mWorldPosX < var2_2[this.mFishermanCatchingIt] + 2 && this.mWorldPosY > var3_3[this.mFishermanCatchingIt] - 2 && this.mWorldPosY < var3_3[this.mFishermanCatchingIt] + 2) {
                        this.mTimeElapsedBiting = 0;
                        if (!Hud.smIsDrawingPress5 && this.mFishermanCatchingIt == 0) {
                            Hud.enablePress5FeedBack();
                            Hud.disableRelease5FeedBack();
                        }
                        this.mCurrentFishAnim = this.mLookingToSide == -1 ? 4 : 5;
                        this.mFishAnims.setAnimation(this.mCurrentFishAnim, -1, true);
                        this.mTimeElapsedInCurrentFishAnim = 0;
                        this.changeState(5);
                        return var10_10;
                    }
                    if (var2_2[this.mFishermanCatchingIt] < this.mWorldPosX) {
                        if (this.mLookingToSide == -1) {
                            this.mWorldPosX -= var12_11[this.mFishermanCatchingIt];
                        } else {
                            this.mTimeElapsedSwimmingInSameDir = 0;
                            this.mCurrentFishAnim = 2;
                            this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                            this.mTimeElapsedInCurrentFishAnim = 0;
                            this.changeState(8);
                        }
                    }
                    if (var2_2[this.mFishermanCatchingIt] > this.mWorldPosX) {
                        if (this.mLookingToSide == 1) {
                            this.mWorldPosX += var12_11[this.mFishermanCatchingIt];
                        } else {
                            this.mTimeElapsedSwimmingInSameDir = 0;
                            this.mCurrentFishAnim = 3;
                            this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                            this.mTimeElapsedInCurrentFishAnim = 0;
                            this.changeState(8);
                        }
                    }
                    if (var3_3[this.mFishermanCatchingIt] < this.mWorldPosY) {
                        this.mWorldPosY -= var13_12[this.mFishermanCatchingIt];
                        return var10_10;
                    }
                    if (var3_3[this.mFishermanCatchingIt] <= this.mWorldPosY) return var10_10;
                    this.mWorldPosY += var13_12[this.mFishermanCatchingIt];
                    return var10_10;
                }
                this.changeState(3);
                return var10_10;
            }
            case 3: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 18;
                    Debug.smLastMethodPos = this.mFishId;
                }
                if (this.mWorldPosX > var2_2[this.mFishermanCatchingIt] + (Toolkit.getScreenWidth() >> 2) || this.mWorldPosX < var2_2[this.mFishermanCatchingIt] - (Toolkit.getScreenWidth() >> 2)) {
                    this.mIsSomeFishermanCachingIt = false;
                    this.changeState(0);
                    return var10_10;
                }
                if (this.mLookingToSide == 1) {
                    this.mWorldPosX += var1_1 / 5;
                    return var10_10;
                }
                this.mWorldPosX -= var1_1 / 5;
                return var10_10;
            }
            case 5: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 19;
                    Debug.smLastMethodPos = this.mFishId;
                }
                var15_16 = false;
                if (!var7_7[this.mFishermanCatchingIt] || var6_6[this.mFishermanCatchingIt] || !var5_5[this.mFishermanCatchingIt] || World.smFishermans[this.mFishermanCatchingIt].mHookedFishID != -1) ** GOTO lbl196
                if (this.mTimeElapsedBiting >= this.mTimeMaxBiting) ** GOTO lbl194
                this.mTimeElapsedBiting += var1_1;
                World.smFishermans[this.mFishermanCatchingIt].mHasSomeFishBiting = true;
                this.mWorldPosX = var2_2[this.mFishermanCatchingIt];
                this.mWorldPosY = var3_3[this.mFishermanCatchingIt];
                if (var4_4[this.mFishermanCatchingIt]) {
                    var10_10 = this.mFishermanCatchingIt;
                    var5_5[this.mFishermanCatchingIt] = false;
                    this.mCurrentFishAnim = 6;
                    this.mFishAnims.setAnimation(this.mCurrentFishAnim, -1, true);
                    this.mTimeElapsedInCurrentFishAnim = 0;
                    this.mTimeSinceLastPulling = 0;
                    this.mTimesPulled = 0;
                    Fish.smLegendaryElapsedTime = 0;
                    this.changeState(6);
                } else if (!Hud.smIsDrawingPress5 && this.mFishermanCatchingIt == 0) {
                    Hud.enablePress5FeedBack();
                    Hud.disableRelease5FeedBack();
                }
                ** GOTO lbl197
lbl194:
                // 1 sources

                var15_16 = true;
                ** GOTO lbl197
lbl196:
                // 1 sources

                var15_16 = true;
lbl197:
                // 4 sources

                if (var15_16 == false) return var10_10;
                if (this.mFishermanCatchingIt == 0) {
                    Hud.disablePress5FeedBack();
                }
                this.mTimeElapsedSwimmingInSameDir = 0;
                this.mCurrentFishAnim = this.mLookingToSide == -1 ? 0 : 1;
                this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
                this.mTimeElapsedInCurrentFishAnim = 0;
                this.changeState(3);
                return var10_10;
            }
            case 6: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 20;
                    Debug.smLastMethodPos = this.mFishId;
                }
                if (this.mTimeSinceLastPulling > Tuner.Specie[this.mSpecie][19 + this.mTimesPulled]) {
                    this.mTimeSinceLastPulling %= Tuner.Specie[this.mSpecie][19 + this.mTimesPulled];
                    ++this.mTimesPulled;
                    this.mTimesPulled %= 10;
                    var16_19 = FP.toFP((7 + this.mDifficulty / 300) * 5);
                    var17_22 = FP.toFP((4 + this.mDifficulty / 400) * 5);
                    this.mSpeedPullingX = -var16_19;
                    this.mSpeedPullingY = -var17_22;
                    if (this.mWorldPosY < World.minWorldFishCoorY + (World.maxWorldFishCoorY - World.minWorldFishCoorY) / 8 || this.mWorldPosY > World.minWorldFishCoorY + (World.maxWorldFishCoorY - World.minWorldFishCoorY) * 6 / 8) {
                        this.changeState(10);
                    }
                }
                this.mSpeedPullingX -= 0x140000;
                this.mWorldPosX = var2_2[this.mFishermanCatchingIt];
                this.mWorldPosY = var3_3[this.mFishermanCatchingIt];
                this.smAngleAddition = 192;
                if (this.mSpecie == 27) {
                    this.smAngleAddition += 64;
                }
                this.checkBarrelRollInitPos(var1_1, this.smAngleAddition, var8_8, var9_9);
                this.mTimeSinceLastPulling += var1_1;
                return var10_10;
            }
            case 10: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 21;
                    Debug.smLastMethodPos = this.mFishId;
                }
                this.mWorldPosX = var2_2[this.mFishermanCatchingIt];
                this.mWorldPosY = var3_3[this.mFishermanCatchingIt];
                this.smAngleAddition = 192;
                if (this.mSpecie == 27) {
                    this.smAngleAddition += 64;
                }
                this.checkBarrelRollInitPos(var1_1, this.smAngleAddition, var8_8, var9_9);
                if (this.mWorldPosY < World.minWorldFishCoorY + (World.maxWorldFishCoorY - World.minWorldFishCoorY) / 8) {
                    World.smPhysics.setParticleVelocity(World.smFishermans[this.mFishermanCatchingIt].mRopeParticle[0], 0x280000, -3932160);
                } else {
                    World.smPhysics.setParticleVelocity(World.smFishermans[this.mFishermanCatchingIt].mRopeParticle[0], 0x3C0000, -1310720);
                }
                if (this.mWorldPosY >= World.mBackground.mWavesBottomWorldPosY) return var10_10;
                this.changeState(4);
                return var10_10;
            }
            case 4: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 22;
                    Debug.smLastMethodPos = this.mFishId;
                }
                this.mSpeedPullingX = -2621440;
                this.mWorldPosX = var2_2[this.mFishermanCatchingIt];
                this.mWorldPosY = var3_3[this.mFishermanCatchingIt];
                var16_20 = 192;
                if (this.mWorldPosY >= World.minWorldFishCoorY) {
                    this.changeState(6);
                } else if (this.mWorldPosY < World.mBackground.mWavesBottomWorldPosY && this.mWorldPosX - var8_8[this.mFishermanCatchingIt] < 32 && this.mWorldPosY > var9_9[this.mFishermanCatchingIt]) {
                    var16_20 = this.mWorldPosX - var8_8[this.mFishermanCatchingIt];
                }
                if (this.mSpecie == 27) {
                    var16_20 += 48;
                }
                this.checkBarrelRollInitPos(var1_1, var16_20, var8_8, var9_9);
                return var10_10;
            }
            case 9: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 23;
                    Debug.smLastMethodPos = this.mFishId;
                }
                if (GameEngine.smPlayMode == 1 && this.mFishermanCatchingIt != 0) {
                    this.mFishermanCatchingIt = 0;
                } else if (GameEngine.smPlayMode == 0 && this.mFishermanCatchingIt != 0 && this.mFishermanCatchingIt != 1) {
                    this.mFishermanCatchingIt = this.mLastFishermanWhoCatchedIt;
                }
                if (this.mBarrelRolTimeElapsed < 800) {
                    this.mBarrelRolTimeElapsed += var1_1;
                }
                this.mAngle = this.mBarrelRolStartAngle + (192 - this.mBarrelRolStartAngle) * this.mBarrelRolTimeElapsed / 800;
                this.mAngle <<= 8;
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 59;
                }
                var17_23 = World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosX - this.mFishAnims.getWidth() / 2;
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 60;
                }
                if (this.mSpecie == 27) {
                    var17_23 = World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosX;
                } else if (this.mSpecie == 8 || this.mSpecie == 22) {
                    var17_23 -= this.mFishAnims.getWidth() / 2;
                }
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 61;
                }
                if (this.mWorldPosX != var17_23) {
                    this.mWorldPosX = var17_23 + this.mBarrelRolStartDistanceX - this.mBarrelRolStartDistanceX * this.mBarrelRolTimeElapsed / 800;
                }
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 62;
                }
                if (this.mWorldPosYCopy != World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosY) {
                    this.mWorldPosYCopy = World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosY + this.mBarrelRolStartDistanceY - this.mBarrelRolStartDistanceY * this.mBarrelRolTimeElapsed / 800;
                }
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 63;
                }
                if (this.mBarrelRolStartDistanceX == 0) {
                    this.mBarrelRolStartDistanceX = 1;
                }
                var18_25 = 128 - 128 * (this.mWorldPosX - var17_23) / this.mBarrelRolStartDistanceX;
                this.mWorldPosY = this.mWorldPosYCopy + (-80 * Trigonometry.sin(var18_25) >> 10);
                if (this.mWorldPosX > var17_23) return var10_10;
                if (Hud.smTimeRemaining > 0) {
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 65;
                    }
                    this.addScore();
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 66;
                    }
                    World.smFishermans[this.mFishermanCatchingIt].mBoatDisplaceY.restart();
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 67;
                    }
                    World.smFishermans[this.mFishermanCatchingIt].fishermanSetAnim(4);
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 68;
                    }
                    World.smFishermans[this.mFishermanCatchingIt].hookChangeState(7);
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 69;
                        Debug.smLastMethodPos = this.mFishId;
                    }
                    Hud.smTurnEnded = true;
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 70;
                    }
                    World.smFishermans[this.mFishermanCatchingIt].fishedTextStart(this.mFishId, this.mWorldPosX, this.mWorldPosY);
                    if (Debug.CATCH) {
                        Debug.smLastMethodInfo = 71;
                    }
                } else if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 72;
                }
                this.kill();
                if (Debug.CATCH == false) return var10_10;
                Debug.smLastMethodInfo = 73;
                return var10_10;
            }
            case 11: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 24;
                    Debug.smLastMethodPos = this.mFishId;
                }
                this.mRespawnElapsedTime += var1_1;
                if (this.mRespawnElapsedTime <= Hud.mScore[0]) {
                    if (this.mSpecie != 27) return var10_10;
                }
                this.mTimeSinceLastPulling = 0;
                this.mBarrelRolTimeElapsed = 0;
                this.mTimesPulled = 0;
                this.mAngle = 0;
                this.mSpeed = 0;
                this.mTimeElapsedBiting = 0;
                this.mTimeElapsedSwimmingInSameDir = 0;
                this.mLookingToSide = -1;
                this.mWorldPosX = this.mSpecie == 27 ? this.mFirstWorldPosX + 182 : this.mFirstWorldPosX + 1092;
                this.mWorldPosY = this.mFirstWorldPosY;
                this.mCurrentFishAnim = 0;
                this.mFishAnims.setAnimation(this.mCurrentFishAnim, -1, true);
                this.mTimeElapsedInCurrentFishAnim = 0;
                this.changeState(12);
                return var10_10;
            }
            case 12: {
                if (Debug.CATCH) {
                    Debug.smLastMethodInfo = 25;
                    Debug.smLastMethodPos = this.mFishId;
                }
                this.mWorldPosX -= var1_1 / 16;
                if (this.mFirstWorldPosX <= this.mWorldPosX) return var10_10;
                this.mRespawnElapsedTime = 0;
                this.mWorldPosX = this.mFirstWorldPosX;
                this.fishInit(this.mFishId, this.mWeight, this.mDifficulty);
                this.changeState(0);
                return var10_10;
            }
        }
        return var10_10;
    }

    public void checkBarrelRollInitPos(int n, int n2, int[] nArray, int[] nArray2) {
        this.mAngle = Trigonometry.trigon_atan(this.mWorldPosX - nArray[this.mFishermanCatchingIt], this.mWorldPosY - nArray2[this.mFishermanCatchingIt]);
        this.mBarrelRolStartAngle = this.mAngle = (this.mAngle + n2) % 256;
        this.mAngle <<= 8;
        this.mBarrelRolStartDistanceX = this.mSpecie == 27 ? this.mWorldPosX - World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosX : this.mWorldPosX - (World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosX - this.mFishAnims.getWidth() / 2);
        if (this.mBarrelRolStartDistanceX == 0) {
            this.mBarrelRolStartDistanceX = 1;
        }
        this.mBarrelRolStartDistanceY = this.mWorldPosY - World.smFishermans[this.mFishermanCatchingIt].mBoatWorldPosY;
        this.mBarrelRolStartX = this.mWorldPosX;
        this.mBarrelRolStartY = this.mWorldPosY;
        this.mBarrelRolTimeElapsed = 0;
        this.mWorldPosYCopy = this.mWorldPosY;
    }

    public void kill() {
        this.mIsSomeFishermanCachingIt = false;
        this.mFishAnims.freeFrameCacheBuffers();
        if (GameEngine.smPlayMode == 1) {
            this.changeState(11);
        } else {
            this.changeState(7);
        }
    }

    public void addScore() {
        if (this.mFishermanCatchingIt == 0) {
            MenuFishGallery.setFishCollected(this.mSpecie);
        }
        Hud.scoreAdds(this.mFishermanCatchingIt, this.mSpecie, this.mWeight, this.mDifficulty);
    }

    public void scare() {
        this.mFishAnims.freeFrameCacheBuffers();
        this.mTimeElapsedSwimmingInSameDir = 0;
        this.mCurrentFishAnim = this.mLookingToSide == -1 ? 0 : 1;
        this.mAngle = 0;
        this.mFishAnims.setAnimation(this.mCurrentFishAnim, 1, true);
        this.mTimeElapsedInCurrentFishAnim = 0;
        this.changeState(3);
    }

    public void doDraw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (mIsAlive[this.mState]) {
            if (this.mState != 9 && (this.mState == 6 || this.mState == 10)) {
                this.mWorldPosX = FP.toInt(World.smPhysics.pX[World.smFishermans[this.mFishermanCatchingIt].mRopeParticle[0]]);
                this.mWorldPosY = FP.toInt(World.smPhysics.pY[World.smFishermans[this.mFishermanCatchingIt].mRopeParticle[0]]);
            }
            int n5 = this.mWorldPosX - n;
            int n6 = this.mWorldPosY - n2;
            int n7 = this.mFishAnims.getFrameWidth();
            int n8 = this.mFishAnims.getFrameWidth();
            if (this.mAngle != 0) {
                SpriteObject.setRotation(this.mAngle);
            }
            int n9 = Game.worldToPixel(n5);
            int n10 = Game.worldToPixel(n6);
            if (n9 + n7 >= 0 && n9 - n7 < n3 && n10 + n8 >= 0 && n10 - n8 < n4) {
                this.mFishAnims.draw(graphics, n9 - (this.mSpecie == 8 ? 2 : 0), n10);
            }
            if (this.mState == 5) {
                Hud.smFeedbackFont.drawString(graphics, "!", Game.worldToPixel(n5), Game.worldToPixel(n6) - (n4 >> 5), 33);
            }
            if (this.mAngle != 0) {
                SpriteObject.setRotation(0);
            }
            if (this.mState == 9) {
                graphics.setClip(0, 0, n3, n4);
            }
        }
    }

    public void setInWorldPos(int n, int n2) {
        this.mWorldPosX = n;
        this.mWorldPosY = n2;
        this.mFirstWorldPosX = n;
        this.mFirstWorldPosY = n2;
    }

    public void setSwimLimits(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.mWorldPosMinX = n;
            this.mWorldPosMaxX = n3;
        } else {
            this.mWorldPosMinX = n3;
            this.mWorldPosMaxX = n;
        }
        this.mWorldPosY1 = n2;
        this.mWorldPosY2 = n4;
        int n5 = Math.abs(this.mWorldPosMaxX - this.mWorldPosMinX) + Math.abs(this.mWorldPosY1 - this.mWorldPosY2);
        this.mTimeMaxSwimmingInSameDir = World.distToTime(n5);
        this.mTimeElapsedSwimmingInSameDir = Math.abs(mRnd.nextInt()) % this.mTimeMaxSwimmingInSameDir;
        this.mIsInPath = true;
    }

    public void changeState(int n) {
        this.mState = n;
        if (n != 0 && n != 8) {
            this.mIsInPath = false;
        }
    }

    public boolean isNearHook(int n, int n2, int n3) {
        int n4 = 32 * Tuner.Specie[this.mSpecie][9 + World.smFishermans[n].mBaitType] / 100;
        return n2 >= this.mWorldPosX - n4 && n2 < this.mWorldPosX + n4 && n3 >= this.mWorldPosY - n4 && n3 < this.mWorldPosY + n4;
    }

    public static void freeResources() {
        Fish.freeSpriteObjects();
    }

    public static SpriteObject loadSpriteObject(int[] nArray, boolean bl) {
        Animation[] animationArray = DavinciUtilities.loadAnimations(nArray);
        SpriteObject spriteObject = new SpriteObject(animationArray, bl);
        if (smSpriteObjectCache == null) {
            smSpriteObjectCache = new Vector();
        }
        smSpriteObjectCache.addElement(spriteObject);
        return spriteObject;
    }

    public static SpriteObject loadSpriteObject(int n, boolean bl) {
        return Fish.loadSpriteObject(new int[]{n}, bl);
    }

    public static void freeSpriteObjects() {
        if (smSpriteObjectCache != null) {
            for (int i = 0; i < smSpriteObjectCache.size(); ++i) {
                SpriteObject spriteObject = (SpriteObject)smSpriteObjectCache.elementAt(i);
                spriteObject.freeResources();
            }
            smSpriteObjectCache = null;
        }
    }
}

