/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Statistics {
    public static final int PLAYER_WINS = 0;
    public static final int PLAYER_LOOSES = 1;
    public static final int PLAYER_DRAWS = 2;
    public static final int RANKING_EASY = 0;
    public static final int RANKING_MEDIUM = 1;
    public static final int RANKING_HARD = 2;
    public static int smStatsTotalWin;
    public static int smStatsTotalLoose;
    public static int smStatsTotalDraw;
    public static int smStatsTotalKG;
    public static int smStatsTotalFishes;
    public static int smStatsMaxWeightSingleFish;
    public static int smStatsTotalTimePlayed;
    public static int smStatsBestPosEasy;
    public static int smStatsBestPosMedium;
    public static int smStatsBestPosHard;
    public static int smMillisPlayingInMatch;
    public static long smLastMillis;
    public static boolean smSkipMillisCount;

    public static void statsReset() {
        smStatsTotalWin = 0;
        smStatsTotalLoose = 0;
        smStatsTotalDraw = 0;
        smStatsTotalKG = 0;
        smStatsTotalFishes = 0;
        smStatsMaxWeightSingleFish = 0;
        smStatsTotalTimePlayed = 0;
        smStatsBestPosEasy = 100;
        smStatsBestPosMedium = 100;
        smStatsBestPosHard = 100;
    }

    public static void statsLoadRMS(DataInputStream dataInputStream) throws IOException {
        smStatsTotalWin = dataInputStream.readInt();
        smStatsTotalLoose = dataInputStream.readInt();
        smStatsTotalDraw = dataInputStream.readInt();
        smStatsTotalKG = dataInputStream.readInt();
        smStatsTotalFishes = dataInputStream.readInt();
        smStatsMaxWeightSingleFish = dataInputStream.readInt();
        smStatsTotalTimePlayed = dataInputStream.readInt();
        smStatsBestPosEasy = dataInputStream.readInt();
        smStatsBestPosMedium = dataInputStream.readInt();
        smStatsBestPosHard = dataInputStream.readInt();
    }

    public static void statsSaveRMS(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(smStatsTotalWin);
        dataOutputStream.writeInt(smStatsTotalLoose);
        dataOutputStream.writeInt(smStatsTotalDraw);
        dataOutputStream.writeInt(smStatsTotalKG);
        dataOutputStream.writeInt(smStatsTotalFishes);
        dataOutputStream.writeInt(smStatsMaxWeightSingleFish);
        dataOutputStream.writeInt(smStatsTotalTimePlayed);
        dataOutputStream.writeInt(smStatsBestPosEasy);
        dataOutputStream.writeInt(smStatsBestPosMedium);
        dataOutputStream.writeInt(smStatsBestPosHard);
    }

    public static void statsIngameStarts() {
        if (GameEngine.smPlayMode == 0) {
            smMillisPlayingInMatch = 0;
        }
        smLastMillis = System.currentTimeMillis();
        smSkipMillisCount = false;
    }

    public static void statsIngameLogicUpdate() {
        if (GameEngine.smPlayMode == 0) {
            if (smSkipMillisCount) {
                smSkipMillisCount = false;
            } else {
                smMillisPlayingInMatch = (int)((long)smMillisPlayingInMatch + (System.currentTimeMillis() - smLastMillis));
            }
            smLastMillis = System.currentTimeMillis();
        }
    }

    public static void statsIngameCatchesFish(int n) {
        if (GameEngine.smPlayMode == 0) {
            if (n > smStatsMaxWeightSingleFish) {
                smStatsMaxWeightSingleFish = n;
            }
            smStatsTotalKG += n;
            ++smStatsTotalFishes;
        }
    }

    public static void statsTournamentEnds(int n, int n2) {
        if (GameEngine.smPlayMode == 0) {
            switch (n) {
                case 0: {
                    if (n2 >= smStatsBestPosEasy) break;
                    smStatsBestPosEasy = n2 + 1;
                    break;
                }
                case 1: {
                    if (n2 >= smStatsBestPosMedium) break;
                    smStatsBestPosMedium = n2 + 1;
                    break;
                }
                case 2: {
                    if (n2 >= smStatsBestPosHard) break;
                    smStatsBestPosHard = n2 + 1;
                }
            }
        }
    }

    public static void statsIngameEnds(int n) {
        if (GameEngine.smPlayMode == 0) {
            smStatsTotalTimePlayed += smMillisPlayingInMatch / 1000;
            switch (n) {
                case 0: {
                    ++smStatsTotalWin;
                    break;
                }
                case 1: {
                    ++smStatsTotalLoose;
                    break;
                }
                case 2: {
                    ++smStatsTotalDraw;
                }
            }
        }
    }

    public static void statsIngameAborts() {
        if (GameEngine.smPlayMode == 0) {
            smStatsTotalTimePlayed += smMillisPlayingInMatch / 1000;
        }
    }

    public static String[] statsPrintResults() {
        String string;
        String string2 = "" + smStatsTotalTimePlayed % 60;
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = "" + smStatsTotalTimePlayed / 60 % 60).length() == 1) {
            string = "0" + string;
        }
        String string3 = smStatsTotalTimePlayed / 3600 + ":" + string + ":" + string2;
        return new String[]{Toolkit.getText(171) + " " + smStatsTotalWin, Toolkit.getText(173) + " " + smStatsTotalDraw, Toolkit.getText(172) + " " + smStatsTotalLoose, Toolkit.getText(174) + " " + Game.toKg(smStatsTotalKG) + " " + Toolkit.getText(10), Toolkit.getText(175) + " " + smStatsTotalFishes, Toolkit.getText(180) + " " + Game.toKg(smStatsMaxWeightSingleFish) + " " + Toolkit.getText(10), Toolkit.getText(176) + " " + string3, Toolkit.getText(177) + " " + (smStatsBestPosEasy == 100 ? "-" : "" + smStatsBestPosEasy), Toolkit.getText(178) + " " + (smStatsBestPosMedium == 100 ? "-" : "" + smStatsBestPosMedium), Toolkit.getText(179) + " " + (smStatsBestPosHard == 100 ? "-" : "" + smStatsBestPosHard)};
    }
}

