/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class TimelineChannel {
    private int mType;
    private int[] mValue;
    private int[] mTime;
    private int[] mMode;
    private static final int MODE_LINEAR = 0;
    private static final int MODE_CONSTANT = 1;
    private int mDuration;
    public static final int TIMELINE_COLOR_MODIFICATION = 0;
    public static final int TIMELINE_POS_X = 1;
    public static final int TIMELINE_POS_Y = 2;
    public static final int TIMELINE_POS_SCALE_WIDTH = 3;
    public static final int TIMELINE_POS_SCALE_HEIGHT = 4;
    public static final int TIMELINE_POS_ROTATION = 5;
    public static final int TIMELINE_TYPE_COUNT = 6;
    private static final int[] INT_ARRAY_SIZE_0 = new int[0];

    public TimelineChannel(int n, int n2) {
        this.mType = n;
        this.mDuration = n2;
    }

    public void load(DataInputStream dataInputStream, boolean bl) throws IOException {
        int n = dataInputStream.read();
        if (n == 0) {
            this.mValue = INT_ARRAY_SIZE_0;
            this.mTime = INT_ARRAY_SIZE_0;
            this.mMode = INT_ARRAY_SIZE_0;
        } else {
            this.mValue = new int[n];
            this.mTime = new int[n];
            this.mMode = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            this.mTime[i] = n2 = dataInputStream.readInt();
            this.mMode[i] = dataInputStream.read();
            int n3 = -1;
            if (this.mType == 0 || this.mType == 3 || this.mType == 4) {
                n3 = dataInputStream.readInt();
            } else if (this.mType == 1 || this.mType == 2) {
                n3 = bl ? (int)dataInputStream.readByte() : (int)dataInputStream.readShort();
            } else if (this.mType == 5) {
                n3 = dataInputStream.readInt();
                n3 <<= 0;
            }
            this.mValue[i] = n3;
        }
    }

    private int getIndexInTime(int n) {
        int n2 = this.mTime.length;
        while (--n2 >= 0) {
            if (n < this.mTime[n2]) continue;
            return n2;
        }
        return -1;
    }

    private int getNeutralValue() {
        if (this.mType == 0) {
            return -8355712;
        }
        if (this.mType == 3 || this.mType == 4) {
            return 1024;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getValue(int n, boolean bl) {
        if (this.mTime.length == 0) {
            return this.getNeutralValue();
        }
        int n2 = this.getIndexInTime(n);
        if (this.mMode[n2] == 1) {
            return this.mValue[n2];
        }
        n -= this.mTime[n2];
        int n3 = -1;
        int n4 = n2 + 1;
        if (n4 == this.mTime.length) {
            if (!bl) return this.mValue[n2];
            n4 = 0;
            n3 = this.mDuration - this.mTime[n2];
        } else {
            n3 = this.mTime[n4] - this.mTime[n2];
        }
        if (this.mMode[n2] != 0) return -1;
        if (this.mType != 0) return DavinciUtilities.interpolateValue(this.mValue[n2], this.mValue[n4], n, n3);
        return DavinciUtilities.interpolateColor(this.mValue[n2], this.mValue[n4], n, n3);
    }

    public int getEventCount() {
        return this.mTime.length;
    }
}

