/*
 * Decompiled with CFR 0.152.
 */
public class TwistMathLib {
    static final int[] sin_arr = new int[]{173, 342, 500, 642, 766, 866, 939, 984, 1000, 984, 939, 866, 766, 642, 500, 342, 173, 0, -174, -343, -500, -643, -767, -867, -940, -985, -1000, -985, -940, -867, -767, -643, -500, -343, -174, -1, 173, 342};
    static final int[] cos_arr = new int[]{984, 939, 866, 766, 642, 500, 342, 173, 0, -174, -343, -500, -643, -767, -867, -940, -985, -1000, -985, -940, -867, -767, -643, -500, -343, -174, -1, 173, 342, 500, 642, 766, 866, 939, 984, 1000, 984, 939};

    public static int sqrt(int val) {
        int i;
        boolean flag = false;
        if (val == 0) {
            return 0;
        }
        if (val > 1000000000) {
            // empty if block
        }
        if (val < 0) {
            flag = true;
            val *= -1;
        }
        int a2 = 0;
        int b = 0;
        try {
            for (i = 10; i < 1000000000; i *= 10) {
                if (val / i > 1) continue;
                a2 = i / 10;
                b = val / a2;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            for (i = 0; i < 10; ++i) {
                a2 = TwistMathLib.avg(a2, b);
                b = val / a2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (flag) {
            return a2 * -1;
        }
        return a2;
    }

    public static int avg(int x, int y) {
        return (x + y) / 2;
    }

    public static int abs(int a2) {
        if (a2 < 0) {
            return a2 * -1;
        }
        return a2;
    }

    public static int sin(int angle) {
        int angle_mod = (angle /= 10) % 10;
        return sin_arr[angle] + (sin_arr[angle + 1] - sin_arr[angle]) * angle_mod / 10;
    }

    public static int cos(int angle) {
        int angle_mod = (angle /= 10) % 10;
        return cos_arr[angle] + (cos_arr[angle + 1] - cos_arr[angle]) * angle_mod / 10;
    }
}

