/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PNG {
    static int[] crcTable = null;

    public static byte[] toPNG(int width, int height, int[] rbgData) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = PNG.createHeaderChunk(width, height);
        byte[] data = PNG.createDataChunk(width, height, rbgData);
        byte[] trailer = PNG.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        signature = null;
        header = null;
        data = null;
        trailer = null;
        return png.toByteArray();
    }

    public static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return PNG.toChunk("IHDR", baos.toByteArray());
    }

    public static byte[] createDataChunk(int width, int height, int[] rgbData) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        for (int y = 0; y < height; ++y) {
            raw[dest++] = 0;
            for (int x = 0; x < width; ++x) {
                int ARGB = rgbData[source++];
                raw[dest++] = (byte)((ARGB & 0xFF0000) >> 16);
                raw[dest++] = (byte)((ARGB & 0xFF00) >> 8);
                raw[dest++] = (byte)(ARGB & 0xFF);
                raw[dest++] = (byte)((ARGB & 0xFF000000) >> 24);
            }
        }
        return PNG.toChunk("IDAT", PNG.toZLIB(raw));
    }

    public static byte[] createTrailerChunk() throws IOException {
        return PNG.toChunk("IEND", new byte[0]);
    }

    public static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        chunk.write(bid);
        chunk.write(raw);
        int crc = -1;
        crc = PNG.updateCRC(crc, bid);
        crc = PNG.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    public static void createCRCTable() {
        crcTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            PNG.crcTable[i] = c;
        }
    }

    public static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            PNG.createCRCTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static byte[] toZLIB(byte[] raw) throws IOException {
        return ZLIB.toZLIB(raw);
    }
}

