/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.Field;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CustomTextBox
extends Field {
    private Vector strings = new Vector();
    private int fontHeight;
    private int fontColor;
    private boolean SCROLL;
    private int lastEventY;
    private int scrollPosition;
    private int delta;
    private int speed;
    private int begin;
    private boolean inertion;

    private CustomTextBox(int width, int height, int textColor) {
        this.width = width;
        this.height = height;
        this.fontHeight = Font.getDefaultFont().getHeight();
        this.fontColor = textColor;
    }

    public void onPaint(Graphics g) {
        g.setColor(this.fontColor);
        g.setFont(Font.getFont((int)0, (int)0, (int)16));
        g.clipRect(this.left, this.top, this.width, this.height);
        for (int i = 0; i < this.strings.size(); ++i) {
            int y = this.top + i * this.fontHeight - this.scrollPosition;
            if (y > this.top + this.height || y + this.fontHeight < this.top) continue;
            String s = (String)this.strings.elementAt(i);
            g.drawString(s, this.left, y, 20);
        }
    }

    public void onIdle() {
        if (this.inertion && this.begin > 10) {
            if (this.delta > 0) {
                this.scrollPosition -= this.speed * 2;
            } else if (this.delta < 0) {
                this.scrollPosition += this.speed * 2;
            }
            if (this.scrollPosition < 0) {
                this.scrollPosition = 0;
            } else if (this.scrollPosition > this.getMaxPosition()) {
                this.scrollPosition = this.getMaxPosition();
            }
            --this.speed;
            if (this.speed == 0) {
                this.inertion = false;
            }
            this.repaint(this.left, this.top, this.width, this.height);
        }
    }

    public void append(String text) {
        this.strings.addElement(text);
    }

    private int getMaxPosition() {
        return this.fontHeight * this.strings.size() - this.height / 2;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.SCROLL = true;
                this.lastEventY = eventY;
                this.begin = eventY;
                this.inertion = false;
                break;
            }
            case 1: {
                this.SCROLL = false;
                if (this.delta > 1 || this.delta < -1) {
                    this.inertion = true;
                    this.speed = 10;
                }
                this.begin = eventY - this.begin;
                if (this.begin >= 0) break;
                this.begin *= -1;
                break;
            }
            case 3: {
                if (!this.SCROLL) {
                    return false;
                }
                this.delta = eventY - this.lastEventY;
                this.scrollPosition -= this.delta;
                this.lastEventY = eventY;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                } else if (this.scrollPosition > this.getMaxPosition()) {
                    this.scrollPosition = this.getMaxPosition();
                }
                this.repaint(this.left, this.top, this.width, this.height);
            }
        }
        return !out;
    }

    public void setInertion(boolean inertion) {
        this.inertion = inertion;
    }
}

