/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.XYPoint;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.res.ImagesResources;

public class imgConst {
    private int init_x;
    private int init_y;
    private XYPoint img_point;
    private int curr_number = -1;
    private int alignment = 1;
    private boolean reverce_order = false;
    private boolean elt_state = true;
    private int all_w = 0;
    private Bitmap[] labels;
    private Bitmap[] digits;
    private Bitmap[] img_bmp;

    public imgConst(Bitmap[] lbls, int number, int x, int y, int new_alignment) {
        this.labels = lbls;
        this.curr_number = number;
        this.init_x = x;
        this.init_y = y;
        this.alignment = new_alignment;
        this.buildImagesSequence();
    }

    public imgConst(int number, int x, int y, int new_alignment) {
        this.labels = new Bitmap[0];
        this.curr_number = number;
        this.init_x = x;
        this.init_y = y;
        this.alignment = new_alignment;
        this.buildImagesSequence();
    }

    public imgConst(Bitmap lbl, int number, int x, int y, int new_alignment) {
        this.labels = new Bitmap[1];
        this.labels[0] = lbl;
        this.curr_number = number;
        this.init_x = x;
        this.init_y = y;
        this.alignment = new_alignment;
        this.buildImagesSequence();
    }

    public imgConst(Bitmap lbl, int x, int y) {
        this.labels = new Bitmap[1];
        this.labels[0] = lbl;
        this.curr_number = -1;
        this.init_x = x;
        this.init_y = y;
        this.buildImagesSequence();
    }

    public boolean getEltState() {
        return this.elt_state;
    }

    public void setEltState(boolean new_state) {
        this.elt_state = new_state;
    }

    public Bitmap[] get_bitmap() {
        return this.img_bmp;
    }

    public void setLogo(Bitmap newLogo) {
        this.labels[this.labels.length - 1] = newLogo;
        this.buildImagesSequence();
    }

    public int get_label_width() {
        return this.labels[this.labels.length - 1].getWidth();
    }

    public int get_label_height() {
        return this.labels[this.labels.length - 1].getHeight();
    }

    public XYPoint getImgPoint() {
        return this.img_point;
    }

    public void setImgPoint(int x, int y) {
        this.img_point.set(x, y);
    }

    public void setAlignment(int new_align) {
        this.alignment = new_align;
        this.updateCoords();
    }

    public void setOrder(boolean new_order) {
        this.reverce_order = new_order;
        this.buildImagesSequence();
    }

    public int getNumber() {
        return this.curr_number;
    }

    public void setNumber(int new_number) {
        this.curr_number = new_number;
        this.buildImagesSequence();
    }

    private void buildImagesSequence() {
        this.all_w = 0;
        if (this.curr_number != -1) {
            String tmp_string = "" + this.curr_number;
            this.digits = new Bitmap[tmp_string.length()];
            for (int i = 0; i < tmp_string.length(); ++i) {
                int tmp_digit = Integer.parseInt(tmp_string.substring(i, i + 1));
                this.digits[i] = ImagesResources.font_white[tmp_digit];
            }
        } else {
            this.digits = new Bitmap[0];
        }
        this.img_bmp = new Bitmap[this.digits.length + this.labels.length];
        if (this.reverce_order) {
            for (int i = 0; i < this.img_bmp.length; ++i) {
                if (i < this.digits.length) {
                    this.img_bmp[i] = this.digits[i];
                    this.all_w += this.digits[i].getWidth();
                    continue;
                }
                this.img_bmp[i] = this.labels[i - this.digits.length];
                this.all_w += this.labels[i - this.digits.length].getWidth();
            }
        } else {
            for (int i = 0; i < this.img_bmp.length; ++i) {
                if (i < this.labels.length) {
                    this.img_bmp[i] = this.labels[i];
                    this.all_w += this.labels[i].getWidth();
                    continue;
                }
                this.img_bmp[i] = this.digits[i - this.labels.length];
                this.all_w += this.digits[i - this.labels.length].getWidth();
            }
        }
        this.updateCoords();
    }

    private void updateCoords() {
        this.img_point = new XYPoint();
        if (this.alignment == 1) {
            this.img_point.set(this.init_x, this.init_y);
        } else if (this.alignment == 3) {
            this.img_point.set(this.init_x - this.all_w / 2, this.init_y);
        } else if (this.alignment == 2) {
            this.img_point.set(this.init_x - this.all_w, this.init_y);
        }
    }
}

