/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.game;

import com.ximad.bubble_birds_2.component.LevelData;
import com.ximad.bubble_birds_2.component.Scoreboard;
import com.ximad.bubble_birds_2.game.AppSettings;
import com.ximad.bubble_birds_2.screen.SettingsScreen;
import com.ximad.bubble_birds_2.utils.Utils;

public class DataManager {
    private static AppSettings appSettings;
    private static int gameSpeed;
    private static boolean isSoundEnabled;
    private static Scoreboard[] scoreboard;
    public static LevelData levelData;
    private static int currentSoundLevel;
    private static int prevSoundLevel;
    public static boolean isRated;
    public static int launchNumber;
    public static boolean isAdPopupNeeded;
    public static boolean isVideoAdReady;
    public static int playedGamesNumber;
    public static boolean shop_flag;
    public static boolean game_flag;

    public DataManager() {
        appSettings = new AppSettings();
        appSettings.init("bubble_birds_2.0.0_360x640");
        DataManager.setDefaultSettings();
        DataManager.loadSettings();
    }

    public static void setDefaultSettings() {
        scoreboard = new Scoreboard[10];
        for (int i = 0; i < scoreboard.length; ++i) {
            DataManager.scoreboard[i] = new Scoreboard();
        }
        isSoundEnabled = true;
        levelData = new LevelData();
        isRated = false;
        launchNumber = 1;
        gameSpeed = 1;
        isAdPopupNeeded = true;
        isVideoAdReady = false;
        playedGamesNumber = 0;
        shop_flag = false;
        game_flag = false;
        currentSoundLevel = 50;
        DataManager.setCurrentSoundLvl(currentSoundLevel);
    }

    public static boolean loadSettings() {
        try {
            if (appSettings.containsItem("GameSpeed")) {
                gameSpeed = (Integer)appSettings.getItem("GameSpeed");
            }
            if (appSettings.containsItem("SoundState")) {
                isSoundEnabled = (Boolean)appSettings.getItem("SoundState");
            }
            for (int i = 0; i < scoreboard.length && appSettings.containsItem("Score_name_" + i); ++i) {
                scoreboard[i].setName("" + appSettings.getItem("Score_name_" + i));
                scoreboard[i].setScore(Integer.parseInt("" + appSettings.getItem("Score_value_" + i)));
            }
            if (appSettings.containsItem("IsRated")) {
                isRated = (Boolean)appSettings.getItem("IsRated");
            }
            if (appSettings.containsItem("LnchNmb")) {
                launchNumber = (Integer)appSettings.getItem("LnchNmb") + 1;
            }
            if (appSettings.containsItem("shpFlag")) {
                shop_flag = (Boolean)appSettings.getItem("shpFlag");
            }
            if (appSettings.containsItem("gameFlag")) {
                game_flag = (Boolean)appSettings.getItem("gameFlag");
            }
            if (appSettings.containsItem("sndLvl")) {
                currentSoundLevel = (Integer)appSettings.getItem("sndLvl");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void saveSettings() {
        try {
            appSettings.setItem("GameSpeed", new Integer(gameSpeed));
            appSettings.setItem("SoundState", new Boolean(isSoundEnabled));
            appSettings.setItem("IsRated", new Boolean(isRated));
            appSettings.setItem("shpFlag", new Boolean(shop_flag));
            appSettings.setItem("gameFlag", new Boolean(game_flag));
            appSettings.setItem("sndLvl", new Integer(currentSoundLevel));
            appSettings.setItem("LnchNmb", new Integer(launchNumber));
            for (int i = 0; i < 10 && scoreboard[i].getScore() > 0; ++i) {
                appSettings.setItem("Score_name_" + i, new String(scoreboard[i].getName()));
                appSettings.setItem("Score_value_" + i, new Integer(scoreboard[i].getScore()));
            }
            appSettings.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean loadLevel() {
        try {
            if (!appSettings.containsItem("LevelData")) {
                return false;
            }
            levelData.copy((LevelData)appSettings.getItem("LevelData"));
        }
        catch (Exception e) {
            Utils.log("Load level error:   " + e.toString());
        }
        return true;
    }

    public static void saveLevel() {
        try {
            appSettings.setItem("LevelData", levelData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeLevelData() {
        levelData = new LevelData();
        shop_flag = false;
        game_flag = false;
        appSettings.removeItem("LevelData");
        appSettings.commit();
    }

    public static boolean isSavedGameEnabled() {
        return appSettings.containsItem("LevelData");
    }

    public static int getGameSpeed() {
        return gameSpeed;
    }

    public static void setGameSpeed(int value) {
        gameSpeed = value;
    }

    public static void changeSoundState() {
        if (isSoundEnabled) {
            prevSoundLevel = currentSoundLevel;
            DataManager.setCurrentSoundLvl(0);
        } else {
            DataManager.setCurrentSoundLvl(prevSoundLevel);
        }
        DataManager.onChangeVolume();
    }

    private static void onChangeVolume() {
        SettingsScreen.getInstance().onVolumeChange();
    }

    public static boolean getSoundState() {
        return isSoundEnabled;
    }

    public static void setSoundState(boolean state) {
        isSoundEnabled = state;
    }

    public static int getCurrentSoundLvl() {
        return currentSoundLevel;
    }

    public static void setCurrentSoundLvl(int lvl) {
        currentSoundLevel = lvl;
    }

    public static Scoreboard getScoreboardRow(int i) {
        return scoreboard[i];
    }

    public static void setScoreboardRow(int rowIndex, String name, int score) {
        scoreboard[rowIndex].setName(name);
        scoreboard[rowIndex].setScore(score);
    }

    public static int getPlayerPosition(int score) {
        for (int i = 0; i < scoreboard.length; ++i) {
            if (score < scoreboard[i].getScore()) continue;
            return i;
        }
        return -1;
    }

    public static void addResultToScoreboard(String name, int score) {
        int playerPos = DataManager.getPlayerPosition(score);
        for (int i = scoreboard.length - 1; i > playerPos; --i) {
            scoreboard[i].setName(scoreboard[i - 1].getName());
            scoreboard[i].setScore(scoreboard[i - 1].getScore());
        }
        scoreboard[playerPos].setName(name);
        scoreboard[playerPos].setScore(score);
    }

    public static void clearScores() {
        for (int i = 0; i < scoreboard.length; ++i) {
            scoreboard[i].setName("");
            scoreboard[i].setScore(0);
        }
        DataManager.saveSettings();
    }

    public static void stopSound() {
    }

    static {
        prevSoundLevel = 10;
    }
}

