/*
 * Decompiled with CFR 0.152.
 */
package sheet;

class Operand {
    private static final byte EMPTY = 0;
    private static final byte TEXT = 1;
    private static final byte NUMBER = 2;
    private static final byte NAME = 3;
    private byte type;
    private String text;
    private int number;

    Operand(int n) {
        this.number = n;
        this.type = (byte)2;
        this.text = String.valueOf(n);
    }

    Operand(String string) {
        int n = string.length();
        if (n == 0) {
            this.text = "";
            this.type = 0;
        } else if (string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            this.text = string.substring(1, n - 1);
            this.type = 1;
        } else {
            this.text = string;
            try {
                this.number = Integer.parseInt(this.text);
                this.type = (byte)2;
            }
            catch (NumberFormatException numberFormatException) {
                this.type = (byte)3;
            }
        }
    }

    Operand(String string, boolean bl) {
        if (string.length() == 0) {
            this.text = string;
            this.type = 0;
        } else {
            this.text = string;
            if (bl) {
                try {
                    this.number = Integer.parseInt(this.text);
                    this.type = (byte)2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.type = 1;
                }
            } else {
                this.type = 1;
            }
        }
    }

    static final boolean isNumber(Operand operand) {
        return operand == null || operand.type == 0 || operand.type == 2;
    }

    static final boolean isName(Operand operand) {
        return operand != null && operand.type == 3;
    }

    static final int getNumber(Operand operand) throws NumberFormatException {
        if (operand == null) {
            return 0;
        }
        switch (operand.type) {
            case 2: {
                return operand.number;
            }
            case 0: {
                return 0;
            }
        }
        throw new NumberFormatException("Not a number: '" + operand.text + "'");
    }

    static final String getText(Operand operand) throws NumberFormatException {
        if (operand == null) {
            return "";
        }
        if (operand.type != 3) {
            return operand.text;
        }
        throw new NumberFormatException("Not a text: '" + operand.text + "'");
    }

    static final String getName(Operand operand) throws NumberFormatException {
        if (operand == null) {
            throw new NumberFormatException("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        if (operand.type == 3) {
            return operand.text;
        }
        throw new NumberFormatException("Not a name: '" + operand.text + "'");
    }
}

