/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.io;

import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.platform.PMCanvas;
import java.io.DataInputStream;
import java.io.InputStream;

public class PMFile {
    public static DataInputStream dis = null;
    public static int fileLen;
    public static boolean loadScreen;
    public static int currentOffset;
    public static int currentBin;
    public static int currentFile;
    public static boolean cachedFile;
    public static byte[][] fileByteCaching;
    public static int readingFromArrayPos;
    public static short[] filesCRC;
    public static byte[] filesCache;
    public static int[] filesOffset;
    public static byte[] filesBin;
    public static int[] filesLen;
    public static int fileCount;
    private static int poly;
    private static int[] crcTable;

    public static int fileNumber(short s) {
        for (int i = 0; i < fileCount; ++i) {
            if (filesCRC[i] != s) continue;
            return i;
        }
        PMDebug.println(1, "PMFile.fileNumber(): WARNING! Unable to find file [{0}] in the bfc. Check /res/bfc.log to make sure the file is in the build.", s);
        return -1;
    }

    public static boolean fileExists(String string) {
        return PMFile.fileNumber(PMFile.calcCRC(string)) != -1;
    }

    public static void initFileCache(int n) {
        fileByteCaching = new byte[n][];
        cachedFile = false;
    }

    public static void cacheFile(int n) {
        try {
            currentFile = n;
            cachedFile = true;
            readingFromArrayPos = 0;
            PMFile.fileByteCaching[n] = new byte[fileLen];
            int n2 = 0;
            int n3 = 0;
            int n4 = fileLen;
            while (n4 > 0) {
                n2 = dis.read(fileByteCaching[n], n3, n4);
                n4 -= n2;
                n3 += n2;
            }
            for (int i = 0; i < fileCount; ++i) {
                if (i == n || filesOffset[i] != filesOffset[n] || filesBin[i] != filesBin[n]) continue;
                PMFile.fileByteCaching[i] = fileByteCaching[n];
            }
            currentOffset += fileLen;
        }
        catch (Exception exception) {
            PMDebug.println("PMFile.cacheFile(): Exception!");
        }
    }

    public static void initBFC() {
        currentBin = -1;
        currentOffset = 0;
        PMFile.initCRC();
        try {
            int n;
            String string = "/head.bfc";
            dis = new DataInputStream(string.getClass().getResourceAsStream(string));
            fileCount = n = dis.readUnsignedShort();
            filesCRC = new short[n];
            filesCache = new byte[n];
            filesOffset = new int[n];
            filesBin = new byte[n];
            filesLen = new int[n];
            for (int i = 0; i < n; ++i) {
                PMFile.filesCRC[i] = (short)dis.readUnsignedShort();
                PMFile.filesCache[i] = dis.readByte();
                PMFile.filesOffset[i] = dis.readUnsignedByte() << 16 | dis.readUnsignedByte() << 8 | dis.readUnsignedByte();
                PMFile.filesBin[i] = (byte)dis.readUnsignedByte();
                PMFile.filesLen[i] = fileLen = dis.readUnsignedByte() << 16 | dis.readUnsignedByte() << 8 | dis.readUnsignedByte();
            }
        }
        catch (Exception exception) {
            PMDebug.println("PMFile.cacheFile(): Exception!");
        }
        PMFile.initFileCache(fileCount);
    }

    public static void initCRC() {
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            int n2 = i << 8;
            for (int j = 0; j < 8; ++j) {
                n = ((n ^ n2) & 0x8000) != 0 ? n << 1 ^ poly : (n <<= 1);
                n2 <<= 1;
                n &= 0xFFFF;
            }
            PMFile.crcTable[i] = n;
        }
    }

    public static short calcCRC(String string) {
        int n = 65535;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c >> 8);
            n = (crcTable[(by ^ n >> 8) & 0xFF] ^ n << 8) & 0xFFFF;
            by = (byte)(c & 0xFF);
            n = (crcTable[(by ^ n >> 8) & 0xFF] ^ n << 8) & 0xFFFF;
        }
        return (short)(n & 0xFFFF);
    }

    public static byte[] fileToByteArray(String string) {
        return PMFile.fileToByteArray(PMFile.calcCRC(string));
    }

    public static byte[] fileToByteArray(short s) {
        if (!PMFile.openFile(s)) {
            PMDebug.println("PMFile.fileToByteArray(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
            return null;
        }
        byte[] byArray = new byte[fileLen];
        PMFile.read(byArray, 0, fileLen);
        return byArray;
    }

    public static byte[] fileToConstByteArray(String string) {
        return PMFile.fileToConstByteArray(PMFile.calcCRC(string));
    }

    public static byte[] fileToConstByteArray(short s) {
        int n = PMFile.fileNumber(s);
        if (n < 0) {
            return null;
        }
        if (fileByteCaching[n] != null) {
            return fileByteCaching[n];
        }
        return PMFile.fileToByteArray(s);
    }

    public static short[] fileToShortArray(String string) {
        return PMFile.fileToShortArray(PMFile.calcCRC(string));
    }

    public static short[] fileToShortArray(short s) {
        if (!PMFile.openFile(s)) {
            PMDebug.println("PMFile.fileToShortArray(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
            return null;
        }
        short[] sArray = new short[fileLen / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = PMFile.readShort();
        }
        return sArray;
    }

    public static int[] fileToIntArray(String string) {
        return PMFile.fileToIntArray(PMFile.calcCRC(string));
    }

    public static int[] fileToIntArray(short s) {
        if (!PMFile.openFile(s)) {
            PMDebug.println("PMFile.fileToShortArray(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
            return null;
        }
        int[] nArray = new int[fileLen / 4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = PMFile.readInt();
        }
        return nArray;
    }

    public static boolean openFile(String string) {
        short s = PMFile.calcCRC(string);
        boolean bl = PMFile.openFile(s);
        if (bl) {
            return true;
        }
        try {
            PMDebug.println("PMFile.openFile(): WARNING! Failed to open file from the bfc. Trying to open it in the jar file.");
            InputStream inputStream = null;
            inputStream = string.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                return false;
            }
            dis = new DataInputStream(inputStream);
        }
        catch (Exception exception) {
            PMDebug.println("PMFile.openFile(): ERROR! File not found in jar.");
            return false;
        }
        return true;
    }

    public static int getFileSize(short s) {
        int n = PMFile.fileNumber(s);
        if (n >= 0) {
            return filesLen[n];
        }
        return 0;
    }

    public static boolean sameFile(String string, String string2) {
        return PMFile.sameFile(PMFile.calcCRC(string), PMFile.calcCRC(string2));
    }

    public static boolean sameFile(short s, short s2) {
        int n;
        int n2 = PMFile.fileNumber(s);
        return filesBin[n2] == filesBin[n = PMFile.fileNumber(s2)] && filesOffset[n2] == filesOffset[n];
    }

    public static int shareData(short s) {
        int n = PMFile.fileNumber(s);
        for (int i = 0; i < fileCount; ++i) {
            if (n == i || filesBin[n] != filesBin[i] || filesOffset[n] != filesOffset[i]) continue;
            return i;
        }
        return -1;
    }

    public static short[] getRelatives(short s) {
        int n = PMFile.fileNumber(s);
        int n2 = 0;
        for (int i = 0; i < fileCount; ++i) {
            if (filesBin[n] != filesBin[i] || filesOffset[n] != filesOffset[i]) continue;
            ++n2;
        }
        short[] sArray = new short[n2];
        n2 = 0;
        for (int i = 0; i < fileCount; ++i) {
            if (filesBin[n] != filesBin[i] || filesOffset[n] != filesOffset[i]) continue;
            sArray[n2] = filesCRC[i];
            ++n2;
        }
        return sArray;
    }

    public static String toHexString(short s) {
        String string = Integer.toHexString(s).toUpperCase();
        if (string.length() > 4) {
            string = string.substring(string.length() - 4);
        }
        while (string.length() < 4) {
            string = "0" + string;
        }
        return "0x" + string;
    }

    public static boolean openFile(short s) {
        int n;
        if (loadScreen) {
            PMCanvas.drawLoading();
        }
        currentFile = n = PMFile.fileNumber(s);
        readingFromArrayPos = 0;
        cachedFile = false;
        if (n >= 0 && fileByteCaching[n] != null) {
            fileLen = filesLen[n];
            cachedFile = true;
            return true;
        }
        if (n != -1) {
            fileLen = filesLen[n];
            if (currentBin == filesBin[n] && currentOffset <= filesOffset[n]) {
                PMFile.skip(filesOffset[n] - currentOffset);
                if (filesCache[n] >= 0 && fileByteCaching[n] == null) {
                    PMFile.cacheFile(n);
                }
                return true;
            }
            try {
                if (dis != null) {
                    PMFile.forceClose();
                }
                dis = new DataInputStream(PMCanvas.thisCanvas.getClass().getResourceAsStream("/" + filesBin[n] + ".bfc"));
                dis.skip(filesOffset[n]);
                currentBin = filesBin[n];
                currentOffset = filesOffset[n];
                if (filesCache[n] >= 0 && fileByteCaching[n] == null) {
                    PMFile.cacheFile(n);
                }
                return true;
            }
            catch (Exception exception) {
                PMDebug.println("PMFile.openFile(): ERROR! Exception caught.");
            }
        }
        return false;
    }

    public static void skip(int n) {
        if (cachedFile) {
            readingFromArrayPos += n;
        } else {
            currentOffset += n;
            try {
                while (n > 0) {
                    n = (int)((long)n - dis.skip(n));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] read(byte[] byArray, int n, int n2) {
        if (cachedFile) {
            System.arraycopy(fileByteCaching[currentFile], readingFromArrayPos, byArray, n, n2);
            readingFromArrayPos += n2;
            return byArray;
        }
        currentOffset += n2;
        try {
            int n3 = 0;
            while (n2 > 0) {
                n3 = dis.read(byArray, n, n2);
                n2 -= n3;
                n += n3;
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int readUnsignedShort() {
        if (cachedFile) {
            int n = (fileByteCaching[currentFile][readingFromArrayPos] & 0xFF) << 8 | fileByteCaching[currentFile][readingFromArrayPos + 1] & 0xFF;
            readingFromArrayPos += 2;
            return n;
        }
        currentOffset += 2;
        try {
            return dis.readUnsignedShort();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static short readShort() {
        if (cachedFile) {
            short s = (short)(fileByteCaching[currentFile][readingFromArrayPos] << 8 | fileByteCaching[currentFile][readingFromArrayPos + 1] & 0xFF);
            readingFromArrayPos += 2;
            return s;
        }
        currentOffset += 2;
        try {
            return dis.readShort();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int readUnsignedByte() {
        if (cachedFile) {
            int n = fileByteCaching[currentFile][readingFromArrayPos] & 0xFF;
            ++readingFromArrayPos;
            return n;
        }
        ++currentOffset;
        try {
            return dis.readUnsignedByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static byte readByte() {
        if (cachedFile) {
            byte by = fileByteCaching[currentFile][readingFromArrayPos];
            ++readingFromArrayPos;
            return by;
        }
        ++currentOffset;
        try {
            return dis.readByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int readInt() {
        if (cachedFile) {
            int n = (fileByteCaching[currentFile][readingFromArrayPos] & 0xFF) << 24 | (fileByteCaching[currentFile][readingFromArrayPos + 1] & 0xFF) << 16 | (fileByteCaching[currentFile][readingFromArrayPos + 2] & 0xFF) << 8 | fileByteCaching[currentFile][readingFromArrayPos + 3] & 0xFF;
            readingFromArrayPos += 4;
            return n;
        }
        currentOffset += 4;
        try {
            return dis.readInt();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void forceClose() {
        try {
            dis.close();
            currentFile = -1;
            currentBin = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        dis = null;
    }

    public static void closeFile() {
    }

    static {
        loadScreen = false;
        currentOffset = -1;
        currentBin = -1;
        currentFile = -1;
        readingFromArrayPos = 0;
        poly = 4129;
        crcTable = new int[256];
    }
}

