/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.system;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.getmoregames.StateGetMoreGames;
import dk.progressivemedia.skeleton.j2memenus.StateAudioOnOff;
import dk.progressivemedia.skeleton.j2memenus.StateLanguageSelect;
import dk.progressivemedia.skeleton.menu.StateCutscene;
import dk.progressivemedia.skeleton.menu.StateDemoScreen;
import dk.progressivemedia.skeleton.menu.StateGameover;
import dk.progressivemedia.skeleton.menu.StateLevelSelection;
import dk.progressivemedia.skeleton.menu.StateSlotSelection;
import dk.progressivemedia.skeleton.menu.StateSplash;

public class PMStateManager {
    public static final int STATE_StateSplash = 0;
    public static final int STATE_StateSlotSelection = 1;
    public static final int STATE_StateLevelSelection = 2;
    public static final int STATE_StateGameover = 3;
    public static final int STATE_StateCutscene = 4;
    public static final int STATE_StateGame = 5;
    public static final int STATE_StateDemoScreen = 6;
    public static final int STATE_StateAudioOnOff = 7;
    public static final int STATE_StateLanguageSelect = 8;
    public static final int STATE_StateGetMoreGames = 9;
    public static final int TYPE_INTRO = 0;
    public static final int TYPE_UPDATE = 1;
    public static final int TYPE_OUTRO = 2;
    public static final int EXIT_GAME = -1;
    public static final int INIT_GAME = -2;
    public static boolean rotated = false;
    public static boolean newState = true;
    public static int lastState;
    public static int currentState;
    public static int nextState;
    public static int parameter;

    public static void start() {
        Main.init();
        PMSystem.externalPause = false;
        do {
            PMSystem.internalLoop = false;
            PMStateManager.checkIncorrectRotation();
            if (rotated) {
                PMStateManager.checkCorrectRotation();
                PMCanvas.PMInput_reset();
                continue;
            }
            if (PMSystem.externalPause) {
                PMDebug.println("Waiting for user to return from external event...");
                Main.drawExternal();
                PMCanvas.PMGraphics_flush();
                PMCanvas.PMInput_readKeys();
                if (!PMCanvas.PMInput_isReleased(1)) continue;
                PMSystem.externalPause = false;
                continue;
            }
            if (newState) {
                PMDebug.println("PMStateManager.start(): new state [" + nextState + "]");
                PMStateManager.execute(currentState, 2);
                lastState = currentState;
                newState = false;
                currentState = nextState;
                PMStateManager.execute(currentState, 0);
                PMCanvas.PMInput_reset();
                continue;
            }
            PMStateManager.execute(currentState, 1);
        } while (currentState != -1);
        PMDebug.println("Exiting game");
        PMAudio.stopAll();
        PMAudio.update();
    }

    public static void set(int n, int n2) {
        PMDebug.println("PMStateManager.set(): " + n);
        if (newState) {
            PMDebug.println("PMStateManager.set(): WARNING! Setting state twice in one frame.");
        }
        nextState = n;
        parameter = n2;
        newState = true;
    }

    public static void execute(int n, int n2) {
        if (n < 0) {
            return;
        }
        try {
            block1 : switch (n) {
                case 0: {
                    switch (n2) {
                        case 1: {
                            StateSplash.update();
                            break block1;
                        }
                        case 0: {
                            StateSplash.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateSplash.deinit();
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 1: {
                            StateSlotSelection.update();
                            break block1;
                        }
                        case 0: {
                            StateSlotSelection.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateSlotSelection.deinit();
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 1: {
                            StateLevelSelection.update();
                            break block1;
                        }
                        case 0: {
                            StateLevelSelection.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateLevelSelection.deinit();
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n2) {
                        case 1: {
                            StateGameover.update();
                            break block1;
                        }
                        case 0: {
                            StateGameover.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateGameover.deinit();
                        }
                    }
                    break;
                }
                case 4: {
                    switch (n2) {
                        case 1: {
                            StateCutscene.update();
                            break block1;
                        }
                        case 0: {
                            StateCutscene.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateCutscene.deinit();
                        }
                    }
                    break;
                }
                case 5: {
                    switch (n2) {
                        case 1: {
                            StateGame.update();
                            break block1;
                        }
                        case 0: {
                            StateGame.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateGame.deinit();
                        }
                    }
                    break;
                }
                case 6: {
                    switch (n2) {
                        case 1: {
                            StateDemoScreen.update();
                            break block1;
                        }
                        case 0: {
                            StateDemoScreen.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateDemoScreen.deinit();
                        }
                    }
                    break;
                }
                case 7: {
                    switch (n2) {
                        case 1: {
                            StateAudioOnOff.update();
                            break block1;
                        }
                        case 0: {
                            StateAudioOnOff.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateAudioOnOff.deinit();
                        }
                    }
                    break;
                }
                case 8: {
                    switch (n2) {
                        case 1: {
                            StateLanguageSelect.update();
                            break block1;
                        }
                        case 0: {
                            StateLanguageSelect.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateLanguageSelect.deinit();
                        }
                    }
                    break;
                }
                case 9: {
                    switch (n2) {
                        case 1: {
                            StateGetMoreGames.update();
                            break block1;
                        }
                        case 0: {
                            StateGetMoreGames.init(parameter);
                            break block1;
                        }
                        case 2: {
                            StateGetMoreGames.deinit();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            currentState = -1;
        }
    }

    public static void checkIncorrectRotation() {
        if (PMCanvas.thisCanvas.getWidth() < PMCanvas.thisCanvas.getHeight()) {
            PMAudio.stopAll();
            PMAudio.update();
            PMCanvas.PMGraphics_setColor(0);
            PMCanvas.PMGraphics_setClip(0, 0, PMCanvas.thisCanvas.getWidth(), PMCanvas.thisCanvas.getHeight());
            PMCanvas.PMGraphics_fillRect(0, 0, PMCanvas.thisCanvas.getWidth(), PMCanvas.thisCanvas.getHeight());
            Main.drawIncorrectRotation();
            PMCanvas.PMGraphics_flush();
            rotated = true;
        }
    }

    public static void checkCorrectRotation() {
        if (PMCanvas.thisCanvas.getWidth() > PMCanvas.thisCanvas.getHeight()) {
            PMCanvas.PMGraphics_setClip(0, 0, 640, 360);
            PMCanvas.PMGraphics_setColor(0);
            PMCanvas.PMGraphics_fillRect(0, 0, 640, 360);
            PMCanvas.PMGraphics_flush();
            rotated = false;
            PMSystem.externalPause = false;
        }
    }

    static {
        currentState = -2;
    }
}

