/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class Camera {
    private PixelineData mData;
    private Vector2 mTranslationFP;
    private int mWorldStart;
    private int mWorldEnd;
    private int mWorldTop;
    private int mClampHeight;
    private int mWorldHeight;
    private int mCurrentOffset;
    private static final int STATE_LEFT = 0;
    private static final int STATE_CENTER = 1;
    private static final int STATE_RIGHT = 2;
    private int mState;
    private int mStartOffset;
    private int mDelta;
    private int mInterp;

    public Camera(PixelineData pixelineData, int n, int n2, int n3) {
        this.mData = pixelineData;
        this.mTranslationFP = new Vector2();
        Vector2 vector2 = this.mData.getPositionRef();
        this.mTranslationFP.set(vector2.mX - 0x800000, vector2.mY - 0x480000);
        this.mWorldStart = n;
        this.mWorldEnd = n2 - 0x1000000;
        this.mWorldTop = 0;
        this.mWorldHeight = n3;
        this.mClampHeight = n3 - 0x900000;
        this.mCurrentOffset = 0;
        this.mStartOffset = 0;
        this.mDelta = 0;
        this.mInterp = 0;
        this.mState = 1;
    }

    public void update() {
        if (this.mData.isAlive()) {
            Vector2 vector2 = this.mData.getPositionRef();
            Vector2 vector22 = this.mData.getVelocityRef();
            if (vector22.mX <= -(this.mData.getRunSpeedMax() >> 1) || InputProxy.isHeldLeft()) {
                if (this.mState != 0) {
                    this.mStartOffset = this.mCurrentOffset;
                    this.mDelta = -3276800 - this.mStartOffset;
                    this.mInterp = 0;
                    this.mState = 0;
                }
            } else if (vector22.mX >= this.mData.getRunSpeedMax() >> 1 || InputProxy.isHeldRight()) {
                if (this.mState != 2) {
                    this.mStartOffset = this.mCurrentOffset;
                    this.mDelta = 0x320000 - this.mStartOffset;
                    this.mInterp = 0;
                    this.mState = 2;
                }
            } else if (this.mState != 1) {
                this.mStartOffset = this.mCurrentOffset;
                this.mDelta = -this.mStartOffset;
                this.mInterp = 0;
                this.mState = 1;
            }
            if (this.mInterp < 65536) {
                this.mInterp += 1745 * Timer.mDt >> 6;
                this.mCurrentOffset = this.mStartOffset + MathUtil.smoothStep(this.mInterp, this.mDelta);
            }
            int n = 0x190000 + PMMath.MUL(65536 - PMMath.DIV(vector2.mY, this.mWorldHeight), 0x240000);
            int n2 = vector2.mX - 0x800000 + this.mCurrentOffset;
            int n3 = vector2.mY - 0x800000 + n;
            n2 = MathUtil.clamp(n2, this.mWorldStart, this.mWorldEnd);
            n3 = MathUtil.clamp(n3, this.mWorldTop, this.mClampHeight);
            this.mTranslationFP.set(n2, n3);
        }
    }

    public Vector2 getTranslationFPRef() {
        return this.mTranslationFP;
    }

    public static boolean isInside(int n, int n2, int n3, int n4) {
        return n + n3 >= 0 && 640 > n && n2 + n4 >= 0 && 360 > n2;
    }
}

