/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMRandom;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.GameTileMapping;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.PlatformView;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.math.Vector2;

public class PlatformViewStatic
extends PlatformView {
    private int[] mTilemap;
    private int[] mTilemapSlippery;

    public PlatformViewStatic(PlatformData platformData) {
        this.mData = platformData;
        Surface surface = this.mData.getSurface();
        switch (this.mData.getSize()) {
            case 0: {
                this.mTilemap = new int[2];
                this.mTilemap[0] = this.getRandomStartTile();
                this.mTilemap[1] = this.getRandomEndTile();
                if (!surface.getSlippery()) break;
                this.mTilemapSlippery = new int[2];
                this.mTilemapSlippery[0] = 0;
                this.mTilemapSlippery[1] = 1;
                break;
            }
            case 1: {
                this.mTilemap = new int[3];
                this.mTilemap[0] = this.getRandomStartTile();
                this.mTilemap[1] = this.getRandomMiddleTile();
                this.mTilemap[2] = this.getRandomEndTile();
                if (!surface.getSlippery()) break;
                this.mTilemapSlippery = new int[3];
                this.mTilemapSlippery[0] = 0;
                this.mTilemapSlippery[1] = this.getRandomSlipperyMiddleTile();
                this.mTilemapSlippery[2] = 1;
                break;
            }
            case 2: {
                this.mTilemap = new int[4];
                this.mTilemap[0] = this.getRandomStartTile();
                this.mTilemap[1] = this.getRandomMiddleTile();
                this.mTilemap[2] = this.getRandomMiddleTile();
                this.mTilemap[3] = this.getRandomEndTile();
                if (!surface.getSlippery()) break;
                this.mTilemapSlippery = new int[4];
                this.mTilemapSlippery[0] = 0;
                this.mTilemapSlippery[1] = this.getRandomSlipperyMiddleTile();
                this.mTilemapSlippery[2] = this.getRandomSlipperyMiddleTile();
                this.mTilemapSlippery[3] = 1;
            }
        }
    }

    public void draw(Vector2 vector2) {
        int n;
        int n2;
        long l;
        long l2;
        int n3;
        long l3;
        Surface surface = this.mData.getSurface();
        long l4 = (long)surface.getMinX() * 5L >> 1;
        int n4 = (int)((l4 >> 16) - ((l3 = (long)vector2.mX * 5L >> 1) >> 16));
        if (Camera.isInside(n4, n3 = (int)(((l2 = (long)surface.getFirstY() * 5L >> 1) >> 16) - ((l = (long)vector2.mY * 5L >> 1) >> 16)), n2 = 40 * this.mTilemap.length, n = 40)) {
            for (int i = 0; i < this.mTilemap.length; ++i) {
                int n5 = n4 + i * 40 + 20;
                PMImageManager.draw(GameTileMapping.STATIC_PLATFORM_TILES[Defines.mWorldLookup[GameState.mLevel]][this.mTilemap[i]], n5, n3);
                if (this.mTilemapSlippery == null) continue;
                PMImageManager.draw(GameTileMapping.SLIPPERY_TILES[Defines.mWorldLookup[GameState.mLevel]][this.mTilemapSlippery[i]], n5, n3);
            }
        }
    }

    private int getRandomStartTile() {
        int n = PMRandom.get16() * 2 >> 16;
        if (n == 0) {
            return 0;
        }
        return 2;
    }

    private int getRandomEndTile() {
        int n = PMRandom.get16() * 2 >> 16;
        if (n == 0) {
            return 1;
        }
        return 3;
    }

    private int getRandomMiddleTile() {
        int n = PMRandom.get16() * 2 >> 16;
        if (n == 0) {
            return 4;
        }
        return 5;
    }

    private int getRandomSlipperyMiddleTile() {
        int n = PMRandom.get16() * 4 >> 16;
        return n + 2;
    }
}

