/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy1Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy1State;
import dk.progressivemedia.skeleton.game.enemies.Enemy1StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy1View;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy1StateWalking
extends Enemy1State {
    private AABB mTileAABB;

    public Enemy1StateWalking(Enemy1Data enemy1Data, Enemy1View enemy1View, Enemy1StateController enemy1StateController) {
        this.mData = enemy1Data;
        this.mView = enemy1View;
        this.mController = enemy1StateController;
        this.mTileAABB = new AABB();
    }

    public void enter() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mX = this.mData.getDirection() == 1 ? this.mData.getWalkSpeed() : -this.mData.getWalkSpeed();
        vector2.mY = 0;
        this.mView.setAnimState(0);
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        Surface surface = this.mData.getSurfaceRef();
        if (!surface.getSolidity()) {
            this.mController.requestStateChange(0);
        } else {
            int n = this.mData.getSurfaceIndex();
            int n2 = this.mData.getSurfaceOffset();
            int n3 = vector23.mX >> 1;
            n2 += vector2.mX;
            if (n == 0) {
                if (n2 < 0) {
                    this.mController.requestStateChange(0);
                } else if (n2 > n3) {
                    this.mData.setSurfacePosition(++n, n2 -= n3);
                } else {
                    this.mData.setSurfacePosition(n, n2);
                }
            } else if (n == surface.getNumSegments() - 1) {
                if (n2 < 0) {
                    this.mData.setSurfacePosition(n, n2 += surface.getSegmentLength(--n));
                } else if (n2 > n3) {
                    this.mController.requestStateChange(0);
                } else {
                    this.mData.setSurfacePosition(n, n2);
                }
            } else if (n2 < 0) {
                if (--n == 0) {
                    if (this.mData.getTurnAtEdge()) {
                        ++n;
                        vector2.mX = -vector2.mX;
                        this.mData.setDirection(1);
                    } else {
                        n2 += n3;
                    }
                } else {
                    n2 += surface.getSegmentLength(n);
                }
                this.mData.setSurfacePosition(n, n2);
            } else if (n2 > surface.getSegmentLength(n)) {
                if (++n == surface.getNumSegments() - 1 && this.mData.getTurnAtEdge()) {
                    --n;
                    vector2.mX = -vector2.mX;
                    this.mData.setDirection(0);
                } else {
                    n2 -= surface.getSegmentLength(n - 1);
                }
                this.mData.setSurfacePosition(n, n2);
            } else {
                this.mData.setSurfacePosition(n, n2);
            }
            surface.getSurfacePosition(n, n2, vector23.mX >> 1, vector22);
            World world = this.mData.getWorldRef();
            int n4 = 10;
            int n5 = vector22.mX - (vector23.mX >> 1);
            int n6 = vector22.mY - vector23.mY + n4;
            if (world.collisionTest(n5, n6, this.mTileAABB)) {
                this.mData.setSurfacePosition(n, n2 += this.mTileAABB.mMaxX - n5);
                surface.getSurfacePosition(n, n2, vector23.mX >> 1, vector22);
                vector2.mX = -vector2.mX;
                this.mData.setDirection(1);
            }
            if (world.collisionTest(n5 = vector22.mX + (vector23.mX >> 1), n6 = vector22.mY - vector23.mY + n4, this.mTileAABB)) {
                this.mData.setSurfacePosition(n, n2 -= n5 - this.mTileAABB.mMinX);
                surface.getSurfacePosition(n, n2, vector23.mX >> 1, vector22);
                vector2.mX = -vector2.mX;
                this.mData.setDirection(0);
            }
        }
    }
}

