/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.SoundBufferPositional;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.enemies.Enemy4Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy4State;
import dk.progressivemedia.skeleton.game.enemies.Enemy4StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy4View;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy4StateShooting
extends Enemy4State {
    private int mAnticipateTimer;
    private int mSpewTimer;

    public Enemy4StateShooting(Enemy4Data enemy4Data, Enemy4View enemy4View, Enemy4StateController enemy4StateController) {
        this.mData = enemy4Data;
        this.mView = enemy4View;
        this.mController = enemy4StateController;
    }

    public void enter() {
        this.mView.setAnimState(1);
        this.mAnticipateTimer = 500;
        this.mSpewTimer = 500;
    }

    public void exit() {
    }

    public void update() {
        if (this.mAnticipateTimer > 0) {
            this.mAnticipateTimer -= Timer.mDt;
            if (this.mAnticipateTimer <= 0) {
                this.mView.setAnimState(2);
                Vector2 vector2 = this.mData.getPositionRef();
                SoundBufferPositional.play(8, 200, vector2.mX, vector2.mY);
                this.mController.fireBomb();
            }
        } else {
            this.mSpewTimer -= Timer.mDt;
            if (this.mSpewTimer <= 0) {
                this.mController.requestStateChange(0);
            }
        }
    }
}

