/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateSlippery
extends PixelineState {
    private boolean mRunning;

    public PixelineStateSlippery(PixelineData pixelineData, PixelineViewController pixelineViewController, PixelineStateController pixelineStateController) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mController = pixelineStateController;
    }

    public void enter() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mY = 0;
        this.mView.setAnimState(0, false);
        this.mRunning = false;
        World world = this.mData.getWorldRef();
        world.handleEvent((byte)16);
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        int n = this.mData.getRunSpeedMax();
        if (GameState.mAnalogTouch == 1) {
            int n2 = InputProxy.getAnalogX();
            if (n2 == 0) {
                vector2.mX = PMMath.MUL(vector2.mX, this.mData.getSlipperyBrakeDamping());
                if (this.mRunning) {
                    this.mView.setAnimState(0, false);
                }
                this.mRunning = false;
            } else {
                if (!this.mRunning) {
                    this.mView.setAnimState(2, false);
                }
                this.mRunning = true;
                if (this.mData.getDirection() == 0) {
                    if (n2 < 0) {
                        if (vector2.mX > -n) {
                            vector2.mX += PMMath.MUL(this.mData.getSlipperyRunSpeedAcceleration(), n2);
                        }
                    } else if (n2 > 0) {
                        this.mData.setDirection(1);
                    }
                } else if (n2 > 0) {
                    if (vector2.mX < n) {
                        vector2.mX += PMMath.MUL(this.mData.getSlipperyRunSpeedAcceleration(), n2);
                    }
                } else if (n2 < 0) {
                    this.mData.setDirection(0);
                }
            }
        } else if (!InputProxy.isHeldLeft() && !InputProxy.isHeldRight()) {
            vector2.mX = PMMath.MUL(vector2.mX, this.mData.getSlipperyBrakeDamping());
            if (this.mRunning) {
                this.mView.setAnimState(0, false);
            }
            this.mRunning = false;
        } else {
            if (!this.mRunning) {
                this.mView.setAnimState(2, false);
            }
            this.mRunning = true;
            if (this.mData.getDirection() == 0) {
                if (InputProxy.isHeldLeft()) {
                    if (vector2.mX > -n) {
                        vector2.mX -= this.mData.getSlipperyRunSpeedAcceleration();
                    }
                } else if (InputProxy.isHeldRight()) {
                    this.mData.setDirection(1);
                }
            } else if (InputProxy.isHeldRight()) {
                if (vector2.mX < n) {
                    vector2.mX += this.mData.getSlipperyRunSpeedAcceleration();
                }
            } else if (InputProxy.isHeldLeft()) {
                this.mData.setDirection(0);
            }
        }
        if (PMCanvas.PMInput_isPressed(1) || PMCanvas.PMInput_isPressed(128) || PMCanvas.PMInput_isPressed(256) || this.mData.getJumpButtonPressed() || this.mData.getJumpButtonDown()) {
            vector2.mY = this.mData.getJumpVelocity();
            this.mController.requestStateChange(3);
            switch (this.mData.getTotemState()) {
                case 0: {
                    SoundBuffer.play(26, 100);
                    break;
                }
                case 1: {
                    SoundBuffer.play(25, 100);
                    break;
                }
                case 2: {
                    SoundBuffer.play(22, 100);
                    break;
                }
                case 3: {
                    SoundBuffer.play(23, 100);
                }
            }
        }
    }
}

