/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.Util;

public class InputProxy {
    public static final int PAD_MAX_X = 41;
    public static final int PAD_MAX_Y = 2;
    public static final int DPAD_MARGIN_X = 12;
    public static final int DPAD_MARGIN_Y = 14;
    public static int mPadX;
    public static int mPadY;
    public static int mMasterAlpha;

    public static void init() {
        mPadY = 0;
        mPadX = 0;
        mMasterAlpha = 65536;
    }

    public static boolean isPressedFire() {
        return PMCanvas.PMInput_isPressed(1);
    }

    public static boolean isHeldFire() {
        return PMCanvas.PMInput_isHeld(1);
    }

    public static boolean isReleasedFire() {
        return PMCanvas.PMInput_isReleased(1);
    }

    public static boolean isPressedFire2() {
        return PMCanvas.PMInput_isPressed(2);
    }

    public static boolean isHeldFire2() {
        return PMCanvas.PMInput_isHeld(2);
    }

    public static boolean isReleasedFire2() {
        return PMCanvas.PMInput_isReleased(2);
    }

    public static boolean isPressedOK() {
        return PMCanvas.PMInput_isPressed(2048);
    }

    public static boolean isHeldOK() {
        return PMCanvas.PMInput_isHeld(2048);
    }

    public static boolean isReleasedOK() {
        return PMCanvas.PMInput_isReleased(2048);
    }

    public static boolean isPressedCancel() {
        return PMCanvas.PMInput_isPressed(4096);
    }

    public static boolean isHeldCancel() {
        return PMCanvas.PMInput_isHeld(4096);
    }

    public static boolean isReleasedCancel() {
        return PMCanvas.PMInput_isReleased(4096);
    }

    public static boolean isPressedBack() {
        return PMCanvas.PMInput_isPressed(4);
    }

    public static boolean isHeldBack() {
        return PMCanvas.PMInput_isHeld(4);
    }

    public static boolean isReleasedBack() {
        return PMCanvas.PMInput_isReleased(4);
    }

    public static boolean isPressedLeft() {
        return PMCanvas.PMInput_isPressed(8) || PMCanvas.PMInput_isPressed(128);
    }

    public static boolean isHeldLeft() {
        return PMCanvas.PMInput_isHeld(8) || PMCanvas.PMInput_isHeld(128) || mPadX < -20;
    }

    public static boolean isPressedRight() {
        return PMCanvas.PMInput_isPressed(16) || PMCanvas.PMInput_isPressed(256);
    }

    public static boolean isHeldRight() {
        return PMCanvas.PMInput_isHeld(16) || PMCanvas.PMInput_isHeld(256) || mPadX > 20;
    }

    public static boolean isPressedUp() {
        return PMCanvas.PMInput_isPressed(32);
    }

    public static boolean isHeldUp() {
        return PMCanvas.PMInput_isHeld(32);
    }

    public static boolean isPressedDown() {
        return PMCanvas.PMInput_isPressed(64);
    }

    public static boolean isHeldDown() {
        return PMCanvas.PMInput_isHeld(64);
    }

    public static int getAnalogX() {
        int n = 0;
        n = PMCanvas.PMInput_isHeld(8) ? -65536 : (PMCanvas.PMInput_isHeld(16) ? 65536 : PMMath.DIV(mPadX << 16, 0x290000));
        return n;
    }

    public static void setMasterAlpha(int n) {
        mMasterAlpha = n;
    }

    public static void drawTouchInput(boolean bl) {
        if (GameState.mAnalogTouch == 0) {
            InputProxy.drawTouchInputDigital(bl);
            return;
        }
        if (Touch.touchX != -1 && Touch.touchY != -1) {
            int n = 90;
            int n2 = 308;
            int n3 = PMMath.FxPtoInt(PMMath.MUL(Touch.touchX, PMMath.FP(320)));
            int n4 = PMMath.FxPtoInt(PMMath.MUL(Touch.touchY, PMMath.FP(360)));
            int n5 = n3 - n;
            int n6 = n4 - n2;
            InputProxy.drawTouchInput(n, n2, n5, n6, true);
        } else {
            int n = 90;
            int n7 = 308;
            InputProxy.drawTouchInput(n, n7, 0, 0, true);
        }
    }

    private static void drawTouchInput(int n, int n2, int n3, int n4, boolean bl) {
        n3 = Util.Clamp(n3, -41, 41);
        n4 = !bl ? Util.Clamp(n4, -2, 2) : 0;
        mPadX = n3;
        mPadY = n4;
        PMImageManager.draw(3, n, n2, false, 0, mMasterAlpha);
        PMImageManager.draw(2, n + n3, n2 + n4, false, 0, mMasterAlpha);
    }

    private static void drawTouchInputDigital(boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = PMMath.MUL(5120, 0x2800000) >> 16;
            n = PMMath.MUL(23665, 23592960) >> 16;
            PMImageManager.draw(6, n2, n, false, 0, mMasterAlpha);
            n2 = PMMath.MUL(60415, 0x2800000) >> 16;
            n = PMMath.MUL(23665, 23592960) >> 16;
            PMImageManager.draw(7, n2, n, false, 0, mMasterAlpha);
        }
        n2 = PMMath.MUL(5120, 0x2800000) >> 16;
        n = PMMath.MUL(41869, 23592960) >> 16;
        PMImageManager.draw(4, n2, n, false, 0, mMasterAlpha);
        n2 = PMMath.MUL(60415, 0x2800000) >> 16;
        n = PMMath.MUL(41869, 23592960) >> 16;
        PMImageManager.draw(5, n2, n, false, 0, mMasterAlpha);
        mPadX = 0;
        mPadY = 0;
    }
}

