/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMTrigonometry;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceCtrl;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class SurfaceMovementCtrlCircular
extends SurfaceCtrl {
    private Vector2 mPivotPosition;
    private int mDistance;
    private int mAngle;
    private int mSpeed;
    private int mPrevPositionX;
    private int mPrevPositionY;
    private boolean mStarted;
    private int mStartingAngle;

    public SurfaceMovementCtrlCircular(PlatformData platformData, Vector2 vector2, int n, int n2, int n3, int n4, boolean bl) {
        this.mData = platformData;
        this.mPivotPosition = vector2;
        this.mDistance = n;
        this.mAngle = n2;
        this.mSpeed = n3 * n4;
        this.mStartingAngle = this.mAngle;
        int n5 = PMMath.MUL(this.mAngle, MathUtil.TO_DEGREE) >> 16;
        this.mPrevPositionX = this.mPivotPosition.mX + PMMath.MUL(this.mDistance, PMTrigonometry.cos(n5));
        this.mPrevPositionY = this.mPivotPosition.mY + PMMath.MUL(this.mDistance, PMTrigonometry.sin(n5));
        this.mStarted = bl;
    }

    public void update() {
        Surface surface = this.mData.getSurface();
        if (!this.mStarted) {
            if (surface.getPlayerTouching()) {
                this.mStarted = true;
            }
        } else {
            this.mAngle += (this.mSpeed << 6) / 33 * Timer.mDt >> 6;
            if (this.mAngle > 411774) {
                this.mAngle -= 411774;
            } else if (this.mAngle < 0) {
                this.mAngle += 411774;
            }
            int n = PMMath.MUL(this.mAngle, MathUtil.TO_DEGREE);
            int n2 = n >> 16;
            int n3 = n2 + 1;
            if (n3 >= 360) {
                n3 -= 360;
            }
            int n4 = n % 65536;
            int n5 = PMTrigonometry.cos(n2);
            int n6 = PMTrigonometry.cos(n3);
            int n7 = n5 + PMMath.MUL(n6 - n5, n4);
            int n8 = PMTrigonometry.sin(n2);
            int n9 = PMTrigonometry.sin(n3);
            int n10 = n8 + PMMath.MUL(n9 - n8, n4);
            int n11 = this.mPivotPosition.mX + PMMath.MUL(this.mDistance, n7);
            int n12 = this.mPivotPosition.mY + PMMath.MUL(this.mDistance, n10);
            surface.move(n11 - this.mPrevPositionX, n12 - this.mPrevPositionY);
            this.mPrevPositionX = n11;
            this.mPrevPositionY = n12;
        }
    }
}

