/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.enemies.Enemy6Data;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Enemy6View {
    protected Enemy6Data mData;
    public static final int STATE_ANIM_IDLE = 0;
    public static final int STATE_ANIM_ANTICIPATE = 1;
    public static final int STATE_ANIM_SPIKES = 2;
    public static final int STATE_ANIM_SPIKES_RETRACT = 3;
    public static final int STATE_ANIM_DIE = 4;
    private int mAnimState;
    private Movie mAnimSpikedRetract;
    private boolean mRetracting;

    public Enemy6View(Enemy6Data enemy6Data) {
        this.mData = enemy6Data;
        this.mAnimSpikedRetract = Movie.load((short)28839);
        this.mAnimSpikedRetract.loadGfx();
        PMImageManager.load(49);
    }

    public void update() {
        switch (this.mAnimState) {
            case 3: {
                this.mAnimSpikedRetract.update(Timer.mDt);
                if (!this.mAnimSpikedRetract.isDone()) break;
                this.mRetracting = false;
            }
        }
    }

    public void draw(Vector2 vector2) {
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        long l = (long)vector22.mX * 5L >> 1;
        long l2 = (long)vector2.mX * 5L >> 1;
        int n = (int)((l >> 16) - (l2 >> 16));
        int n2 = 80;
        long l3 = (long)vector22.mY * 5L >> 1;
        long l4 = (long)vector2.mY * 5L >> 1;
        int n3 = (int)((l3 >> 16) - (l4 >> 16));
        int n4 = 80;
        if (Camera.isInside(n - (n2 >> 1), n3 - n4, n2, n4)) {
            switch (this.mAnimState) {
                case 0: {
                    PMImageManager.draw(50, n, n3);
                    break;
                }
                case 1: {
                    PMImageManager.draw(51, n, n3);
                    break;
                }
                case 2: {
                    PMImageManager.draw(52, n, n3);
                    break;
                }
                case 3: {
                    this.mAnimSpikedRetract.draw(n, n3);
                    break;
                }
                case 4: {
                    PMImageManager.draw(49, n, n3);
                }
            }
        }
    }

    public void setAnimState(int n) {
        this.mAnimState = n;
        this.mAnimSpikedRetract.gotoTick(0);
        switch (n) {
            case 3: {
                this.mRetracting = true;
            }
        }
    }

    public boolean isRetractDone() {
        return !this.mRetracting;
    }
}

