/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.particles;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.math.Vector2;

public class ParticleSystem {
    public static final int PARTICLE_TYPE_BRAKE_SMOKE = 0;
    public static final int PARTICLE_TYPE_LANDING = 1;
    public static final int PARTICLE_TYPE_BLINK = 2;
    public static final int PARTICLE_TYPE_GOLD_DUST = 3;
    private static short[] AnimationBrakeSmoke = new short[]{59, 60, 61, 62, 63};
    private static short[] AnimationCoinBlink = new short[]{64, 65, 66};
    private static short[] AnimationGoldDust = new short[]{67, 68, 69, 70};
    private int[] mFree;
    private int mCurFreeSlot;
    private int mNumParticles;
    private boolean[] mActive;
    private int[] mType;
    private boolean[] mTransformed;
    private int[] mX;
    private int[] mY;
    private int[] mVelocityX;
    private int[] mVelocityY;
    private short[][] mAnimation;
    private int[] mAnimationFrame;
    private int[] mFrameTime;
    private int[] mTimer;
    private int[] mInitialDelay;
    private int[] mTarget;

    public ParticleSystem(int n) {
        this.mNumParticles = n;
        this.mFree = new int[this.mNumParticles];
        for (int i = 0; i < this.mNumParticles; ++i) {
            this.mFree[i] = i == this.mNumParticles - 1 ? -1 : i + 1;
        }
        this.mCurFreeSlot = 0;
        this.mActive = new boolean[this.mNumParticles];
        this.mType = new int[this.mNumParticles];
        this.mTransformed = new boolean[this.mNumParticles];
        this.mX = new int[this.mNumParticles];
        this.mY = new int[this.mNumParticles];
        this.mVelocityX = new int[this.mNumParticles];
        this.mVelocityY = new int[this.mNumParticles];
        this.mAnimation = new short[this.mNumParticles][0];
        this.mAnimationFrame = new int[this.mNumParticles];
        this.mFrameTime = new int[this.mNumParticles];
        this.mTimer = new int[this.mNumParticles];
        this.mInitialDelay = new int[this.mNumParticles];
        this.mTarget = new int[this.mNumParticles];
        PMImageManager.load(59, 12);
    }

    public void spawnParticle(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.mCurFreeSlot;
        if (n8 >= 0) {
            this.mCurFreeSlot = this.mFree[n8];
            this.mActive[n8] = true;
            this.mType[n8] = n;
            this.mTransformed[n8] = bl;
            this.mX[n8] = n2;
            this.mY[n8] = n3;
            this.mVelocityX[n8] = n4;
            this.mVelocityY[n8] = n5;
            this.mAnimationFrame[n8] = 0;
            this.mTimer[n8] = 0;
            this.mInitialDelay[n8] = n6;
            this.mTarget[n8] = n7;
            switch (n) {
                case 0: {
                    this.mAnimation[n8] = AnimationBrakeSmoke;
                    this.mFrameTime[n8] = 66;
                    break;
                }
                case 1: {
                    this.mAnimation[n8] = AnimationBrakeSmoke;
                    this.mFrameTime[n8] = 66;
                    break;
                }
                case 2: {
                    this.mAnimation[n8] = AnimationCoinBlink;
                    this.mFrameTime[n8] = 99;
                    break;
                }
                case 3: {
                    this.mAnimation[n8] = AnimationGoldDust;
                    this.mFrameTime[n8] = 99;
                }
            }
        }
    }

    public void update() {
        for (int i = 0; i < this.mNumParticles; ++i) {
            if (!this.mActive[i]) continue;
            if (this.mInitialDelay[i] > 0) {
                int n = i;
                this.mInitialDelay[n] = this.mInitialDelay[n] - Timer.mDt;
                if (this.mInitialDelay[i] >= 0) continue;
                this.mInitialDelay[i] = 0;
                continue;
            }
            int n = i;
            this.mTimer[n] = this.mTimer[n] + Timer.mDt;
            if (this.mTimer[i] >= this.mFrameTime[i]) {
                int n2 = 0;
                do {
                    int n3 = i;
                    this.mTimer[n3] = this.mTimer[n3] - this.mFrameTime[i];
                    ++n2;
                } while (this.mTimer[i] >= this.mFrameTime[i]);
                int n4 = i;
                this.mAnimationFrame[n4] = this.mAnimationFrame[n4] + n2;
            }
            if (this.mAnimationFrame[i] >= this.mAnimation[i].length) {
                this.mActive[i] = false;
                this.mFree[i] = this.mCurFreeSlot;
                this.mCurFreeSlot = i;
                continue;
            }
            switch (this.mType[i]) {
                case 1: {
                    int n5 = i;
                    this.mVelocityY[n5] = this.mVelocityY[n5] + Timer.mFeatureWorldGravity;
                    if (this.mVelocityY[i] <= Timer.mFeatureWorldGravityMax) break;
                    this.mVelocityY[i] = Timer.mFeatureWorldGravityMax;
                }
            }
            int n6 = i;
            this.mX[n6] = this.mX[n6] + this.mVelocityX[i];
            int n7 = i;
            this.mY[n7] = this.mY[n7] + this.mVelocityY[i];
        }
    }

    public void draw(Vector2 vector2) {
        int n = -1;
        long l = (long)vector2.mX * 5L >> 1;
        long l2 = (long)vector2.mY * 5L >> 1;
        for (int i = 0; i < this.mNumParticles; ++i) {
            if (!this.mActive[i] || this.mInitialDelay[i] > 0) continue;
            int n2 = this.mX[i];
            int n3 = this.mY[i];
            if (!this.mTransformed[i]) {
                long l3 = (long)n2 * 5L >> 1;
                long l4 = (long)n3 * 5L >> 1;
                n2 = (int)((l3 >> 16) - (l >> 16));
                n3 = (int)((l4 >> 16) - (l2 >> 16));
            }
            if (n != this.mTarget[i]) {
                n = this.mTarget[i];
            }
            PMImageManager.draw(this.mAnimation[i][this.mAnimationFrame[i]], n2, n3);
        }
    }
}

