/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.Vector2;

public class Pixeline {
    private PixelineData mData;
    private PixelineViewController mViewController;
    private PixelineStateController mStateController;

    public Pixeline(World world, Vector2 vector2) {
        this.mData = new PixelineData(world);
        this.mViewController = new PixelineViewController(this.mData);
        this.mStateController = new PixelineStateController(this.mData, this.mViewController, vector2);
    }

    public PixelineData getDataRef() {
        return this.mData;
    }

    public void update() {
        this.mStateController.update();
        this.mViewController.update();
    }

    public void drawAlive(Vector2 vector2) {
        if (this.mData.isAlive()) {
            this.mViewController.draw(vector2);
        }
    }

    public void drawDead(Vector2 vector2) {
        if (!this.mData.isAlive()) {
            this.mViewController.draw(vector2);
        }
    }

    public boolean eventRequestTransform(int n) {
        World world = this.mData.getWorldRef();
        if (n == 1 && !GameState.isTotem1Unlocked() || n == 2 && !GameState.isTotem2Unlocked() || n == 3 && !GameState.isTotem3Unlocked()) {
            world.handleEvent((byte)23);
            return false;
        }
        if (n == this.mData.getTotemState()) {
            return false;
        }
        this.mStateController.requestTotemTransition(n);
        return true;
    }

    public void eventTakeDamage() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mX = 0;
        vector2.mY = 0;
        this.mStateController.pushEvent(4, 0);
        if (this.mData.getTotemState() != 0) {
            this.mStateController.pushEvent(0, 0);
            this.mStateController.pushEvent(1, 300);
        } else {
            this.mStateController.pushEvent(3, 8);
        }
        this.mStateController.pushEvent(6, 120);
        this.mStateController.pushEvent(1, 1000);
        this.mStateController.pushEvent(6, 60);
        this.mStateController.pushEvent(1, 1000);
        this.mStateController.pushEvent(5, 0);
        this.mStateController.pushEvent(7, 0);
    }

    public void eventDie() {
        this.mStateController.requestStateChange(4);
    }

    public void eventJumpOnEnemy() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mY = this.mData.getJumpVelocity();
        this.mStateController.requestStateChange(3);
        switch (this.mData.getTotemState()) {
            case 0: {
                SoundBuffer.play(26, 100);
                break;
            }
            case 1: {
                SoundBuffer.play(25, 100);
                break;
            }
            case 2: {
                SoundBuffer.play(22, 100);
                break;
            }
            case 3: {
                SoundBuffer.play(23, 100);
            }
        }
    }

    public void eventWin() {
        this.mStateController.requestStateChange(5);
    }
}

